#[doc = "Register `DIEP0INTF` reader"]
pub struct R(crate::R<DIEP0INTF_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DIEP0INTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DIEP0INTF_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DIEP0INTF_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DIEP0INTF` writer"]
pub struct W(crate::W<DIEP0INTF_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DIEP0INTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DIEP0INTF_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DIEP0INTF_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TXFE` reader - Transmit FIFO empty"]
pub struct TXFE_R(crate::FieldReader<bool, bool>);
impl TXFE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXFE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXFE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IEPNE` reader - IN endpoint NAK effective"]
pub struct IEPNE_R(crate::FieldReader<bool, bool>);
impl IEPNE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        IEPNE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IEPNE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IEPNE` writer - IN endpoint NAK effective"]
pub struct IEPNE_W<'a> {
    w: &'a mut W,
}
impl<'a> IEPNE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `EPTXFUD` reader - Endpoint Tx FIFO underrun"]
pub struct EPTXFUD_R(crate::FieldReader<bool, bool>);
impl EPTXFUD_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        EPTXFUD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EPTXFUD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EPTXFUD` writer - Endpoint Tx FIFO underrun"]
pub struct EPTXFUD_W<'a> {
    w: &'a mut W,
}
impl<'a> EPTXFUD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `CITO` reader - Control in timeout interrupt"]
pub struct CITO_R(crate::FieldReader<bool, bool>);
impl CITO_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CITO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CITO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CITO` writer - Control in timeout interrupt"]
pub struct CITO_W<'a> {
    w: &'a mut W,
}
impl<'a> CITO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `EPDIS` reader - Endpoint finished"]
pub struct EPDIS_R(crate::FieldReader<bool, bool>);
impl EPDIS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        EPDIS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EPDIS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EPDIS` writer - Endpoint finished"]
pub struct EPDIS_W<'a> {
    w: &'a mut W,
}
impl<'a> EPDIS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `TF` reader - Transfer finished"]
pub struct TF_R(crate::FieldReader<bool, bool>);
impl TF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TF` writer - Transfer finished"]
pub struct TF_W<'a> {
    w: &'a mut W,
}
impl<'a> TF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 7 - Transmit FIFO empty"]
    #[inline(always)]
    pub fn txfe(&self) -> TXFE_R {
        TXFE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - IN endpoint NAK effective"]
    #[inline(always)]
    pub fn iepne(&self) -> IEPNE_R {
        IEPNE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Endpoint Tx FIFO underrun"]
    #[inline(always)]
    pub fn eptxfud(&self) -> EPTXFUD_R {
        EPTXFUD_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Control in timeout interrupt"]
    #[inline(always)]
    pub fn cito(&self) -> CITO_R {
        CITO_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Endpoint finished"]
    #[inline(always)]
    pub fn epdis(&self) -> EPDIS_R {
        EPDIS_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Transfer finished"]
    #[inline(always)]
    pub fn tf(&self) -> TF_R {
        TF_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 6 - IN endpoint NAK effective"]
    #[inline(always)]
    pub fn iepne(&mut self) -> IEPNE_W {
        IEPNE_W { w: self }
    }
    #[doc = "Bit 4 - Endpoint Tx FIFO underrun"]
    #[inline(always)]
    pub fn eptxfud(&mut self) -> EPTXFUD_W {
        EPTXFUD_W { w: self }
    }
    #[doc = "Bit 3 - Control in timeout interrupt"]
    #[inline(always)]
    pub fn cito(&mut self) -> CITO_W {
        CITO_W { w: self }
    }
    #[doc = "Bit 1 - Endpoint finished"]
    #[inline(always)]
    pub fn epdis(&mut self) -> EPDIS_W {
        EPDIS_W { w: self }
    }
    #[doc = "Bit 0 - Transfer finished"]
    #[inline(always)]
    pub fn tf(&mut self) -> TF_W {
        TF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "device endpoint-0 interrupt register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [diep0intf](index.html) module"]
pub struct DIEP0INTF_SPEC;
impl crate::RegisterSpec for DIEP0INTF_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [diep0intf::R](R) reader structure"]
impl crate::Readable for DIEP0INTF_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [diep0intf::W](W) writer structure"]
impl crate::Writable for DIEP0INTF_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DIEP0INTF to value 0x80"]
impl crate::Resettable for DIEP0INTF_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x80
    }
}
