#[doc = "Register `DAEPINTEN` reader"]
pub struct R(crate::R<DAEPINTEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DAEPINTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DAEPINTEN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DAEPINTEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DAEPINTEN` writer"]
pub struct W(crate::W<DAEPINTEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DAEPINTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DAEPINTEN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DAEPINTEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `IEPIE` reader - IN EP interrupt interrupt enable bits"]
pub struct IEPIE_R(crate::FieldReader<u8, u8>);
impl IEPIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        IEPIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IEPIE_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IEPIE` writer - IN EP interrupt interrupt enable bits"]
pub struct IEPIE_W<'a> {
    w: &'a mut W,
}
impl<'a> IEPIE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
        self.w
    }
}
#[doc = "Field `OEPIE` reader - OUT endpoint interrupt enable bits"]
pub struct OEPIE_R(crate::FieldReader<u8, u8>);
impl OEPIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        OEPIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OEPIE_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OEPIE` writer - OUT endpoint interrupt enable bits"]
pub struct OEPIE_W<'a> {
    w: &'a mut W,
}
impl<'a> OEPIE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 16)) | ((value as u32 & 0x0f) << 16);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - IN EP interrupt interrupt enable bits"]
    #[inline(always)]
    pub fn iepie(&self) -> IEPIE_R {
        IEPIE_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 16:19 - OUT endpoint interrupt enable bits"]
    #[inline(always)]
    pub fn oepie(&self) -> OEPIE_R {
        OEPIE_R::new(((self.bits >> 16) & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bits 0:3 - IN EP interrupt interrupt enable bits"]
    #[inline(always)]
    pub fn iepie(&mut self) -> IEPIE_W {
        IEPIE_W { w: self }
    }
    #[doc = "Bits 16:19 - OUT endpoint interrupt enable bits"]
    #[inline(always)]
    pub fn oepie(&mut self) -> OEPIE_W {
        OEPIE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Device all endpoints interrupt enable register (DAEPINTEN)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [daepinten](index.html) module"]
pub struct DAEPINTEN_SPEC;
impl crate::RegisterSpec for DAEPINTEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [daepinten::R](R) reader structure"]
impl crate::Readable for DAEPINTEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [daepinten::W](W) writer structure"]
impl crate::Writable for DAEPINTEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DAEPINTEN to value 0"]
impl crate::Resettable for DAEPINTEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
