#[doc = "Register `QCTL` reader"]
pub struct R(crate::R<QCTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<QCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<QCTL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<QCTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `QCTL` writer"]
pub struct W(crate::W<QCTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<QCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<QCTL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<QCTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `IO23_DRV` reader - Drive IO2 and IO3 enable"]
pub struct IO23_DRV_R(crate::FieldReader<bool, bool>);
impl IO23_DRV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        IO23_DRV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IO23_DRV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IO23_DRV` writer - Drive IO2 and IO3 enable"]
pub struct IO23_DRV_W<'a> {
    w: &'a mut W,
}
impl<'a> IO23_DRV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `QRD` reader - Quad-SPI mode read select"]
pub struct QRD_R(crate::FieldReader<bool, bool>);
impl QRD_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        QRD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for QRD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `QRD` writer - Quad-SPI mode read select"]
pub struct QRD_W<'a> {
    w: &'a mut W,
}
impl<'a> QRD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `QMOD` reader - Quad-SPI mode enable"]
pub struct QMOD_R(crate::FieldReader<bool, bool>);
impl QMOD_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        QMOD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for QMOD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `QMOD` writer - Quad-SPI mode enable"]
pub struct QMOD_W<'a> {
    w: &'a mut W,
}
impl<'a> QMOD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 2 - Drive IO2 and IO3 enable"]
    #[inline(always)]
    pub fn io23_drv(&self) -> IO23_DRV_R {
        IO23_DRV_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Quad-SPI mode read select"]
    #[inline(always)]
    pub fn qrd(&self) -> QRD_R {
        QRD_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Quad-SPI mode enable"]
    #[inline(always)]
    pub fn qmod(&self) -> QMOD_R {
        QMOD_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - Drive IO2 and IO3 enable"]
    #[inline(always)]
    pub fn io23_drv(&mut self) -> IO23_DRV_W {
        IO23_DRV_W { w: self }
    }
    #[doc = "Bit 1 - Quad-SPI mode read select"]
    #[inline(always)]
    pub fn qrd(&mut self) -> QRD_W {
        QRD_W { w: self }
    }
    #[doc = "Bit 0 - Quad-SPI mode enable"]
    #[inline(always)]
    pub fn qmod(&mut self) -> QMOD_W {
        QMOD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Quad-SPI mode control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [qctl](index.html) module"]
pub struct QCTL_SPEC;
impl crate::RegisterSpec for QCTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [qctl::R](R) reader structure"]
impl crate::Readable for QCTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [qctl::W](W) writer structure"]
impl crate::Writable for QCTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets QCTL to value 0"]
impl crate::Resettable for QCTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
