#[doc = "Register `STAT` reader"]
pub struct R(crate::R<STAT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<STAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<STAT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<STAT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `CCRCERR` reader - Command response received"]
pub struct CCRCERR_R(crate::FieldReader<bool, bool>);
impl CCRCERR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CCRCERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CCRCERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTCRCERR` reader - Data block sent/received"]
pub struct DTCRCERR_R(crate::FieldReader<bool, bool>);
impl DTCRCERR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTCRCERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTCRCERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMDTMOUT` reader - Command response timeout"]
pub struct CMDTMOUT_R(crate::FieldReader<bool, bool>);
impl CMDTMOUT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CMDTMOUT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMDTMOUT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTTMOUT` reader - Data timeout"]
pub struct DTTMOUT_R(crate::FieldReader<bool, bool>);
impl DTTMOUT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTTMOUT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTTMOUT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXURE` reader - Transmit FIFO underrun error occurs"]
pub struct TXURE_R(crate::FieldReader<bool, bool>);
impl TXURE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXURE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXURE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXORE` reader - Received FIFO overrun error occurs"]
pub struct RXORE_R(crate::FieldReader<bool, bool>);
impl RXORE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RXORE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXORE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMDRECV` reader - Command response received"]
pub struct CMDRECV_R(crate::FieldReader<bool, bool>);
impl CMDRECV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CMDRECV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMDRECV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMDSEND` reader - Command sent"]
pub struct CMDSEND_R(crate::FieldReader<bool, bool>);
impl CMDSEND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CMDSEND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMDSEND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTEND` reader - Data end"]
pub struct DTEND_R(crate::FieldReader<bool, bool>);
impl DTEND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTEND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTEND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STBITE` reader - Start bit error in the bus"]
pub struct STBITE_R(crate::FieldReader<bool, bool>);
impl STBITE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        STBITE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STBITE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTBLKEND` reader - Data block sent/received"]
pub struct DTBLKEND_R(crate::FieldReader<bool, bool>);
impl DTBLKEND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTBLKEND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTBLKEND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMDRUN` reader - Command transmission in progress"]
pub struct CMDRUN_R(crate::FieldReader<bool, bool>);
impl CMDRUN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CMDRUN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMDRUN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXRUN` reader - Data transmission in progress"]
pub struct TXRUN_R(crate::FieldReader<bool, bool>);
impl TXRUN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXRUN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXRUN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXRUN` reader - Data reception in progress"]
pub struct RXRUN_R(crate::FieldReader<bool, bool>);
impl RXRUN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RXRUN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXRUN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFH` reader - Transmit FIFO is half empty"]
pub struct TFH_R(crate::FieldReader<bool, bool>);
impl TFH_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TFH_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFH_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFH` reader - Receive FIFO is half full"]
pub struct RFH_R(crate::FieldReader<bool, bool>);
impl RFH_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RFH_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFH_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFF` reader - Transmit FIFO is full"]
pub struct TFF_R(crate::FieldReader<bool, bool>);
impl TFF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TFF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFF` reader - Receive FIFO is full"]
pub struct RFF_R(crate::FieldReader<bool, bool>);
impl RFF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RFF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFE` reader - Transmit FIFO is empty"]
pub struct TFE_R(crate::FieldReader<bool, bool>);
impl TFE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TFE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFE` reader - Receive FIFO is empty"]
pub struct RFE_R(crate::FieldReader<bool, bool>);
impl RFE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RFE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXDTVAL` reader - Data is valid in transmit FIFO"]
pub struct TXDTVAL_R(crate::FieldReader<bool, bool>);
impl TXDTVAL_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXDTVAL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXDTVAL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXDTVAL` reader - Data is valid in receive FIFO"]
pub struct RXDTVAL_R(crate::FieldReader<bool, bool>);
impl RXDTVAL_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RXDTVAL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXDTVAL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SDIOINT` reader - SD I/O interrupt received"]
pub struct SDIOINT_R(crate::FieldReader<bool, bool>);
impl SDIOINT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SDIOINT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SDIOINT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ATAEND` reader - CE-ATA command completion signal received"]
pub struct ATAEND_R(crate::FieldReader<bool, bool>);
impl ATAEND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ATAEND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ATAEND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - Command response received"]
    #[inline(always)]
    pub fn ccrcerr(&self) -> CCRCERR_R {
        CCRCERR_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Data block sent/received"]
    #[inline(always)]
    pub fn dtcrcerr(&self) -> DTCRCERR_R {
        DTCRCERR_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Command response timeout"]
    #[inline(always)]
    pub fn cmdtmout(&self) -> CMDTMOUT_R {
        CMDTMOUT_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Data timeout"]
    #[inline(always)]
    pub fn dttmout(&self) -> DTTMOUT_R {
        DTTMOUT_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Transmit FIFO underrun error occurs"]
    #[inline(always)]
    pub fn txure(&self) -> TXURE_R {
        TXURE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Received FIFO overrun error occurs"]
    #[inline(always)]
    pub fn rxore(&self) -> RXORE_R {
        RXORE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Command response received"]
    #[inline(always)]
    pub fn cmdrecv(&self) -> CMDRECV_R {
        CMDRECV_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Command sent"]
    #[inline(always)]
    pub fn cmdsend(&self) -> CMDSEND_R {
        CMDSEND_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Data end"]
    #[inline(always)]
    pub fn dtend(&self) -> DTEND_R {
        DTEND_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Start bit error in the bus"]
    #[inline(always)]
    pub fn stbite(&self) -> STBITE_R {
        STBITE_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Data block sent/received"]
    #[inline(always)]
    pub fn dtblkend(&self) -> DTBLKEND_R {
        DTBLKEND_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Command transmission in progress"]
    #[inline(always)]
    pub fn cmdrun(&self) -> CMDRUN_R {
        CMDRUN_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Data transmission in progress"]
    #[inline(always)]
    pub fn txrun(&self) -> TXRUN_R {
        TXRUN_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Data reception in progress"]
    #[inline(always)]
    pub fn rxrun(&self) -> RXRUN_R {
        RXRUN_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Transmit FIFO is half empty"]
    #[inline(always)]
    pub fn tfh(&self) -> TFH_R {
        TFH_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Receive FIFO is half full"]
    #[inline(always)]
    pub fn rfh(&self) -> RFH_R {
        RFH_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Transmit FIFO is full"]
    #[inline(always)]
    pub fn tff(&self) -> TFF_R {
        TFF_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Receive FIFO is full"]
    #[inline(always)]
    pub fn rff(&self) -> RFF_R {
        RFF_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Transmit FIFO is empty"]
    #[inline(always)]
    pub fn tfe(&self) -> TFE_R {
        TFE_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Receive FIFO is empty"]
    #[inline(always)]
    pub fn rfe(&self) -> RFE_R {
        RFE_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Data is valid in transmit FIFO"]
    #[inline(always)]
    pub fn txdtval(&self) -> TXDTVAL_R {
        TXDTVAL_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 21 - Data is valid in receive FIFO"]
    #[inline(always)]
    pub fn rxdtval(&self) -> RXDTVAL_R {
        RXDTVAL_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 22 - SD I/O interrupt received"]
    #[inline(always)]
    pub fn sdioint(&self) -> SDIOINT_R {
        SDIOINT_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 23 - CE-ATA command completion signal received"]
    #[inline(always)]
    pub fn ataend(&self) -> ATAEND_R {
        ATAEND_R::new(((self.bits >> 23) & 0x01) != 0)
    }
}
#[doc = "Status register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [stat](index.html) module"]
pub struct STAT_SPEC;
impl crate::RegisterSpec for STAT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [stat::R](R) reader structure"]
impl crate::Readable for STAT_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets STAT to value 0"]
impl crate::Resettable for STAT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
