#[doc = "Register `CMDCTL` reader"]
pub struct R(crate::R<CMDCTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CMDCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CMDCTL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CMDCTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CMDCTL` writer"]
pub struct W(crate::W<CMDCTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CMDCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CMDCTL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CMDCTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CMDIDX` reader - Command index"]
pub struct CMDIDX_R(crate::FieldReader<u8, u8>);
impl CMDIDX_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        CMDIDX_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMDIDX_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMDIDX` writer - Command index"]
pub struct CMDIDX_W<'a> {
    w: &'a mut W,
}
impl<'a> CMDIDX_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x3f) | (value as u32 & 0x3f);
        self.w
    }
}
#[doc = "Field `CMDRESP` reader - Command response type bits"]
pub struct CMDRESP_R(crate::FieldReader<u8, u8>);
impl CMDRESP_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        CMDRESP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMDRESP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMDRESP` writer - Command response type bits"]
pub struct CMDRESP_W<'a> {
    w: &'a mut W,
}
impl<'a> CMDRESP_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u32 & 0x03) << 6);
        self.w
    }
}
#[doc = "Field `INTWAIT` reader - Interrupt wait instead of timeout"]
pub struct INTWAIT_R(crate::FieldReader<bool, bool>);
impl INTWAIT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        INTWAIT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTWAIT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTWAIT` writer - Interrupt wait instead of timeout"]
pub struct INTWAIT_W<'a> {
    w: &'a mut W,
}
impl<'a> INTWAIT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `WAITDEND` reader - Waits for ends of data transfer"]
pub struct WAITDEND_R(crate::FieldReader<bool, bool>);
impl WAITDEND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        WAITDEND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WAITDEND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WAITDEND` writer - Waits for ends of data transfer"]
pub struct WAITDEND_W<'a> {
    w: &'a mut W,
}
impl<'a> WAITDEND_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `CSMEN` reader - Command state machine (CSM) enable bit"]
pub struct CSMEN_R(crate::FieldReader<bool, bool>);
impl CSMEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CSMEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CSMEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CSMEN` writer - Command state machine (CSM) enable bit"]
pub struct CSMEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CSMEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `SUSPEND` reader - SD I/O suspend command(SD I/O only)"]
pub struct SUSPEND_R(crate::FieldReader<bool, bool>);
impl SUSPEND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SUSPEND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SUSPEND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SUSPEND` writer - SD I/O suspend command(SD I/O only)"]
pub struct SUSPEND_W<'a> {
    w: &'a mut W,
}
impl<'a> SUSPEND_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `ENCMDC` reader - CMD completion signal enabled (CE-ATA only)"]
pub struct ENCMDC_R(crate::FieldReader<bool, bool>);
impl ENCMDC_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ENCMDC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENCMDC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ENCMDC` writer - CMD completion signal enabled (CE-ATA only)"]
pub struct ENCMDC_W<'a> {
    w: &'a mut W,
}
impl<'a> ENCMDC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `NINTEN` reader - No CE-ATA Interrupt (CE-ATA only)"]
pub struct NINTEN_R(crate::FieldReader<bool, bool>);
impl NINTEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NINTEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NINTEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NINTEN` writer - No CE-ATA Interrupt (CE-ATA only)"]
pub struct NINTEN_W<'a> {
    w: &'a mut W,
}
impl<'a> NINTEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `ATAEN` reader - CE-ATA command enable(CE-ATA only)"]
pub struct ATAEN_R(crate::FieldReader<bool, bool>);
impl ATAEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ATAEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ATAEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ATAEN` writer - CE-ATA command enable(CE-ATA only)"]
pub struct ATAEN_W<'a> {
    w: &'a mut W,
}
impl<'a> ATAEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:5 - Command index"]
    #[inline(always)]
    pub fn cmdidx(&self) -> CMDIDX_R {
        CMDIDX_R::new((self.bits & 0x3f) as u8)
    }
    #[doc = "Bits 6:7 - Command response type bits"]
    #[inline(always)]
    pub fn cmdresp(&self) -> CMDRESP_R {
        CMDRESP_R::new(((self.bits >> 6) & 0x03) as u8)
    }
    #[doc = "Bit 8 - Interrupt wait instead of timeout"]
    #[inline(always)]
    pub fn intwait(&self) -> INTWAIT_R {
        INTWAIT_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Waits for ends of data transfer"]
    #[inline(always)]
    pub fn waitdend(&self) -> WAITDEND_R {
        WAITDEND_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Command state machine (CSM) enable bit"]
    #[inline(always)]
    pub fn csmen(&self) -> CSMEN_R {
        CSMEN_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - SD I/O suspend command(SD I/O only)"]
    #[inline(always)]
    pub fn suspend(&self) -> SUSPEND_R {
        SUSPEND_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - CMD completion signal enabled (CE-ATA only)"]
    #[inline(always)]
    pub fn encmdc(&self) -> ENCMDC_R {
        ENCMDC_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - No CE-ATA Interrupt (CE-ATA only)"]
    #[inline(always)]
    pub fn ninten(&self) -> NINTEN_R {
        NINTEN_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - CE-ATA command enable(CE-ATA only)"]
    #[inline(always)]
    pub fn ataen(&self) -> ATAEN_R {
        ATAEN_R::new(((self.bits >> 14) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:5 - Command index"]
    #[inline(always)]
    pub fn cmdidx(&mut self) -> CMDIDX_W {
        CMDIDX_W { w: self }
    }
    #[doc = "Bits 6:7 - Command response type bits"]
    #[inline(always)]
    pub fn cmdresp(&mut self) -> CMDRESP_W {
        CMDRESP_W { w: self }
    }
    #[doc = "Bit 8 - Interrupt wait instead of timeout"]
    #[inline(always)]
    pub fn intwait(&mut self) -> INTWAIT_W {
        INTWAIT_W { w: self }
    }
    #[doc = "Bit 9 - Waits for ends of data transfer"]
    #[inline(always)]
    pub fn waitdend(&mut self) -> WAITDEND_W {
        WAITDEND_W { w: self }
    }
    #[doc = "Bit 10 - Command state machine (CSM) enable bit"]
    #[inline(always)]
    pub fn csmen(&mut self) -> CSMEN_W {
        CSMEN_W { w: self }
    }
    #[doc = "Bit 11 - SD I/O suspend command(SD I/O only)"]
    #[inline(always)]
    pub fn suspend(&mut self) -> SUSPEND_W {
        SUSPEND_W { w: self }
    }
    #[doc = "Bit 12 - CMD completion signal enabled (CE-ATA only)"]
    #[inline(always)]
    pub fn encmdc(&mut self) -> ENCMDC_W {
        ENCMDC_W { w: self }
    }
    #[doc = "Bit 13 - No CE-ATA Interrupt (CE-ATA only)"]
    #[inline(always)]
    pub fn ninten(&mut self) -> NINTEN_W {
        NINTEN_W { w: self }
    }
    #[doc = "Bit 14 - CE-ATA command enable(CE-ATA only)"]
    #[inline(always)]
    pub fn ataen(&mut self) -> ATAEN_W {
        ATAEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Command control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cmdctl](index.html) module"]
pub struct CMDCTL_SPEC;
impl crate::RegisterSpec for CMDCTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [cmdctl::R](R) reader structure"]
impl crate::Readable for CMDCTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cmdctl::W](W) writer structure"]
impl crate::Writable for CMDCTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CMDCTL to value 0"]
impl crate::Resettable for CMDCTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
