#[doc = "Register `CFG1` reader"]
pub struct R(crate::R<CFG1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CFG1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CFG1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CFG1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CFG1` writer"]
pub struct W(crate::W<CFG1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CFG1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CFG1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CFG1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PREDV0` reader - PREDV0 division factor"]
pub struct PREDV0_R(crate::FieldReader<u8, u8>);
impl PREDV0_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        PREDV0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PREDV0_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PREDV0` writer - PREDV0 division factor"]
pub struct PREDV0_W<'a> {
    w: &'a mut W,
}
impl<'a> PREDV0_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
        self.w
    }
}
#[doc = "Field `PREDV1` reader - PREDV1 division factor"]
pub struct PREDV1_R(crate::FieldReader<u8, u8>);
impl PREDV1_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        PREDV1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PREDV1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PREDV1` writer - PREDV1 division factor"]
pub struct PREDV1_W<'a> {
    w: &'a mut W,
}
impl<'a> PREDV1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `PLL1MF` reader - The PLL1 clock multiplication factor"]
pub struct PLL1MF_R(crate::FieldReader<u8, u8>);
impl PLL1MF_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        PLL1MF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLL1MF_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLL1MF` writer - The PLL1 clock multiplication factor"]
pub struct PLL1MF_W<'a> {
    w: &'a mut W,
}
impl<'a> PLL1MF_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 8)) | ((value as u32 & 0x0f) << 8);
        self.w
    }
}
#[doc = "Field `PLL2MF` reader - The PLL2 clock multiplication factor"]
pub struct PLL2MF_R(crate::FieldReader<u8, u8>);
impl PLL2MF_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        PLL2MF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLL2MF_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLL2MF` writer - The PLL2 clock multiplication factor"]
pub struct PLL2MF_W<'a> {
    w: &'a mut W,
}
impl<'a> PLL2MF_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 12)) | ((value as u32 & 0x0f) << 12);
        self.w
    }
}
#[doc = "Field `PREDV0SEL` reader - PREDV0 input Clock Source Selection"]
pub struct PREDV0SEL_R(crate::FieldReader<bool, bool>);
impl PREDV0SEL_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PREDV0SEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PREDV0SEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PREDV0SEL` writer - PREDV0 input Clock Source Selection"]
pub struct PREDV0SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> PREDV0SEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `I2S1SEL` reader - I2S1 Clock Source Selection"]
pub struct I2S1SEL_R(crate::FieldReader<bool, bool>);
impl I2S1SEL_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        I2S1SEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S1SEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S1SEL` writer - I2S1 Clock Source Selection"]
pub struct I2S1SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S1SEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `I2S2SEL` reader - I2S2 Clock Source Selection"]
pub struct I2S2SEL_R(crate::FieldReader<bool, bool>);
impl I2S2SEL_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        I2S2SEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S2SEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S2SEL` writer - I2S2 Clock Source Selection"]
pub struct I2S2SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S2SEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `ADCPSC_3` reader - Bit 4 of ADCPSC"]
pub struct ADCPSC_3_R(crate::FieldReader<bool, bool>);
impl ADCPSC_3_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ADCPSC_3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADCPSC_3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADCPSC_3` writer - Bit 4 of ADCPSC"]
pub struct ADCPSC_3_W<'a> {
    w: &'a mut W,
}
impl<'a> ADCPSC_3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 29)) | ((value as u32 & 0x01) << 29);
        self.w
    }
}
#[doc = "Field `PLLPRESEL` reader - PLL Clock Source Selection"]
pub struct PLLPRESEL_R(crate::FieldReader<bool, bool>);
impl PLLPRESEL_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PLLPRESEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLPRESEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLPRESEL` writer - PLL Clock Source Selection"]
pub struct PLLPRESEL_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLPRESEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 30)) | ((value as u32 & 0x01) << 30);
        self.w
    }
}
#[doc = "Field `PLL2MF_4` reader - Bit 5 of PLL2MF"]
pub struct PLL2MF_4_R(crate::FieldReader<bool, bool>);
impl PLL2MF_4_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PLL2MF_4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLL2MF_4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLL2MF_4` writer - Bit 5 of PLL2MF"]
pub struct PLL2MF_4_W<'a> {
    w: &'a mut W,
}
impl<'a> PLL2MF_4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - PREDV0 division factor"]
    #[inline(always)]
    pub fn predv0(&self) -> PREDV0_R {
        PREDV0_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 4:7 - PREDV1 division factor"]
    #[inline(always)]
    pub fn predv1(&self) -> PREDV1_R {
        PREDV1_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 8:11 - The PLL1 clock multiplication factor"]
    #[inline(always)]
    pub fn pll1mf(&self) -> PLL1MF_R {
        PLL1MF_R::new(((self.bits >> 8) & 0x0f) as u8)
    }
    #[doc = "Bits 12:15 - The PLL2 clock multiplication factor"]
    #[inline(always)]
    pub fn pll2mf(&self) -> PLL2MF_R {
        PLL2MF_R::new(((self.bits >> 12) & 0x0f) as u8)
    }
    #[doc = "Bit 16 - PREDV0 input Clock Source Selection"]
    #[inline(always)]
    pub fn predv0sel(&self) -> PREDV0SEL_R {
        PREDV0SEL_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - I2S1 Clock Source Selection"]
    #[inline(always)]
    pub fn i2s1sel(&self) -> I2S1SEL_R {
        I2S1SEL_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - I2S2 Clock Source Selection"]
    #[inline(always)]
    pub fn i2s2sel(&self) -> I2S2SEL_R {
        I2S2SEL_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 29 - Bit 4 of ADCPSC"]
    #[inline(always)]
    pub fn adcpsc_3(&self) -> ADCPSC_3_R {
        ADCPSC_3_R::new(((self.bits >> 29) & 0x01) != 0)
    }
    #[doc = "Bit 30 - PLL Clock Source Selection"]
    #[inline(always)]
    pub fn pllpresel(&self) -> PLLPRESEL_R {
        PLLPRESEL_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 31 - Bit 5 of PLL2MF"]
    #[inline(always)]
    pub fn pll2mf_4(&self) -> PLL2MF_4_R {
        PLL2MF_4_R::new(((self.bits >> 31) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:3 - PREDV0 division factor"]
    #[inline(always)]
    pub fn predv0(&mut self) -> PREDV0_W {
        PREDV0_W { w: self }
    }
    #[doc = "Bits 4:7 - PREDV1 division factor"]
    #[inline(always)]
    pub fn predv1(&mut self) -> PREDV1_W {
        PREDV1_W { w: self }
    }
    #[doc = "Bits 8:11 - The PLL1 clock multiplication factor"]
    #[inline(always)]
    pub fn pll1mf(&mut self) -> PLL1MF_W {
        PLL1MF_W { w: self }
    }
    #[doc = "Bits 12:15 - The PLL2 clock multiplication factor"]
    #[inline(always)]
    pub fn pll2mf(&mut self) -> PLL2MF_W {
        PLL2MF_W { w: self }
    }
    #[doc = "Bit 16 - PREDV0 input Clock Source Selection"]
    #[inline(always)]
    pub fn predv0sel(&mut self) -> PREDV0SEL_W {
        PREDV0SEL_W { w: self }
    }
    #[doc = "Bit 17 - I2S1 Clock Source Selection"]
    #[inline(always)]
    pub fn i2s1sel(&mut self) -> I2S1SEL_W {
        I2S1SEL_W { w: self }
    }
    #[doc = "Bit 18 - I2S2 Clock Source Selection"]
    #[inline(always)]
    pub fn i2s2sel(&mut self) -> I2S2SEL_W {
        I2S2SEL_W { w: self }
    }
    #[doc = "Bit 29 - Bit 4 of ADCPSC"]
    #[inline(always)]
    pub fn adcpsc_3(&mut self) -> ADCPSC_3_W {
        ADCPSC_3_W { w: self }
    }
    #[doc = "Bit 30 - PLL Clock Source Selection"]
    #[inline(always)]
    pub fn pllpresel(&mut self) -> PLLPRESEL_W {
        PLLPRESEL_W { w: self }
    }
    #[doc = "Bit 31 - Bit 5 of PLL2MF"]
    #[inline(always)]
    pub fn pll2mf_4(&mut self) -> PLL2MF_4_W {
        PLL2MF_4_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clock Configuration register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cfg1](index.html) module"]
pub struct CFG1_SPEC;
impl crate::RegisterSpec for CFG1_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [cfg1::R](R) reader structure"]
impl crate::Readable for CFG1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cfg1::W](W) writer structure"]
impl crate::Writable for CFG1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CFG1 to value 0"]
impl crate::Resettable for CFG1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
