#[doc = "Register `CFG0` reader"]
pub struct R(crate::R<CFG0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CFG0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CFG0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CFG0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CFG0` writer"]
pub struct W(crate::W<CFG0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CFG0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CFG0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CFG0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SCS` reader - System clock switch"]
pub struct SCS_R(crate::FieldReader<u8, u8>);
impl SCS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SCS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCS` writer - System clock switch"]
pub struct SCS_W<'a> {
    w: &'a mut W,
}
impl<'a> SCS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u32 & 0x03);
        self.w
    }
}
#[doc = "Field `SCSS` reader - System clock switch status"]
pub struct SCSS_R(crate::FieldReader<u8, u8>);
impl SCSS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SCSS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCSS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AHBPSC` reader - AHB prescaler selection"]
pub struct AHBPSC_R(crate::FieldReader<u8, u8>);
impl AHBPSC_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        AHBPSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AHBPSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AHBPSC` writer - AHB prescaler selection"]
pub struct AHBPSC_W<'a> {
    w: &'a mut W,
}
impl<'a> AHBPSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `APB1PSC` reader - APB1 prescaler selection"]
pub struct APB1PSC_R(crate::FieldReader<u8, u8>);
impl APB1PSC_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        APB1PSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for APB1PSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `APB1PSC` writer - APB1 prescaler selection"]
pub struct APB1PSC_W<'a> {
    w: &'a mut W,
}
impl<'a> APB1PSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 8)) | ((value as u32 & 0x07) << 8);
        self.w
    }
}
#[doc = "Field `APB2PSC` reader - APB2 prescaler selection"]
pub struct APB2PSC_R(crate::FieldReader<u8, u8>);
impl APB2PSC_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        APB2PSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for APB2PSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `APB2PSC` writer - APB2 prescaler selection"]
pub struct APB2PSC_W<'a> {
    w: &'a mut W,
}
impl<'a> APB2PSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 11)) | ((value as u32 & 0x07) << 11);
        self.w
    }
}
#[doc = "Field `ADCPSC_1_0` reader - ADC clock prescaler selection"]
pub struct ADCPSC_1_0_R(crate::FieldReader<u8, u8>);
impl ADCPSC_1_0_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ADCPSC_1_0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADCPSC_1_0_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADCPSC_1_0` writer - ADC clock prescaler selection"]
pub struct ADCPSC_1_0_W<'a> {
    w: &'a mut W,
}
impl<'a> ADCPSC_1_0_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 14)) | ((value as u32 & 0x03) << 14);
        self.w
    }
}
#[doc = "Field `PLLSEL` reader - PLL Clock Source Selection"]
pub struct PLLSEL_R(crate::FieldReader<bool, bool>);
impl PLLSEL_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PLLSEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLSEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLSEL` writer - PLL Clock Source Selection"]
pub struct PLLSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLSEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `PREDV0_LSB` reader - The LSB of PREDV0 division factor"]
pub struct PREDV0_LSB_R(crate::FieldReader<bool, bool>);
impl PREDV0_LSB_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PREDV0_LSB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PREDV0_LSB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PREDV0_LSB` writer - The LSB of PREDV0 division factor"]
pub struct PREDV0_LSB_W<'a> {
    w: &'a mut W,
}
impl<'a> PREDV0_LSB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `PLLMF_3_0` reader - The PLL clock multiplication factor"]
pub struct PLLMF_3_0_R(crate::FieldReader<u8, u8>);
impl PLLMF_3_0_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        PLLMF_3_0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLMF_3_0_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLMF_3_0` writer - The PLL clock multiplication factor"]
pub struct PLLMF_3_0_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLMF_3_0_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 18)) | ((value as u32 & 0x0f) << 18);
        self.w
    }
}
#[doc = "Field `USBFSPSC_1_0` reader - USBFS clock prescaler selection"]
pub struct USBFSPSC_1_0_R(crate::FieldReader<u8, u8>);
impl USBFSPSC_1_0_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        USBFSPSC_1_0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USBFSPSC_1_0_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USBFSPSC_1_0` writer - USBFS clock prescaler selection"]
pub struct USBFSPSC_1_0_W<'a> {
    w: &'a mut W,
}
impl<'a> USBFSPSC_1_0_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 22)) | ((value as u32 & 0x03) << 22);
        self.w
    }
}
#[doc = "Field `CKOUT0SEL` reader - CKOUT0 Clock Source Selection"]
pub struct CKOUT0SEL_R(crate::FieldReader<u8, u8>);
impl CKOUT0SEL_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        CKOUT0SEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CKOUT0SEL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CKOUT0SEL` writer - CKOUT0 Clock Source Selection"]
pub struct CKOUT0SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CKOUT0SEL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 24)) | ((value as u32 & 0x0f) << 24);
        self.w
    }
}
#[doc = "Field `ADCPSC_2` reader - Bit 2 of ADCPSC"]
pub struct ADCPSC_2_R(crate::FieldReader<bool, bool>);
impl ADCPSC_2_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ADCPSC_2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADCPSC_2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADCPSC_2` writer - Bit 2 of ADCPSC"]
pub struct ADCPSC_2_W<'a> {
    w: &'a mut W,
}
impl<'a> ADCPSC_2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 28)) | ((value as u32 & 0x01) << 28);
        self.w
    }
}
#[doc = "Field `PLLMF_5_4` reader - Bit 5 and Bit 4 of PLLMF"]
pub struct PLLMF_5_4_R(crate::FieldReader<u8, u8>);
impl PLLMF_5_4_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        PLLMF_5_4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLMF_5_4_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLMF_5_4` writer - Bit 5 and Bit 4 of PLLMF"]
pub struct PLLMF_5_4_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLMF_5_4_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 29)) | ((value as u32 & 0x03) << 29);
        self.w
    }
}
#[doc = "Field `USBFSPSC` reader - Bit 2 of USBFSPSC"]
pub struct USBFSPSC_R(crate::FieldReader<bool, bool>);
impl USBFSPSC_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        USBFSPSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USBFSPSC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USBFSPSC` writer - Bit 2 of USBFSPSC"]
pub struct USBFSPSC_W<'a> {
    w: &'a mut W,
}
impl<'a> USBFSPSC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - System clock switch"]
    #[inline(always)]
    pub fn scs(&self) -> SCS_R {
        SCS_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - System clock switch status"]
    #[inline(always)]
    pub fn scss(&self) -> SCSS_R {
        SCSS_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:7 - AHB prescaler selection"]
    #[inline(always)]
    pub fn ahbpsc(&self) -> AHBPSC_R {
        AHBPSC_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 8:10 - APB1 prescaler selection"]
    #[inline(always)]
    pub fn apb1psc(&self) -> APB1PSC_R {
        APB1PSC_R::new(((self.bits >> 8) & 0x07) as u8)
    }
    #[doc = "Bits 11:13 - APB2 prescaler selection"]
    #[inline(always)]
    pub fn apb2psc(&self) -> APB2PSC_R {
        APB2PSC_R::new(((self.bits >> 11) & 0x07) as u8)
    }
    #[doc = "Bits 14:15 - ADC clock prescaler selection"]
    #[inline(always)]
    pub fn adcpsc_1_0(&self) -> ADCPSC_1_0_R {
        ADCPSC_1_0_R::new(((self.bits >> 14) & 0x03) as u8)
    }
    #[doc = "Bit 16 - PLL Clock Source Selection"]
    #[inline(always)]
    pub fn pllsel(&self) -> PLLSEL_R {
        PLLSEL_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - The LSB of PREDV0 division factor"]
    #[inline(always)]
    pub fn predv0_lsb(&self) -> PREDV0_LSB_R {
        PREDV0_LSB_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bits 18:21 - The PLL clock multiplication factor"]
    #[inline(always)]
    pub fn pllmf_3_0(&self) -> PLLMF_3_0_R {
        PLLMF_3_0_R::new(((self.bits >> 18) & 0x0f) as u8)
    }
    #[doc = "Bits 22:23 - USBFS clock prescaler selection"]
    #[inline(always)]
    pub fn usbfspsc_1_0(&self) -> USBFSPSC_1_0_R {
        USBFSPSC_1_0_R::new(((self.bits >> 22) & 0x03) as u8)
    }
    #[doc = "Bits 24:27 - CKOUT0 Clock Source Selection"]
    #[inline(always)]
    pub fn ckout0sel(&self) -> CKOUT0SEL_R {
        CKOUT0SEL_R::new(((self.bits >> 24) & 0x0f) as u8)
    }
    #[doc = "Bit 28 - Bit 2 of ADCPSC"]
    #[inline(always)]
    pub fn adcpsc_2(&self) -> ADCPSC_2_R {
        ADCPSC_2_R::new(((self.bits >> 28) & 0x01) != 0)
    }
    #[doc = "Bits 29:30 - Bit 5 and Bit 4 of PLLMF"]
    #[inline(always)]
    pub fn pllmf_5_4(&self) -> PLLMF_5_4_R {
        PLLMF_5_4_R::new(((self.bits >> 29) & 0x03) as u8)
    }
    #[doc = "Bit 31 - Bit 2 of USBFSPSC"]
    #[inline(always)]
    pub fn usbfspsc(&self) -> USBFSPSC_R {
        USBFSPSC_R::new(((self.bits >> 31) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - System clock switch"]
    #[inline(always)]
    pub fn scs(&mut self) -> SCS_W {
        SCS_W { w: self }
    }
    #[doc = "Bits 4:7 - AHB prescaler selection"]
    #[inline(always)]
    pub fn ahbpsc(&mut self) -> AHBPSC_W {
        AHBPSC_W { w: self }
    }
    #[doc = "Bits 8:10 - APB1 prescaler selection"]
    #[inline(always)]
    pub fn apb1psc(&mut self) -> APB1PSC_W {
        APB1PSC_W { w: self }
    }
    #[doc = "Bits 11:13 - APB2 prescaler selection"]
    #[inline(always)]
    pub fn apb2psc(&mut self) -> APB2PSC_W {
        APB2PSC_W { w: self }
    }
    #[doc = "Bits 14:15 - ADC clock prescaler selection"]
    #[inline(always)]
    pub fn adcpsc_1_0(&mut self) -> ADCPSC_1_0_W {
        ADCPSC_1_0_W { w: self }
    }
    #[doc = "Bit 16 - PLL Clock Source Selection"]
    #[inline(always)]
    pub fn pllsel(&mut self) -> PLLSEL_W {
        PLLSEL_W { w: self }
    }
    #[doc = "Bit 17 - The LSB of PREDV0 division factor"]
    #[inline(always)]
    pub fn predv0_lsb(&mut self) -> PREDV0_LSB_W {
        PREDV0_LSB_W { w: self }
    }
    #[doc = "Bits 18:21 - The PLL clock multiplication factor"]
    #[inline(always)]
    pub fn pllmf_3_0(&mut self) -> PLLMF_3_0_W {
        PLLMF_3_0_W { w: self }
    }
    #[doc = "Bits 22:23 - USBFS clock prescaler selection"]
    #[inline(always)]
    pub fn usbfspsc_1_0(&mut self) -> USBFSPSC_1_0_W {
        USBFSPSC_1_0_W { w: self }
    }
    #[doc = "Bits 24:27 - CKOUT0 Clock Source Selection"]
    #[inline(always)]
    pub fn ckout0sel(&mut self) -> CKOUT0SEL_W {
        CKOUT0SEL_W { w: self }
    }
    #[doc = "Bit 28 - Bit 2 of ADCPSC"]
    #[inline(always)]
    pub fn adcpsc_2(&mut self) -> ADCPSC_2_W {
        ADCPSC_2_W { w: self }
    }
    #[doc = "Bits 29:30 - Bit 5 and Bit 4 of PLLMF"]
    #[inline(always)]
    pub fn pllmf_5_4(&mut self) -> PLLMF_5_4_W {
        PLLMF_5_4_W { w: self }
    }
    #[doc = "Bit 31 - Bit 2 of USBFSPSC"]
    #[inline(always)]
    pub fn usbfspsc(&mut self) -> USBFSPSC_W {
        USBFSPSC_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clock configuration register 0 (RCU_CFG0)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cfg0](index.html) module"]
pub struct CFG0_SPEC;
impl crate::RegisterSpec for CFG0_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [cfg0::R](R) reader structure"]
impl crate::Readable for CFG0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cfg0::W](W) writer structure"]
impl crate::Writable for CFG0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CFG0 to value 0"]
impl crate::Resettable for CFG0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
