#[doc = "Register `CS` reader"]
pub struct R(crate::R<CS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CS` writer"]
pub struct W(crate::W<CS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LDRF` reader - Low-driver mode ready flag"]
pub struct LDRF_R(crate::FieldReader<u8, u8>);
impl LDRF_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        LDRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LDRF_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LDRF` writer - Low-driver mode ready flag"]
pub struct LDRF_W<'a> {
    w: &'a mut W,
}
impl<'a> LDRF_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 18)) | ((value as u32 & 0x03) << 18);
        self.w
    }
}
#[doc = "Field `HDSRF` reader - High-driver switch ready flag"]
pub struct HDSRF_R(crate::FieldReader<bool, bool>);
impl HDSRF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HDSRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HDSRF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HDRF` reader - High-driver ready flag"]
pub struct HDRF_R(crate::FieldReader<bool, bool>);
impl HDRF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HDRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HDRF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LDOVSRF` reader - LDO voltage select ready flag"]
pub struct LDOVSRF_R(crate::FieldReader<bool, bool>);
impl LDOVSRF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        LDOVSRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LDOVSRF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WUPEN` reader - Enable WKUP pin"]
pub struct WUPEN_R(crate::FieldReader<bool, bool>);
impl WUPEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        WUPEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WUPEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WUPEN` writer - Enable WKUP pin"]
pub struct WUPEN_W<'a> {
    w: &'a mut W,
}
impl<'a> WUPEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `LVDF` reader - Low Voltage Detector Status Flag"]
pub struct LVDF_R(crate::FieldReader<bool, bool>);
impl LVDF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        LVDF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LVDF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STBF` reader - Standby flag"]
pub struct STBF_R(crate::FieldReader<bool, bool>);
impl STBF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        STBF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STBF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WUF` reader - Wakeup flag"]
pub struct WUF_R(crate::FieldReader<bool, bool>);
impl WUF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        WUF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WUF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bits 18:19 - Low-driver mode ready flag"]
    #[inline(always)]
    pub fn ldrf(&self) -> LDRF_R {
        LDRF_R::new(((self.bits >> 18) & 0x03) as u8)
    }
    #[doc = "Bit 17 - High-driver switch ready flag"]
    #[inline(always)]
    pub fn hdsrf(&self) -> HDSRF_R {
        HDSRF_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 16 - High-driver ready flag"]
    #[inline(always)]
    pub fn hdrf(&self) -> HDRF_R {
        HDRF_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 14 - LDO voltage select ready flag"]
    #[inline(always)]
    pub fn ldovsrf(&self) -> LDOVSRF_R {
        LDOVSRF_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Enable WKUP pin"]
    #[inline(always)]
    pub fn wupen(&self) -> WUPEN_R {
        WUPEN_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Low Voltage Detector Status Flag"]
    #[inline(always)]
    pub fn lvdf(&self) -> LVDF_R {
        LVDF_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Standby flag"]
    #[inline(always)]
    pub fn stbf(&self) -> STBF_R {
        STBF_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Wakeup flag"]
    #[inline(always)]
    pub fn wuf(&self) -> WUF_R {
        WUF_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 18:19 - Low-driver mode ready flag"]
    #[inline(always)]
    pub fn ldrf(&mut self) -> LDRF_W {
        LDRF_W { w: self }
    }
    #[doc = "Bit 8 - Enable WKUP pin"]
    #[inline(always)]
    pub fn wupen(&mut self) -> WUPEN_W {
        WUPEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "power control/status register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cs](index.html) module"]
pub struct CS_SPEC;
impl crate::RegisterSpec for CS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [cs::R](R) reader structure"]
impl crate::Readable for CS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cs::W](W) writer structure"]
impl crate::Writable for CS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CS to value 0"]
impl crate::Resettable for CS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
