#[doc = "Register `STAT1` reader"]
pub struct R(crate::R<STAT1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<STAT1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<STAT1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<STAT1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `ECV` reader - Packet Error Checking Value that calculated by hardware when PEC is enabled"]
pub struct ECV_R(crate::FieldReader<u8, u8>);
impl ECV_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ECV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ECV_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DUMODF` reader - Dual Flag in slave mode"]
pub struct DUMODF_R(crate::FieldReader<bool, bool>);
impl DUMODF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DUMODF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DUMODF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HSTSMB` reader - SMBus Host Header detected in slave mode"]
pub struct HSTSMB_R(crate::FieldReader<bool, bool>);
impl HSTSMB_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HSTSMB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HSTSMB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DEFSMB` reader - Default address of SMBusDevice"]
pub struct DEFSMB_R(crate::FieldReader<bool, bool>);
impl DEFSMB_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DEFSMB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DEFSMB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXGC` reader - General call address (00h) received"]
pub struct RXGC_R(crate::FieldReader<bool, bool>);
impl RXGC_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RXGC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXGC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TRS` reader - Whether the I2C is a transmitter or a receiver"]
pub struct TRS_R(crate::FieldReader<bool, bool>);
impl TRS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TRS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TRS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2CBSY` reader - Busy flag"]
pub struct I2CBSY_R(crate::FieldReader<bool, bool>);
impl I2CBSY_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        I2CBSY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2CBSY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MASTER` reader - A flag indicating whether I2C block is in master or slave mode"]
pub struct MASTER_R(crate::FieldReader<bool, bool>);
impl MASTER_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MASTER_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MASTER_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bits 8:15 - Packet Error Checking Value that calculated by hardware when PEC is enabled"]
    #[inline(always)]
    pub fn ecv(&self) -> ECV_R {
        ECV_R::new(((self.bits >> 8) & 0xff) as u8)
    }
    #[doc = "Bit 7 - Dual Flag in slave mode"]
    #[inline(always)]
    pub fn dumodf(&self) -> DUMODF_R {
        DUMODF_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - SMBus Host Header detected in slave mode"]
    #[inline(always)]
    pub fn hstsmb(&self) -> HSTSMB_R {
        HSTSMB_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Default address of SMBusDevice"]
    #[inline(always)]
    pub fn defsmb(&self) -> DEFSMB_R {
        DEFSMB_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - General call address (00h) received"]
    #[inline(always)]
    pub fn rxgc(&self) -> RXGC_R {
        RXGC_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Whether the I2C is a transmitter or a receiver"]
    #[inline(always)]
    pub fn trs(&self) -> TRS_R {
        TRS_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Busy flag"]
    #[inline(always)]
    pub fn i2cbsy(&self) -> I2CBSY_R {
        I2CBSY_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - A flag indicating whether I2C block is in master or slave mode"]
    #[inline(always)]
    pub fn master(&self) -> MASTER_R {
        MASTER_R::new((self.bits & 0x01) != 0)
    }
}
#[doc = "Transfer status register 1\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [stat1](index.html) module"]
pub struct STAT1_SPEC;
impl crate::RegisterSpec for STAT1_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [stat1::R](R) reader structure"]
impl crate::Readable for STAT1_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets STAT1 to value 0"]
impl crate::Resettable for STAT1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
