#[doc = "Register `SADDR0` reader"]
pub struct R(crate::R<SADDR0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SADDR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SADDR0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SADDR0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SADDR0` writer"]
pub struct W(crate::W<SADDR0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SADDR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SADDR0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SADDR0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ADDFORMAT` reader - Address mode for the I2C slave"]
pub struct ADDFORMAT_R(crate::FieldReader<bool, bool>);
impl ADDFORMAT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ADDFORMAT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADDFORMAT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADDFORMAT` writer - Address mode for the I2C slave"]
pub struct ADDFORMAT_W<'a> {
    w: &'a mut W,
}
impl<'a> ADDFORMAT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `ADDRESS9_8` reader - Highest two bits of a 10-bit address"]
pub struct ADDRESS9_8_R(crate::FieldReader<u8, u8>);
impl ADDRESS9_8_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ADDRESS9_8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADDRESS9_8_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADDRESS9_8` writer - Highest two bits of a 10-bit address"]
pub struct ADDRESS9_8_W<'a> {
    w: &'a mut W,
}
impl<'a> ADDRESS9_8_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 8)) | ((value as u32 & 0x03) << 8);
        self.w
    }
}
#[doc = "Field `ADDRESS7_1` reader - 7-bit address or bits 7:1 of a 10-bit address"]
pub struct ADDRESS7_1_R(crate::FieldReader<u8, u8>);
impl ADDRESS7_1_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ADDRESS7_1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADDRESS7_1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADDRESS7_1` writer - 7-bit address or bits 7:1 of a 10-bit address"]
pub struct ADDRESS7_1_W<'a> {
    w: &'a mut W,
}
impl<'a> ADDRESS7_1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x7f << 1)) | ((value as u32 & 0x7f) << 1);
        self.w
    }
}
#[doc = "Field `ADDRESS0` reader - Bit 0 of a 10-bit address"]
pub struct ADDRESS0_R(crate::FieldReader<bool, bool>);
impl ADDRESS0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ADDRESS0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADDRESS0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADDRESS0` writer - Bit 0 of a 10-bit address"]
pub struct ADDRESS0_W<'a> {
    w: &'a mut W,
}
impl<'a> ADDRESS0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - Address mode for the I2C slave"]
    #[inline(always)]
    pub fn addformat(&self) -> ADDFORMAT_R {
        ADDFORMAT_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bits 8:9 - Highest two bits of a 10-bit address"]
    #[inline(always)]
    pub fn address9_8(&self) -> ADDRESS9_8_R {
        ADDRESS9_8_R::new(((self.bits >> 8) & 0x03) as u8)
    }
    #[doc = "Bits 1:7 - 7-bit address or bits 7:1 of a 10-bit address"]
    #[inline(always)]
    pub fn address7_1(&self) -> ADDRESS7_1_R {
        ADDRESS7_1_R::new(((self.bits >> 1) & 0x7f) as u8)
    }
    #[doc = "Bit 0 - Bit 0 of a 10-bit address"]
    #[inline(always)]
    pub fn address0(&self) -> ADDRESS0_R {
        ADDRESS0_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 15 - Address mode for the I2C slave"]
    #[inline(always)]
    pub fn addformat(&mut self) -> ADDFORMAT_W {
        ADDFORMAT_W { w: self }
    }
    #[doc = "Bits 8:9 - Highest two bits of a 10-bit address"]
    #[inline(always)]
    pub fn address9_8(&mut self) -> ADDRESS9_8_W {
        ADDRESS9_8_W { w: self }
    }
    #[doc = "Bits 1:7 - 7-bit address or bits 7:1 of a 10-bit address"]
    #[inline(always)]
    pub fn address7_1(&mut self) -> ADDRESS7_1_W {
        ADDRESS7_1_W { w: self }
    }
    #[doc = "Bit 0 - Bit 0 of a 10-bit address"]
    #[inline(always)]
    pub fn address0(&mut self) -> ADDRESS0_W {
        ADDRESS0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Slave address register 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [saddr0](index.html) module"]
pub struct SADDR0_SPEC;
impl crate::RegisterSpec for SADDR0_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [saddr0::R](R) reader structure"]
impl crate::Readable for SADDR0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [saddr0::W](W) writer structure"]
impl crate::Writable for SADDR0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SADDR0 to value 0"]
impl crate::Resettable for SADDR0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
