#[doc = "Register `WSEN` reader"]
pub struct R(crate::R<WSEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<WSEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<WSEN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<WSEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `WSEN` writer"]
pub struct W(crate::W<WSEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<WSEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<WSEN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<WSEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `WSEN` reader - FMC wait state enable register"]
pub struct WSEN_R(crate::FieldReader<bool, bool>);
impl WSEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        WSEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WSEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WSEN` writer - FMC wait state enable register"]
pub struct WSEN_W<'a> {
    w: &'a mut W,
}
impl<'a> WSEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - FMC wait state enable register"]
    #[inline(always)]
    pub fn wsen(&self) -> WSEN_R {
        WSEN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - FMC wait state enable register"]
    #[inline(always)]
    pub fn wsen(&mut self) -> WSEN_W {
        WSEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Wait state enable register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [wsen](index.html) module"]
pub struct WSEN_SPEC;
impl crate::RegisterSpec for WSEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [wsen::R](R) reader structure"]
impl crate::Readable for WSEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [wsen::W](W) writer structure"]
impl crate::Writable for WSEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets WSEN to value 0"]
impl crate::Resettable for WSEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
