#[doc = "Register `SWIEV` reader"]
pub struct R(crate::R<SWIEV_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SWIEV_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SWIEV_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SWIEV_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SWIEV` writer"]
pub struct W(crate::W<SWIEV_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SWIEV_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SWIEV_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SWIEV_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SWIEV0` reader - Interrupt/Event software trigger on line 0"]
pub struct SWIEV0_R(crate::FieldReader<bool, bool>);
impl SWIEV0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV0` writer - Interrupt/Event software trigger on line 0"]
pub struct SWIEV0_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `SWIEV1` reader - Interrupt/Event software trigger on line 1"]
pub struct SWIEV1_R(crate::FieldReader<bool, bool>);
impl SWIEV1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV1` writer - Interrupt/Event software trigger on line 1"]
pub struct SWIEV1_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `SWIEV2` reader - Interrupt/Event software trigger on line 2"]
pub struct SWIEV2_R(crate::FieldReader<bool, bool>);
impl SWIEV2_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV2` writer - Interrupt/Event software trigger on line 2"]
pub struct SWIEV2_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `SWIEV3` reader - Interrupt/Event software trigger on line 3"]
pub struct SWIEV3_R(crate::FieldReader<bool, bool>);
impl SWIEV3_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV3` writer - Interrupt/Event software trigger on line 3"]
pub struct SWIEV3_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `SWIEV4` reader - Interrupt/Event software trigger on line 4"]
pub struct SWIEV4_R(crate::FieldReader<bool, bool>);
impl SWIEV4_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV4` writer - Interrupt/Event software trigger on line 4"]
pub struct SWIEV4_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `SWIEV5` reader - Interrupt/Event software trigger on line 5"]
pub struct SWIEV5_R(crate::FieldReader<bool, bool>);
impl SWIEV5_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV5` writer - Interrupt/Event software trigger on line 5"]
pub struct SWIEV5_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `SWIEV6` reader - Interrupt/Event software trigger on line 6"]
pub struct SWIEV6_R(crate::FieldReader<bool, bool>);
impl SWIEV6_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV6_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV6` writer - Interrupt/Event software trigger on line 6"]
pub struct SWIEV6_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV6_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `SWIEV7` reader - Interrupt/Event software trigger on line 7"]
pub struct SWIEV7_R(crate::FieldReader<bool, bool>);
impl SWIEV7_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV7_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV7_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV7` writer - Interrupt/Event software trigger on line 7"]
pub struct SWIEV7_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV7_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `SWIEV8` reader - Interrupt/Event software trigger on line 8"]
pub struct SWIEV8_R(crate::FieldReader<bool, bool>);
impl SWIEV8_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV8_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV8` writer - Interrupt/Event software trigger on line 8"]
pub struct SWIEV8_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV8_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `SWIEV9` reader - Interrupt/Event software trigger on line 9"]
pub struct SWIEV9_R(crate::FieldReader<bool, bool>);
impl SWIEV9_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV9_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV9_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV9` writer - Interrupt/Event software trigger on line 9"]
pub struct SWIEV9_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV9_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `SWIEV10` reader - Interrupt/Event software trigger on line 10"]
pub struct SWIEV10_R(crate::FieldReader<bool, bool>);
impl SWIEV10_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV10_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV10_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV10` writer - Interrupt/Event software trigger on line 10"]
pub struct SWIEV10_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV10_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `SWIEV11` reader - Interrupt/Event software trigger on line 11"]
pub struct SWIEV11_R(crate::FieldReader<bool, bool>);
impl SWIEV11_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV11_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV11_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV11` writer - Interrupt/Event software trigger on line 11"]
pub struct SWIEV11_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV11_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `SWIEV12` reader - Interrupt/Event software trigger on line 12"]
pub struct SWIEV12_R(crate::FieldReader<bool, bool>);
impl SWIEV12_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV12_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV12_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV12` writer - Interrupt/Event software trigger on line 12"]
pub struct SWIEV12_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV12_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `SWIEV13` reader - Interrupt/Event software trigger on line 13"]
pub struct SWIEV13_R(crate::FieldReader<bool, bool>);
impl SWIEV13_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV13_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV13_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV13` writer - Interrupt/Event software trigger on line 13"]
pub struct SWIEV13_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV13_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `SWIEV14` reader - Interrupt/Event software trigger on line 14"]
pub struct SWIEV14_R(crate::FieldReader<bool, bool>);
impl SWIEV14_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV14_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV14_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV14` writer - Interrupt/Event software trigger on line 14"]
pub struct SWIEV14_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV14_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `SWIEV15` reader - Interrupt/Event software trigger on line 15"]
pub struct SWIEV15_R(crate::FieldReader<bool, bool>);
impl SWIEV15_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV15_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV15_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV15` writer - Interrupt/Event software trigger on line 15"]
pub struct SWIEV15_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV15_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `SWIEV16` reader - Interrupt/Event software trigger on line 16"]
pub struct SWIEV16_R(crate::FieldReader<bool, bool>);
impl SWIEV16_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV16_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV16_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV16` writer - Interrupt/Event software trigger on line 16"]
pub struct SWIEV16_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV16_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `SWIEV17` reader - Interrupt/Event software trigger on line 17"]
pub struct SWIEV17_R(crate::FieldReader<bool, bool>);
impl SWIEV17_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV17_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV17_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV17` writer - Interrupt/Event software trigger on line 17"]
pub struct SWIEV17_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV17_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `SWIEV18` reader - Interrupt/Event software trigger on line 18"]
pub struct SWIEV18_R(crate::FieldReader<bool, bool>);
impl SWIEV18_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWIEV18_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWIEV18_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWIEV18` writer - Interrupt/Event software trigger on line 18"]
pub struct SWIEV18_W<'a> {
    w: &'a mut W,
}
impl<'a> SWIEV18_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Interrupt/Event software trigger on line 0"]
    #[inline(always)]
    pub fn swiev0(&self) -> SWIEV0_R {
        SWIEV0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Interrupt/Event software trigger on line 1"]
    #[inline(always)]
    pub fn swiev1(&self) -> SWIEV1_R {
        SWIEV1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Interrupt/Event software trigger on line 2"]
    #[inline(always)]
    pub fn swiev2(&self) -> SWIEV2_R {
        SWIEV2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Interrupt/Event software trigger on line 3"]
    #[inline(always)]
    pub fn swiev3(&self) -> SWIEV3_R {
        SWIEV3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Interrupt/Event software trigger on line 4"]
    #[inline(always)]
    pub fn swiev4(&self) -> SWIEV4_R {
        SWIEV4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Interrupt/Event software trigger on line 5"]
    #[inline(always)]
    pub fn swiev5(&self) -> SWIEV5_R {
        SWIEV5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Interrupt/Event software trigger on line 6"]
    #[inline(always)]
    pub fn swiev6(&self) -> SWIEV6_R {
        SWIEV6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Interrupt/Event software trigger on line 7"]
    #[inline(always)]
    pub fn swiev7(&self) -> SWIEV7_R {
        SWIEV7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Interrupt/Event software trigger on line 8"]
    #[inline(always)]
    pub fn swiev8(&self) -> SWIEV8_R {
        SWIEV8_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Interrupt/Event software trigger on line 9"]
    #[inline(always)]
    pub fn swiev9(&self) -> SWIEV9_R {
        SWIEV9_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Interrupt/Event software trigger on line 10"]
    #[inline(always)]
    pub fn swiev10(&self) -> SWIEV10_R {
        SWIEV10_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Interrupt/Event software trigger on line 11"]
    #[inline(always)]
    pub fn swiev11(&self) -> SWIEV11_R {
        SWIEV11_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Interrupt/Event software trigger on line 12"]
    #[inline(always)]
    pub fn swiev12(&self) -> SWIEV12_R {
        SWIEV12_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Interrupt/Event software trigger on line 13"]
    #[inline(always)]
    pub fn swiev13(&self) -> SWIEV13_R {
        SWIEV13_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Interrupt/Event software trigger on line 14"]
    #[inline(always)]
    pub fn swiev14(&self) -> SWIEV14_R {
        SWIEV14_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Interrupt/Event software trigger on line 15"]
    #[inline(always)]
    pub fn swiev15(&self) -> SWIEV15_R {
        SWIEV15_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Interrupt/Event software trigger on line 16"]
    #[inline(always)]
    pub fn swiev16(&self) -> SWIEV16_R {
        SWIEV16_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Interrupt/Event software trigger on line 17"]
    #[inline(always)]
    pub fn swiev17(&self) -> SWIEV17_R {
        SWIEV17_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Interrupt/Event software trigger on line 18"]
    #[inline(always)]
    pub fn swiev18(&self) -> SWIEV18_R {
        SWIEV18_R::new(((self.bits >> 18) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Interrupt/Event software trigger on line 0"]
    #[inline(always)]
    pub fn swiev0(&mut self) -> SWIEV0_W {
        SWIEV0_W { w: self }
    }
    #[doc = "Bit 1 - Interrupt/Event software trigger on line 1"]
    #[inline(always)]
    pub fn swiev1(&mut self) -> SWIEV1_W {
        SWIEV1_W { w: self }
    }
    #[doc = "Bit 2 - Interrupt/Event software trigger on line 2"]
    #[inline(always)]
    pub fn swiev2(&mut self) -> SWIEV2_W {
        SWIEV2_W { w: self }
    }
    #[doc = "Bit 3 - Interrupt/Event software trigger on line 3"]
    #[inline(always)]
    pub fn swiev3(&mut self) -> SWIEV3_W {
        SWIEV3_W { w: self }
    }
    #[doc = "Bit 4 - Interrupt/Event software trigger on line 4"]
    #[inline(always)]
    pub fn swiev4(&mut self) -> SWIEV4_W {
        SWIEV4_W { w: self }
    }
    #[doc = "Bit 5 - Interrupt/Event software trigger on line 5"]
    #[inline(always)]
    pub fn swiev5(&mut self) -> SWIEV5_W {
        SWIEV5_W { w: self }
    }
    #[doc = "Bit 6 - Interrupt/Event software trigger on line 6"]
    #[inline(always)]
    pub fn swiev6(&mut self) -> SWIEV6_W {
        SWIEV6_W { w: self }
    }
    #[doc = "Bit 7 - Interrupt/Event software trigger on line 7"]
    #[inline(always)]
    pub fn swiev7(&mut self) -> SWIEV7_W {
        SWIEV7_W { w: self }
    }
    #[doc = "Bit 8 - Interrupt/Event software trigger on line 8"]
    #[inline(always)]
    pub fn swiev8(&mut self) -> SWIEV8_W {
        SWIEV8_W { w: self }
    }
    #[doc = "Bit 9 - Interrupt/Event software trigger on line 9"]
    #[inline(always)]
    pub fn swiev9(&mut self) -> SWIEV9_W {
        SWIEV9_W { w: self }
    }
    #[doc = "Bit 10 - Interrupt/Event software trigger on line 10"]
    #[inline(always)]
    pub fn swiev10(&mut self) -> SWIEV10_W {
        SWIEV10_W { w: self }
    }
    #[doc = "Bit 11 - Interrupt/Event software trigger on line 11"]
    #[inline(always)]
    pub fn swiev11(&mut self) -> SWIEV11_W {
        SWIEV11_W { w: self }
    }
    #[doc = "Bit 12 - Interrupt/Event software trigger on line 12"]
    #[inline(always)]
    pub fn swiev12(&mut self) -> SWIEV12_W {
        SWIEV12_W { w: self }
    }
    #[doc = "Bit 13 - Interrupt/Event software trigger on line 13"]
    #[inline(always)]
    pub fn swiev13(&mut self) -> SWIEV13_W {
        SWIEV13_W { w: self }
    }
    #[doc = "Bit 14 - Interrupt/Event software trigger on line 14"]
    #[inline(always)]
    pub fn swiev14(&mut self) -> SWIEV14_W {
        SWIEV14_W { w: self }
    }
    #[doc = "Bit 15 - Interrupt/Event software trigger on line 15"]
    #[inline(always)]
    pub fn swiev15(&mut self) -> SWIEV15_W {
        SWIEV15_W { w: self }
    }
    #[doc = "Bit 16 - Interrupt/Event software trigger on line 16"]
    #[inline(always)]
    pub fn swiev16(&mut self) -> SWIEV16_W {
        SWIEV16_W { w: self }
    }
    #[doc = "Bit 17 - Interrupt/Event software trigger on line 17"]
    #[inline(always)]
    pub fn swiev17(&mut self) -> SWIEV17_W {
        SWIEV17_W { w: self }
    }
    #[doc = "Bit 18 - Interrupt/Event software trigger on line 18"]
    #[inline(always)]
    pub fn swiev18(&mut self) -> SWIEV18_W {
        SWIEV18_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Software interrupt event register (EXTI_SWIEV)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [swiev](index.html) module"]
pub struct SWIEV_SPEC;
impl crate::RegisterSpec for SWIEV_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [swiev::R](R) reader structure"]
impl crate::Readable for SWIEV_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [swiev::W](W) writer structure"]
impl crate::Writable for SWIEV_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SWIEV to value 0"]
impl crate::Resettable for SWIEV_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
