#[doc = "Register `SNWTCFG3` reader"]
pub struct R(crate::R<SNWTCFG3_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SNWTCFG3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SNWTCFG3_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SNWTCFG3_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SNWTCFG3` writer"]
pub struct W(crate::W<SNWTCFG3_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SNWTCFG3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SNWTCFG3_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SNWTCFG3_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `WASYNCMOD` reader - Asynchronous access mode"]
pub struct WASYNCMOD_R(crate::FieldReader<u8, u8>);
impl WASYNCMOD_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        WASYNCMOD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WASYNCMOD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WASYNCMOD` writer - Asynchronous access mode"]
pub struct WASYNCMOD_W<'a> {
    w: &'a mut W,
}
impl<'a> WASYNCMOD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 28)) | ((value as u32 & 0x03) << 28);
        self.w
    }
}
#[doc = "Field `WBUSLAT` reader - Bus latency"]
pub struct WBUSLAT_R(crate::FieldReader<u8, u8>);
impl WBUSLAT_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        WBUSLAT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WBUSLAT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WBUSLAT` writer - Bus latency"]
pub struct WBUSLAT_W<'a> {
    w: &'a mut W,
}
impl<'a> WBUSLAT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 16)) | ((value as u32 & 0x0f) << 16);
        self.w
    }
}
#[doc = "Field `WDSET` reader - Data setup time"]
pub struct WDSET_R(crate::FieldReader<u8, u8>);
impl WDSET_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        WDSET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDSET_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDSET` writer - Data setup time"]
pub struct WDSET_W<'a> {
    w: &'a mut W,
}
impl<'a> WDSET_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 8)) | ((value as u32 & 0xff) << 8);
        self.w
    }
}
#[doc = "Field `WAHLD` reader - Address hold time"]
pub struct WAHLD_R(crate::FieldReader<u8, u8>);
impl WAHLD_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        WAHLD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WAHLD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WAHLD` writer - Address hold time"]
pub struct WAHLD_W<'a> {
    w: &'a mut W,
}
impl<'a> WAHLD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `WASET` reader - Address setup time"]
pub struct WASET_R(crate::FieldReader<u8, u8>);
impl WASET_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        WASET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WASET_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WASET` writer - Address setup time"]
pub struct WASET_W<'a> {
    w: &'a mut W,
}
impl<'a> WASET_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
        self.w
    }
}
impl R {
    #[doc = "Bits 28:29 - Asynchronous access mode"]
    #[inline(always)]
    pub fn wasyncmod(&self) -> WASYNCMOD_R {
        WASYNCMOD_R::new(((self.bits >> 28) & 0x03) as u8)
    }
    #[doc = "Bits 16:19 - Bus latency"]
    #[inline(always)]
    pub fn wbuslat(&self) -> WBUSLAT_R {
        WBUSLAT_R::new(((self.bits >> 16) & 0x0f) as u8)
    }
    #[doc = "Bits 8:15 - Data setup time"]
    #[inline(always)]
    pub fn wdset(&self) -> WDSET_R {
        WDSET_R::new(((self.bits >> 8) & 0xff) as u8)
    }
    #[doc = "Bits 4:7 - Address hold time"]
    #[inline(always)]
    pub fn wahld(&self) -> WAHLD_R {
        WAHLD_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 0:3 - Address setup time"]
    #[inline(always)]
    pub fn waset(&self) -> WASET_R {
        WASET_R::new((self.bits & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bits 28:29 - Asynchronous access mode"]
    #[inline(always)]
    pub fn wasyncmod(&mut self) -> WASYNCMOD_W {
        WASYNCMOD_W { w: self }
    }
    #[doc = "Bits 16:19 - Bus latency"]
    #[inline(always)]
    pub fn wbuslat(&mut self) -> WBUSLAT_W {
        WBUSLAT_W { w: self }
    }
    #[doc = "Bits 8:15 - Data setup time"]
    #[inline(always)]
    pub fn wdset(&mut self) -> WDSET_W {
        WDSET_W { w: self }
    }
    #[doc = "Bits 4:7 - Address hold time"]
    #[inline(always)]
    pub fn wahld(&mut self) -> WAHLD_W {
        WAHLD_W { w: self }
    }
    #[doc = "Bits 0:3 - Address setup time"]
    #[inline(always)]
    pub fn waset(&mut self) -> WASET_W {
        WASET_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SRAM/NOR flash write timing configuration register 3\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [snwtcfg3](index.html) module"]
pub struct SNWTCFG3_SPEC;
impl crate::RegisterSpec for SNWTCFG3_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [snwtcfg3::R](R) reader structure"]
impl crate::Readable for SNWTCFG3_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [snwtcfg3::W](W) writer structure"]
impl crate::Writable for SNWTCFG3_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SNWTCFG3 to value 0x0fff_ffff"]
impl crate::Resettable for SNWTCFG3_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0fff_ffff
    }
}
