#[doc = "Register `SNTCFG2` reader"]
pub struct R(crate::R<SNTCFG2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SNTCFG2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SNTCFG2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SNTCFG2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SNTCFG2` writer"]
pub struct W(crate::W<SNTCFG2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SNTCFG2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SNTCFG2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SNTCFG2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ASYNCMOD` reader - Asynchronous access mode"]
pub struct ASYNCMOD_R(crate::FieldReader<u8, u8>);
impl ASYNCMOD_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ASYNCMOD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ASYNCMOD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ASYNCMOD` writer - Asynchronous access mode"]
pub struct ASYNCMOD_W<'a> {
    w: &'a mut W,
}
impl<'a> ASYNCMOD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 28)) | ((value as u32 & 0x03) << 28);
        self.w
    }
}
#[doc = "Field `DLAT` reader - Data latency for NOR Flash"]
pub struct DLAT_R(crate::FieldReader<u8, u8>);
impl DLAT_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        DLAT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DLAT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DLAT` writer - Data latency for NOR Flash"]
pub struct DLAT_W<'a> {
    w: &'a mut W,
}
impl<'a> DLAT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 24)) | ((value as u32 & 0x0f) << 24);
        self.w
    }
}
#[doc = "Field `CKDIV` reader - Synchronous clock divide ratio"]
pub struct CKDIV_R(crate::FieldReader<u8, u8>);
impl CKDIV_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        CKDIV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CKDIV_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CKDIV` writer - Synchronous clock divide ratio"]
pub struct CKDIV_W<'a> {
    w: &'a mut W,
}
impl<'a> CKDIV_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 20)) | ((value as u32 & 0x0f) << 20);
        self.w
    }
}
#[doc = "Field `BUSLAT` reader - Bus latency"]
pub struct BUSLAT_R(crate::FieldReader<u8, u8>);
impl BUSLAT_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        BUSLAT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BUSLAT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BUSLAT` writer - Bus latency"]
pub struct BUSLAT_W<'a> {
    w: &'a mut W,
}
impl<'a> BUSLAT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 16)) | ((value as u32 & 0x0f) << 16);
        self.w
    }
}
#[doc = "Field `DSET` reader - Data setup time"]
pub struct DSET_R(crate::FieldReader<u8, u8>);
impl DSET_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        DSET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DSET_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DSET` writer - Data setup time"]
pub struct DSET_W<'a> {
    w: &'a mut W,
}
impl<'a> DSET_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 8)) | ((value as u32 & 0xff) << 8);
        self.w
    }
}
#[doc = "Field `AHLD` reader - Address hold time"]
pub struct AHLD_R(crate::FieldReader<u8, u8>);
impl AHLD_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        AHLD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AHLD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AHLD` writer - Address hold time"]
pub struct AHLD_W<'a> {
    w: &'a mut W,
}
impl<'a> AHLD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `ASET` reader - Address setup time"]
pub struct ASET_R(crate::FieldReader<u8, u8>);
impl ASET_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ASET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ASET_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ASET` writer - Address setup time"]
pub struct ASET_W<'a> {
    w: &'a mut W,
}
impl<'a> ASET_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
        self.w
    }
}
impl R {
    #[doc = "Bits 28:29 - Asynchronous access mode"]
    #[inline(always)]
    pub fn asyncmod(&self) -> ASYNCMOD_R {
        ASYNCMOD_R::new(((self.bits >> 28) & 0x03) as u8)
    }
    #[doc = "Bits 24:27 - Data latency for NOR Flash"]
    #[inline(always)]
    pub fn dlat(&self) -> DLAT_R {
        DLAT_R::new(((self.bits >> 24) & 0x0f) as u8)
    }
    #[doc = "Bits 20:23 - Synchronous clock divide ratio"]
    #[inline(always)]
    pub fn ckdiv(&self) -> CKDIV_R {
        CKDIV_R::new(((self.bits >> 20) & 0x0f) as u8)
    }
    #[doc = "Bits 16:19 - Bus latency"]
    #[inline(always)]
    pub fn buslat(&self) -> BUSLAT_R {
        BUSLAT_R::new(((self.bits >> 16) & 0x0f) as u8)
    }
    #[doc = "Bits 8:15 - Data setup time"]
    #[inline(always)]
    pub fn dset(&self) -> DSET_R {
        DSET_R::new(((self.bits >> 8) & 0xff) as u8)
    }
    #[doc = "Bits 4:7 - Address hold time"]
    #[inline(always)]
    pub fn ahld(&self) -> AHLD_R {
        AHLD_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 0:3 - Address setup time"]
    #[inline(always)]
    pub fn aset(&self) -> ASET_R {
        ASET_R::new((self.bits & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bits 28:29 - Asynchronous access mode"]
    #[inline(always)]
    pub fn asyncmod(&mut self) -> ASYNCMOD_W {
        ASYNCMOD_W { w: self }
    }
    #[doc = "Bits 24:27 - Data latency for NOR Flash"]
    #[inline(always)]
    pub fn dlat(&mut self) -> DLAT_W {
        DLAT_W { w: self }
    }
    #[doc = "Bits 20:23 - Synchronous clock divide ratio"]
    #[inline(always)]
    pub fn ckdiv(&mut self) -> CKDIV_W {
        CKDIV_W { w: self }
    }
    #[doc = "Bits 16:19 - Bus latency"]
    #[inline(always)]
    pub fn buslat(&mut self) -> BUSLAT_W {
        BUSLAT_W { w: self }
    }
    #[doc = "Bits 8:15 - Data setup time"]
    #[inline(always)]
    pub fn dset(&mut self) -> DSET_W {
        DSET_W { w: self }
    }
    #[doc = "Bits 4:7 - Address hold time"]
    #[inline(always)]
    pub fn ahld(&mut self) -> AHLD_W {
        AHLD_W { w: self }
    }
    #[doc = "Bits 0:3 - Address setup time"]
    #[inline(always)]
    pub fn aset(&mut self) -> ASET_W {
        ASET_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SRAM/NOR flash timing configuration register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sntcfg2](index.html) module"]
pub struct SNTCFG2_SPEC;
impl crate::RegisterSpec for SNTCFG2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [sntcfg2::R](R) reader structure"]
impl crate::Readable for SNTCFG2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [sntcfg2::W](W) writer structure"]
impl crate::Writable for SNTCFG2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SNTCFG2 to value 0x0fff_ffff"]
impl crate::Resettable for SNTCFG2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0fff_ffff
    }
}
