#[doc = "Register `SNCTL2` reader"]
pub struct R(crate::R<SNCTL2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SNCTL2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SNCTL2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SNCTL2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SNCTL2` writer"]
pub struct W(crate::W<SNCTL2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SNCTL2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SNCTL2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SNCTL2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SYNCWR` reader - Synchronous write"]
pub struct SYNCWR_R(crate::FieldReader<bool, bool>);
impl SYNCWR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SYNCWR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SYNCWR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SYNCWR` writer - Synchronous write"]
pub struct SYNCWR_W<'a> {
    w: &'a mut W,
}
impl<'a> SYNCWR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Field `CPS` reader - CRAM page size"]
pub struct CPS_R(crate::FieldReader<u8, u8>);
impl CPS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        CPS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CPS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CPS` writer - CRAM page size"]
pub struct CPS_W<'a> {
    w: &'a mut W,
}
impl<'a> CPS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 16)) | ((value as u32 & 0x07) << 16);
        self.w
    }
}
#[doc = "Field `ASYNCWAIT` reader - Asynchronous wait"]
pub struct ASYNCWAIT_R(crate::FieldReader<bool, bool>);
impl ASYNCWAIT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ASYNCWAIT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ASYNCWAIT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ASYNCWAIT` writer - Asynchronous wait"]
pub struct ASYNCWAIT_W<'a> {
    w: &'a mut W,
}
impl<'a> ASYNCWAIT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `EXMODEN` reader - Extended mode enable"]
pub struct EXMODEN_R(crate::FieldReader<bool, bool>);
impl EXMODEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        EXMODEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXMODEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXMODEN` writer - Extended mode enable"]
pub struct EXMODEN_W<'a> {
    w: &'a mut W,
}
impl<'a> EXMODEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `NRWTEN` reader - NWAIT signal enable"]
pub struct NRWTEN_R(crate::FieldReader<bool, bool>);
impl NRWTEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NRWTEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NRWTEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NRWTEN` writer - NWAIT signal enable"]
pub struct NRWTEN_W<'a> {
    w: &'a mut W,
}
impl<'a> NRWTEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `WREN` reader - Write enable"]
pub struct WREN_R(crate::FieldReader<bool, bool>);
impl WREN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        WREN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WREN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WREN` writer - Write enable"]
pub struct WREN_W<'a> {
    w: &'a mut W,
}
impl<'a> WREN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `NRWTCFG` reader - NWAIT signal configuration, only work in synchronous mode"]
pub struct NRWTCFG_R(crate::FieldReader<bool, bool>);
impl NRWTCFG_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NRWTCFG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NRWTCFG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NRWTCFG` writer - NWAIT signal configuration, only work in synchronous mode"]
pub struct NRWTCFG_W<'a> {
    w: &'a mut W,
}
impl<'a> NRWTCFG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `WRAPEN` reader - Wrapped burst mode enable"]
pub struct WRAPEN_R(crate::FieldReader<bool, bool>);
impl WRAPEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        WRAPEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WRAPEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WRAPEN` writer - Wrapped burst mode enable"]
pub struct WRAPEN_W<'a> {
    w: &'a mut W,
}
impl<'a> WRAPEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `NRWTPOL` reader - NWAIT signal polarity"]
pub struct NRWTPOL_R(crate::FieldReader<bool, bool>);
impl NRWTPOL_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NRWTPOL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NRWTPOL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NRWTPOL` writer - NWAIT signal polarity"]
pub struct NRWTPOL_W<'a> {
    w: &'a mut W,
}
impl<'a> NRWTPOL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `SBRSTEN` reader - Synchronous burst enable"]
pub struct SBRSTEN_R(crate::FieldReader<bool, bool>);
impl SBRSTEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SBRSTEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SBRSTEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SBRSTEN` writer - Synchronous burst enable"]
pub struct SBRSTEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SBRSTEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `NREN` reader - NOR Flash access enable"]
pub struct NREN_R(crate::FieldReader<bool, bool>);
impl NREN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NREN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NREN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NREN` writer - NOR Flash access enable"]
pub struct NREN_W<'a> {
    w: &'a mut W,
}
impl<'a> NREN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `NRW` reader - NOR bank memory data bus width"]
pub struct NRW_R(crate::FieldReader<u8, u8>);
impl NRW_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        NRW_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NRW_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NRW` writer - NOR bank memory data bus width"]
pub struct NRW_W<'a> {
    w: &'a mut W,
}
impl<'a> NRW_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u32 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `NRTP` reader - NOR bank memory type"]
pub struct NRTP_R(crate::FieldReader<u8, u8>);
impl NRTP_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        NRTP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NRTP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NRTP` writer - NOR bank memory type"]
pub struct NRTP_W<'a> {
    w: &'a mut W,
}
impl<'a> NRTP_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u32 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `NRMUX` reader - NOR bank memory address/data multiplexing"]
pub struct NRMUX_R(crate::FieldReader<bool, bool>);
impl NRMUX_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NRMUX_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NRMUX_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NRMUX` writer - NOR bank memory address/data multiplexing"]
pub struct NRMUX_W<'a> {
    w: &'a mut W,
}
impl<'a> NRMUX_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `NRBKEN` reader - NOR bank enable"]
pub struct NRBKEN_R(crate::FieldReader<bool, bool>);
impl NRBKEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NRBKEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NRBKEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NRBKEN` writer - NOR bank enable"]
pub struct NRBKEN_W<'a> {
    w: &'a mut W,
}
impl<'a> NRBKEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 19 - Synchronous write"]
    #[inline(always)]
    pub fn syncwr(&self) -> SYNCWR_R {
        SYNCWR_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bits 16:18 - CRAM page size"]
    #[inline(always)]
    pub fn cps(&self) -> CPS_R {
        CPS_R::new(((self.bits >> 16) & 0x07) as u8)
    }
    #[doc = "Bit 15 - Asynchronous wait"]
    #[inline(always)]
    pub fn asyncwait(&self) -> ASYNCWAIT_R {
        ASYNCWAIT_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Extended mode enable"]
    #[inline(always)]
    pub fn exmoden(&self) -> EXMODEN_R {
        EXMODEN_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 13 - NWAIT signal enable"]
    #[inline(always)]
    pub fn nrwten(&self) -> NRWTEN_R {
        NRWTEN_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Write enable"]
    #[inline(always)]
    pub fn wren(&self) -> WREN_R {
        WREN_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - NWAIT signal configuration, only work in synchronous mode"]
    #[inline(always)]
    pub fn nrwtcfg(&self) -> NRWTCFG_R {
        NRWTCFG_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Wrapped burst mode enable"]
    #[inline(always)]
    pub fn wrapen(&self) -> WRAPEN_R {
        WRAPEN_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - NWAIT signal polarity"]
    #[inline(always)]
    pub fn nrwtpol(&self) -> NRWTPOL_R {
        NRWTPOL_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Synchronous burst enable"]
    #[inline(always)]
    pub fn sbrsten(&self) -> SBRSTEN_R {
        SBRSTEN_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 6 - NOR Flash access enable"]
    #[inline(always)]
    pub fn nren(&self) -> NREN_R {
        NREN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - NOR bank memory data bus width"]
    #[inline(always)]
    pub fn nrw(&self) -> NRW_R {
        NRW_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - NOR bank memory type"]
    #[inline(always)]
    pub fn nrtp(&self) -> NRTP_R {
        NRTP_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bit 1 - NOR bank memory address/data multiplexing"]
    #[inline(always)]
    pub fn nrmux(&self) -> NRMUX_R {
        NRMUX_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - NOR bank enable"]
    #[inline(always)]
    pub fn nrbken(&self) -> NRBKEN_R {
        NRBKEN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 19 - Synchronous write"]
    #[inline(always)]
    pub fn syncwr(&mut self) -> SYNCWR_W {
        SYNCWR_W { w: self }
    }
    #[doc = "Bits 16:18 - CRAM page size"]
    #[inline(always)]
    pub fn cps(&mut self) -> CPS_W {
        CPS_W { w: self }
    }
    #[doc = "Bit 15 - Asynchronous wait"]
    #[inline(always)]
    pub fn asyncwait(&mut self) -> ASYNCWAIT_W {
        ASYNCWAIT_W { w: self }
    }
    #[doc = "Bit 14 - Extended mode enable"]
    #[inline(always)]
    pub fn exmoden(&mut self) -> EXMODEN_W {
        EXMODEN_W { w: self }
    }
    #[doc = "Bit 13 - NWAIT signal enable"]
    #[inline(always)]
    pub fn nrwten(&mut self) -> NRWTEN_W {
        NRWTEN_W { w: self }
    }
    #[doc = "Bit 12 - Write enable"]
    #[inline(always)]
    pub fn wren(&mut self) -> WREN_W {
        WREN_W { w: self }
    }
    #[doc = "Bit 11 - NWAIT signal configuration, only work in synchronous mode"]
    #[inline(always)]
    pub fn nrwtcfg(&mut self) -> NRWTCFG_W {
        NRWTCFG_W { w: self }
    }
    #[doc = "Bit 10 - Wrapped burst mode enable"]
    #[inline(always)]
    pub fn wrapen(&mut self) -> WRAPEN_W {
        WRAPEN_W { w: self }
    }
    #[doc = "Bit 9 - NWAIT signal polarity"]
    #[inline(always)]
    pub fn nrwtpol(&mut self) -> NRWTPOL_W {
        NRWTPOL_W { w: self }
    }
    #[doc = "Bit 8 - Synchronous burst enable"]
    #[inline(always)]
    pub fn sbrsten(&mut self) -> SBRSTEN_W {
        SBRSTEN_W { w: self }
    }
    #[doc = "Bit 6 - NOR Flash access enable"]
    #[inline(always)]
    pub fn nren(&mut self) -> NREN_W {
        NREN_W { w: self }
    }
    #[doc = "Bits 4:5 - NOR bank memory data bus width"]
    #[inline(always)]
    pub fn nrw(&mut self) -> NRW_W {
        NRW_W { w: self }
    }
    #[doc = "Bits 2:3 - NOR bank memory type"]
    #[inline(always)]
    pub fn nrtp(&mut self) -> NRTP_W {
        NRTP_W { w: self }
    }
    #[doc = "Bit 1 - NOR bank memory address/data multiplexing"]
    #[inline(always)]
    pub fn nrmux(&mut self) -> NRMUX_W {
        NRMUX_W { w: self }
    }
    #[doc = "Bit 0 - NOR bank enable"]
    #[inline(always)]
    pub fn nrbken(&mut self) -> NRBKEN_W {
        NRBKEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SRAM/NOR flash control register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [snctl2](index.html) module"]
pub struct SNCTL2_SPEC;
impl crate::RegisterSpec for SNCTL2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [snctl2::R](R) reader structure"]
impl crate::Readable for SNCTL2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [snctl2::W](W) writer structure"]
impl crate::Writable for SNCTL2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SNCTL2 to value 0x30d2"]
impl crate::Resettable for SNCTL2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x30d2
    }
}
