#[doc = "Register `NPINTEN2` reader"]
pub struct R(crate::R<NPINTEN2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<NPINTEN2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<NPINTEN2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<NPINTEN2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `NPINTEN2` writer"]
pub struct W(crate::W<NPINTEN2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<NPINTEN2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<NPINTEN2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<NPINTEN2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `FFEPT` reader - FIFO empty flag"]
pub struct FFEPT_R(crate::FieldReader<bool, bool>);
impl FFEPT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FFEPT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FFEPT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FFEPT` writer - FIFO empty flag"]
pub struct FFEPT_W<'a> {
    w: &'a mut W,
}
impl<'a> FFEPT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `INTFEN` reader - Interrupt falling edge detection enable"]
pub struct INTFEN_R(crate::FieldReader<bool, bool>);
impl INTFEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        INTFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTFEN` writer - Interrupt falling edge detection enable"]
pub struct INTFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> INTFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `INTHEN` reader - Interrupt high-level detection enable"]
pub struct INTHEN_R(crate::FieldReader<bool, bool>);
impl INTHEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        INTHEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTHEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTHEN` writer - Interrupt high-level detection enable"]
pub struct INTHEN_W<'a> {
    w: &'a mut W,
}
impl<'a> INTHEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `INTREN` reader - Interrupt rising edge detection enable bit"]
pub struct INTREN_R(crate::FieldReader<bool, bool>);
impl INTREN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        INTREN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTREN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTREN` writer - Interrupt rising edge detection enable bit"]
pub struct INTREN_W<'a> {
    w: &'a mut W,
}
impl<'a> INTREN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `INTFS` reader - Interrupt falling edge status"]
pub struct INTFS_R(crate::FieldReader<bool, bool>);
impl INTFS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        INTFS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTFS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTFS` writer - Interrupt falling edge status"]
pub struct INTFS_W<'a> {
    w: &'a mut W,
}
impl<'a> INTFS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `INTHS` reader - Interrupt high-level status"]
pub struct INTHS_R(crate::FieldReader<bool, bool>);
impl INTHS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        INTHS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTHS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTHS` writer - Interrupt high-level status"]
pub struct INTHS_W<'a> {
    w: &'a mut W,
}
impl<'a> INTHS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `INTRS` reader - Interrupt rising edge status"]
pub struct INTRS_R(crate::FieldReader<bool, bool>);
impl INTRS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        INTRS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTRS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTRS` writer - Interrupt rising edge status"]
pub struct INTRS_W<'a> {
    w: &'a mut W,
}
impl<'a> INTRS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 6 - FIFO empty flag"]
    #[inline(always)]
    pub fn ffept(&self) -> FFEPT_R {
        FFEPT_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Interrupt falling edge detection enable"]
    #[inline(always)]
    pub fn intfen(&self) -> INTFEN_R {
        INTFEN_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Interrupt high-level detection enable"]
    #[inline(always)]
    pub fn inthen(&self) -> INTHEN_R {
        INTHEN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Interrupt rising edge detection enable bit"]
    #[inline(always)]
    pub fn intren(&self) -> INTREN_R {
        INTREN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Interrupt falling edge status"]
    #[inline(always)]
    pub fn intfs(&self) -> INTFS_R {
        INTFS_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Interrupt high-level status"]
    #[inline(always)]
    pub fn inths(&self) -> INTHS_R {
        INTHS_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Interrupt rising edge status"]
    #[inline(always)]
    pub fn intrs(&self) -> INTRS_R {
        INTRS_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 6 - FIFO empty flag"]
    #[inline(always)]
    pub fn ffept(&mut self) -> FFEPT_W {
        FFEPT_W { w: self }
    }
    #[doc = "Bit 5 - Interrupt falling edge detection enable"]
    #[inline(always)]
    pub fn intfen(&mut self) -> INTFEN_W {
        INTFEN_W { w: self }
    }
    #[doc = "Bit 4 - Interrupt high-level detection enable"]
    #[inline(always)]
    pub fn inthen(&mut self) -> INTHEN_W {
        INTHEN_W { w: self }
    }
    #[doc = "Bit 3 - Interrupt rising edge detection enable bit"]
    #[inline(always)]
    pub fn intren(&mut self) -> INTREN_W {
        INTREN_W { w: self }
    }
    #[doc = "Bit 2 - Interrupt falling edge status"]
    #[inline(always)]
    pub fn intfs(&mut self) -> INTFS_W {
        INTFS_W { w: self }
    }
    #[doc = "Bit 1 - Interrupt high-level status"]
    #[inline(always)]
    pub fn inths(&mut self) -> INTHS_W {
        INTHS_W { w: self }
    }
    #[doc = "Bit 0 - Interrupt rising edge status"]
    #[inline(always)]
    pub fn intrs(&mut self) -> INTRS_W {
        INTRS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "NAND flash/PC card interrupt enable register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [npinten2](index.html) module"]
pub struct NPINTEN2_SPEC;
impl crate::RegisterSpec for NPINTEN2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [npinten2::R](R) reader structure"]
impl crate::Readable for NPINTEN2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [npinten2::W](W) writer structure"]
impl crate::Writable for NPINTEN2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets NPINTEN2 to value 0x40"]
impl crate::Resettable for NPINTEN2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x40
    }
}
