#[doc = "Register `NPCTCFG3` reader"]
pub struct R(crate::R<NPCTCFG3_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<NPCTCFG3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<NPCTCFG3_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<NPCTCFG3_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `NPCTCFG3` writer"]
pub struct W(crate::W<NPCTCFG3_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<NPCTCFG3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<NPCTCFG3_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<NPCTCFG3_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `COMHIZ` reader - Common memory data bus HiZ time"]
pub struct COMHIZ_R(crate::FieldReader<u8, u8>);
impl COMHIZ_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        COMHIZ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COMHIZ_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COMHIZ` writer - Common memory data bus HiZ time"]
pub struct COMHIZ_W<'a> {
    w: &'a mut W,
}
impl<'a> COMHIZ_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 24)) | ((value as u32 & 0xff) << 24);
        self.w
    }
}
#[doc = "Field `COMHLD` reader - Common memory hold time"]
pub struct COMHLD_R(crate::FieldReader<u8, u8>);
impl COMHLD_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        COMHLD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COMHLD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COMHLD` writer - Common memory hold time"]
pub struct COMHLD_W<'a> {
    w: &'a mut W,
}
impl<'a> COMHLD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 16)) | ((value as u32 & 0xff) << 16);
        self.w
    }
}
#[doc = "Field `COMWAIT` reader - Common memory wait time"]
pub struct COMWAIT_R(crate::FieldReader<u8, u8>);
impl COMWAIT_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        COMWAIT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COMWAIT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COMWAIT` writer - Common memory wait time"]
pub struct COMWAIT_W<'a> {
    w: &'a mut W,
}
impl<'a> COMWAIT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 8)) | ((value as u32 & 0xff) << 8);
        self.w
    }
}
#[doc = "Field `COMSET` reader - Common memory setup time"]
pub struct COMSET_R(crate::FieldReader<u8, u8>);
impl COMSET_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        COMSET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COMSET_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COMSET` writer - Common memory setup time"]
pub struct COMSET_W<'a> {
    w: &'a mut W,
}
impl<'a> COMSET_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 24:31 - Common memory data bus HiZ time"]
    #[inline(always)]
    pub fn comhiz(&self) -> COMHIZ_R {
        COMHIZ_R::new(((self.bits >> 24) & 0xff) as u8)
    }
    #[doc = "Bits 16:23 - Common memory hold time"]
    #[inline(always)]
    pub fn comhld(&self) -> COMHLD_R {
        COMHLD_R::new(((self.bits >> 16) & 0xff) as u8)
    }
    #[doc = "Bits 8:15 - Common memory wait time"]
    #[inline(always)]
    pub fn comwait(&self) -> COMWAIT_R {
        COMWAIT_R::new(((self.bits >> 8) & 0xff) as u8)
    }
    #[doc = "Bits 0:7 - Common memory setup time"]
    #[inline(always)]
    pub fn comset(&self) -> COMSET_R {
        COMSET_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 24:31 - Common memory data bus HiZ time"]
    #[inline(always)]
    pub fn comhiz(&mut self) -> COMHIZ_W {
        COMHIZ_W { w: self }
    }
    #[doc = "Bits 16:23 - Common memory hold time"]
    #[inline(always)]
    pub fn comhld(&mut self) -> COMHLD_W {
        COMHLD_W { w: self }
    }
    #[doc = "Bits 8:15 - Common memory wait time"]
    #[inline(always)]
    pub fn comwait(&mut self) -> COMWAIT_W {
        COMWAIT_W { w: self }
    }
    #[doc = "Bits 0:7 - Common memory setup time"]
    #[inline(always)]
    pub fn comset(&mut self) -> COMSET_W {
        COMSET_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "NAND flash/PC card common space timing configuration register 3\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [npctcfg3](index.html) module"]
pub struct NPCTCFG3_SPEC;
impl crate::RegisterSpec for NPCTCFG3_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [npctcfg3::R](R) reader structure"]
impl crate::Readable for NPCTCFG3_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [npctcfg3::W](W) writer structure"]
impl crate::Writable for NPCTCFG3_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets NPCTCFG3 to value 0xfcfc_fcfc"]
impl crate::Resettable for NPCTCFG3_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0xfcfc_fcfc
    }
}
