#[doc = "Register `CTL` reader"]
pub struct R(crate::R<CTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTL` writer"]
pub struct W(crate::W<CTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DEN0` reader - DAC0 enable"]
pub struct DEN0_R(crate::FieldReader<bool, bool>);
impl DEN0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DEN0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DEN0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DEN0` writer - DAC0 enable"]
pub struct DEN0_W<'a> {
    w: &'a mut W,
}
impl<'a> DEN0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `DBOFF0` reader - DAC0 output buffer turn off"]
pub struct DBOFF0_R(crate::FieldReader<bool, bool>);
impl DBOFF0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DBOFF0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DBOFF0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DBOFF0` writer - DAC0 output buffer turn off"]
pub struct DBOFF0_W<'a> {
    w: &'a mut W,
}
impl<'a> DBOFF0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `DTEN0` reader - DAC0 trigger enable"]
pub struct DTEN0_R(crate::FieldReader<bool, bool>);
impl DTEN0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTEN0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTEN0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTEN0` writer - DAC0 trigger enable"]
pub struct DTEN0_W<'a> {
    w: &'a mut W,
}
impl<'a> DTEN0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `DTSEL0` reader - DAC0 trigger selection"]
pub struct DTSEL0_R(crate::FieldReader<u8, u8>);
impl DTSEL0_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        DTSEL0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTSEL0_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTSEL0` writer - DAC0 trigger selection"]
pub struct DTSEL0_W<'a> {
    w: &'a mut W,
}
impl<'a> DTSEL0_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 3)) | ((value as u32 & 0x07) << 3);
        self.w
    }
}
#[doc = "Field `DWM0` reader - DAC0 noise wave mode"]
pub struct DWM0_R(crate::FieldReader<u8, u8>);
impl DWM0_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        DWM0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DWM0_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DWM0` writer - DAC0 noise wave mode"]
pub struct DWM0_W<'a> {
    w: &'a mut W,
}
impl<'a> DWM0_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u32 & 0x03) << 6);
        self.w
    }
}
#[doc = "Field `DWBW0` reader - DAC0 noise wave bit width"]
pub struct DWBW0_R(crate::FieldReader<u8, u8>);
impl DWBW0_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        DWBW0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DWBW0_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DWBW0` writer - DAC0 noise wave bit width"]
pub struct DWBW0_W<'a> {
    w: &'a mut W,
}
impl<'a> DWBW0_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 8)) | ((value as u32 & 0x0f) << 8);
        self.w
    }
}
#[doc = "Field `DDMAEN0` reader - DAC0 DMA enable"]
pub struct DDMAEN0_R(crate::FieldReader<bool, bool>);
impl DDMAEN0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DDMAEN0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DDMAEN0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DDMAEN0` writer - DAC0 DMA enable"]
pub struct DDMAEN0_W<'a> {
    w: &'a mut W,
}
impl<'a> DDMAEN0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `DEN1` reader - DAC1 enable"]
pub struct DEN1_R(crate::FieldReader<bool, bool>);
impl DEN1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DEN1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DEN1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DEN1` writer - DAC1 enable"]
pub struct DEN1_W<'a> {
    w: &'a mut W,
}
impl<'a> DEN1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `DBOFF1` reader - DAC1 output buffer turn off"]
pub struct DBOFF1_R(crate::FieldReader<bool, bool>);
impl DBOFF1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DBOFF1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DBOFF1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DBOFF1` writer - DAC1 output buffer turn off"]
pub struct DBOFF1_W<'a> {
    w: &'a mut W,
}
impl<'a> DBOFF1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `DTEN1` reader - DAC1 trigger enable"]
pub struct DTEN1_R(crate::FieldReader<bool, bool>);
impl DTEN1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTEN1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTEN1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTEN1` writer - DAC1 trigger enable"]
pub struct DTEN1_W<'a> {
    w: &'a mut W,
}
impl<'a> DTEN1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `DTSEL1` reader - DAC1 trigger selection"]
pub struct DTSEL1_R(crate::FieldReader<u8, u8>);
impl DTSEL1_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        DTSEL1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTSEL1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTSEL1` writer - DAC1 trigger selection"]
pub struct DTSEL1_W<'a> {
    w: &'a mut W,
}
impl<'a> DTSEL1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 19)) | ((value as u32 & 0x07) << 19);
        self.w
    }
}
#[doc = "Field `DWM1` reader - DAC1 noise wave mode"]
pub struct DWM1_R(crate::FieldReader<u8, u8>);
impl DWM1_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        DWM1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DWM1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DWM1` writer - DAC1 noise wave mode"]
pub struct DWM1_W<'a> {
    w: &'a mut W,
}
impl<'a> DWM1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 22)) | ((value as u32 & 0x03) << 22);
        self.w
    }
}
#[doc = "Field `DWBW1` reader - DAC1 noise wave bit width"]
pub struct DWBW1_R(crate::FieldReader<u8, u8>);
impl DWBW1_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        DWBW1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DWBW1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DWBW1` writer - DAC1 noise wave bit width"]
pub struct DWBW1_W<'a> {
    w: &'a mut W,
}
impl<'a> DWBW1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 24)) | ((value as u32 & 0x0f) << 24);
        self.w
    }
}
#[doc = "Field `DDMAEN1` reader - DAC1 DMA enable"]
pub struct DDMAEN1_R(crate::FieldReader<bool, bool>);
impl DDMAEN1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DDMAEN1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DDMAEN1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DDMAEN1` writer - DAC1 DMA enable"]
pub struct DDMAEN1_W<'a> {
    w: &'a mut W,
}
impl<'a> DDMAEN1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 28)) | ((value as u32 & 0x01) << 28);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - DAC0 enable"]
    #[inline(always)]
    pub fn den0(&self) -> DEN0_R {
        DEN0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - DAC0 output buffer turn off"]
    #[inline(always)]
    pub fn dboff0(&self) -> DBOFF0_R {
        DBOFF0_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - DAC0 trigger enable"]
    #[inline(always)]
    pub fn dten0(&self) -> DTEN0_R {
        DTEN0_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bits 3:5 - DAC0 trigger selection"]
    #[inline(always)]
    pub fn dtsel0(&self) -> DTSEL0_R {
        DTSEL0_R::new(((self.bits >> 3) & 0x07) as u8)
    }
    #[doc = "Bits 6:7 - DAC0 noise wave mode"]
    #[inline(always)]
    pub fn dwm0(&self) -> DWM0_R {
        DWM0_R::new(((self.bits >> 6) & 0x03) as u8)
    }
    #[doc = "Bits 8:11 - DAC0 noise wave bit width"]
    #[inline(always)]
    pub fn dwbw0(&self) -> DWBW0_R {
        DWBW0_R::new(((self.bits >> 8) & 0x0f) as u8)
    }
    #[doc = "Bit 12 - DAC0 DMA enable"]
    #[inline(always)]
    pub fn ddmaen0(&self) -> DDMAEN0_R {
        DDMAEN0_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 16 - DAC1 enable"]
    #[inline(always)]
    pub fn den1(&self) -> DEN1_R {
        DEN1_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - DAC1 output buffer turn off"]
    #[inline(always)]
    pub fn dboff1(&self) -> DBOFF1_R {
        DBOFF1_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - DAC1 trigger enable"]
    #[inline(always)]
    pub fn dten1(&self) -> DTEN1_R {
        DTEN1_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bits 19:21 - DAC1 trigger selection"]
    #[inline(always)]
    pub fn dtsel1(&self) -> DTSEL1_R {
        DTSEL1_R::new(((self.bits >> 19) & 0x07) as u8)
    }
    #[doc = "Bits 22:23 - DAC1 noise wave mode"]
    #[inline(always)]
    pub fn dwm1(&self) -> DWM1_R {
        DWM1_R::new(((self.bits >> 22) & 0x03) as u8)
    }
    #[doc = "Bits 24:27 - DAC1 noise wave bit width"]
    #[inline(always)]
    pub fn dwbw1(&self) -> DWBW1_R {
        DWBW1_R::new(((self.bits >> 24) & 0x0f) as u8)
    }
    #[doc = "Bit 28 - DAC1 DMA enable"]
    #[inline(always)]
    pub fn ddmaen1(&self) -> DDMAEN1_R {
        DDMAEN1_R::new(((self.bits >> 28) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - DAC0 enable"]
    #[inline(always)]
    pub fn den0(&mut self) -> DEN0_W {
        DEN0_W { w: self }
    }
    #[doc = "Bit 1 - DAC0 output buffer turn off"]
    #[inline(always)]
    pub fn dboff0(&mut self) -> DBOFF0_W {
        DBOFF0_W { w: self }
    }
    #[doc = "Bit 2 - DAC0 trigger enable"]
    #[inline(always)]
    pub fn dten0(&mut self) -> DTEN0_W {
        DTEN0_W { w: self }
    }
    #[doc = "Bits 3:5 - DAC0 trigger selection"]
    #[inline(always)]
    pub fn dtsel0(&mut self) -> DTSEL0_W {
        DTSEL0_W { w: self }
    }
    #[doc = "Bits 6:7 - DAC0 noise wave mode"]
    #[inline(always)]
    pub fn dwm0(&mut self) -> DWM0_W {
        DWM0_W { w: self }
    }
    #[doc = "Bits 8:11 - DAC0 noise wave bit width"]
    #[inline(always)]
    pub fn dwbw0(&mut self) -> DWBW0_W {
        DWBW0_W { w: self }
    }
    #[doc = "Bit 12 - DAC0 DMA enable"]
    #[inline(always)]
    pub fn ddmaen0(&mut self) -> DDMAEN0_W {
        DDMAEN0_W { w: self }
    }
    #[doc = "Bit 16 - DAC1 enable"]
    #[inline(always)]
    pub fn den1(&mut self) -> DEN1_W {
        DEN1_W { w: self }
    }
    #[doc = "Bit 17 - DAC1 output buffer turn off"]
    #[inline(always)]
    pub fn dboff1(&mut self) -> DBOFF1_W {
        DBOFF1_W { w: self }
    }
    #[doc = "Bit 18 - DAC1 trigger enable"]
    #[inline(always)]
    pub fn dten1(&mut self) -> DTEN1_W {
        DTEN1_W { w: self }
    }
    #[doc = "Bits 19:21 - DAC1 trigger selection"]
    #[inline(always)]
    pub fn dtsel1(&mut self) -> DTSEL1_W {
        DTSEL1_W { w: self }
    }
    #[doc = "Bits 22:23 - DAC1 noise wave mode"]
    #[inline(always)]
    pub fn dwm1(&mut self) -> DWM1_W {
        DWM1_W { w: self }
    }
    #[doc = "Bits 24:27 - DAC1 noise wave bit width"]
    #[inline(always)]
    pub fn dwbw1(&mut self) -> DWBW1_W {
        DWBW1_W { w: self }
    }
    #[doc = "Bit 28 - DAC1 DMA enable"]
    #[inline(always)]
    pub fn ddmaen1(&mut self) -> DDMAEN1_W {
        DDMAEN1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctl](index.html) module"]
pub struct CTL_SPEC;
impl crate::RegisterSpec for CTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [ctl::R](R) reader structure"]
impl crate::Readable for CTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctl::W](W) writer structure"]
impl crate::Writable for CTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTL to value 0"]
impl crate::Resettable for CTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
