#[doc = "Register `STAT` reader"]
pub struct R(crate::R<STAT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<STAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<STAT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<STAT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `CKOKIF` reader - Clock trim OK interrupt flag"]
pub struct CKOKIF_R(crate::FieldReader<bool, bool>);
impl CKOKIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CKOKIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CKOKIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CKWARNIF` reader - Clock trim warning interrupt flag"]
pub struct CKWARNIF_R(crate::FieldReader<bool, bool>);
impl CKWARNIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CKWARNIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CKWARNIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ERRIF` reader - Error interrupt flag"]
pub struct ERRIF_R(crate::FieldReader<bool, bool>);
impl ERRIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ERRIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ERRIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EREFIF` reader - Expect reference interrupt flag"]
pub struct EREFIF_R(crate::FieldReader<bool, bool>);
impl EREFIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        EREFIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EREFIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CKERR` reader - Clock trim error bit"]
pub struct CKERR_R(crate::FieldReader<bool, bool>);
impl CKERR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CKERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CKERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `REFMISS` reader - Reference sync pulse miss"]
pub struct REFMISS_R(crate::FieldReader<bool, bool>);
impl REFMISS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        REFMISS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REFMISS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TRIMERR` reader - Trim value error bit"]
pub struct TRIMERR_R(crate::FieldReader<bool, bool>);
impl TRIMERR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TRIMERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TRIMERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `REFDIR` reader - CTC trim counter direction when reference sync pulse"]
pub struct REFDIR_R(crate::FieldReader<bool, bool>);
impl REFDIR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        REFDIR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REFDIR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `REFCAP` reader - CTC counter capture when reference sync pulse"]
pub struct REFCAP_R(crate::FieldReader<u16, u16>);
impl REFCAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        REFCAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REFCAP_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - Clock trim OK interrupt flag"]
    #[inline(always)]
    pub fn ckokif(&self) -> CKOKIF_R {
        CKOKIF_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Clock trim warning interrupt flag"]
    #[inline(always)]
    pub fn ckwarnif(&self) -> CKWARNIF_R {
        CKWARNIF_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Error interrupt flag"]
    #[inline(always)]
    pub fn errif(&self) -> ERRIF_R {
        ERRIF_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Expect reference interrupt flag"]
    #[inline(always)]
    pub fn erefif(&self) -> EREFIF_R {
        EREFIF_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Clock trim error bit"]
    #[inline(always)]
    pub fn ckerr(&self) -> CKERR_R {
        CKERR_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Reference sync pulse miss"]
    #[inline(always)]
    pub fn refmiss(&self) -> REFMISS_R {
        REFMISS_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Trim value error bit"]
    #[inline(always)]
    pub fn trimerr(&self) -> TRIMERR_R {
        TRIMERR_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 15 - CTC trim counter direction when reference sync pulse"]
    #[inline(always)]
    pub fn refdir(&self) -> REFDIR_R {
        REFDIR_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bits 16:31 - CTC counter capture when reference sync pulse"]
    #[inline(always)]
    pub fn refcap(&self) -> REFCAP_R {
        REFCAP_R::new(((self.bits >> 16) & 0xffff) as u16)
    }
}
#[doc = "Status register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [stat](index.html) module"]
pub struct STAT_SPEC;
impl crate::RegisterSpec for STAT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [stat::R](R) reader structure"]
impl crate::Readable for STAT_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets STAT to value 0"]
impl crate::Resettable for STAT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
