#[doc = "Register `TMI2` reader"]
pub struct R(crate::R<TMI2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TMI2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TMI2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TMI2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TMI2` writer"]
pub struct W(crate::W<TMI2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TMI2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TMI2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TMI2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SFID_EFID` reader - The frame identifier"]
pub struct SFID_EFID_R(crate::FieldReader<u16, u16>);
impl SFID_EFID_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        SFID_EFID_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SFID_EFID_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SFID_EFID` writer - The frame identifier"]
pub struct SFID_EFID_W<'a> {
    w: &'a mut W,
}
impl<'a> SFID_EFID_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07ff << 21)) | ((value as u32 & 0x07ff) << 21);
        self.w
    }
}
#[doc = "Field `EFID` reader - The frame identifier"]
pub struct EFID_R(crate::FieldReader<u32, u32>);
impl EFID_R {
    #[inline(always)]
    pub(crate) fn new(bits: u32) -> Self {
        EFID_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EFID_R {
    type Target = crate::FieldReader<u32, u32>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EFID` writer - The frame identifier"]
pub struct EFID_W<'a> {
    w: &'a mut W,
}
impl<'a> EFID_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u32) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0003_ffff << 3)) | ((value as u32 & 0x0003_ffff) << 3);
        self.w
    }
}
#[doc = "Field `FF` reader - Frame format"]
pub struct FF_R(crate::FieldReader<bool, bool>);
impl FF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FF` writer - Frame format"]
pub struct FF_W<'a> {
    w: &'a mut W,
}
impl<'a> FF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `FT` reader - Frame type"]
pub struct FT_R(crate::FieldReader<bool, bool>);
impl FT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FT` writer - Frame type"]
pub struct FT_W<'a> {
    w: &'a mut W,
}
impl<'a> FT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `TEN` reader - Transmit enable"]
pub struct TEN_R(crate::FieldReader<bool, bool>);
impl TEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TEN` writer - Transmit enable"]
pub struct TEN_W<'a> {
    w: &'a mut W,
}
impl<'a> TEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bits 21:31 - The frame identifier"]
    #[inline(always)]
    pub fn sfid_efid(&self) -> SFID_EFID_R {
        SFID_EFID_R::new(((self.bits >> 21) & 0x07ff) as u16)
    }
    #[doc = "Bits 3:20 - The frame identifier"]
    #[inline(always)]
    pub fn efid(&self) -> EFID_R {
        EFID_R::new(((self.bits >> 3) & 0x0003_ffff) as u32)
    }
    #[doc = "Bit 2 - Frame format"]
    #[inline(always)]
    pub fn ff(&self) -> FF_R {
        FF_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Frame type"]
    #[inline(always)]
    pub fn ft(&self) -> FT_R {
        FT_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Transmit enable"]
    #[inline(always)]
    pub fn ten(&self) -> TEN_R {
        TEN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 21:31 - The frame identifier"]
    #[inline(always)]
    pub fn sfid_efid(&mut self) -> SFID_EFID_W {
        SFID_EFID_W { w: self }
    }
    #[doc = "Bits 3:20 - The frame identifier"]
    #[inline(always)]
    pub fn efid(&mut self) -> EFID_W {
        EFID_W { w: self }
    }
    #[doc = "Bit 2 - Frame format"]
    #[inline(always)]
    pub fn ff(&mut self) -> FF_W {
        FF_W { w: self }
    }
    #[doc = "Bit 1 - Frame type"]
    #[inline(always)]
    pub fn ft(&mut self) -> FT_W {
        FT_W { w: self }
    }
    #[doc = "Bit 0 - Transmit enable"]
    #[inline(always)]
    pub fn ten(&mut self) -> TEN_W {
        TEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transmit mailbox identifier register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tmi2](index.html) module"]
pub struct TMI2_SPEC;
impl crate::RegisterSpec for TMI2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [tmi2::R](R) reader structure"]
impl crate::Readable for TMI2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tmi2::W](W) writer structure"]
impl crate::Writable for TMI2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TMI2 to value 0"]
impl crate::Resettable for TMI2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
