#[doc = "Register `PCF0` reader"]
pub struct R(crate::R<PCF0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PCF0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PCF0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PCF0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PCF0` writer"]
pub struct W(crate::W<PCF0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PCF0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PCF0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PCF0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PTP_PPS_REMAP` reader - Ethernet PTP PPS remapping"]
pub struct PTP_PPS_REMAP_R(crate::FieldReader<bool, bool>);
impl PTP_PPS_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PTP_PPS_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PTP_PPS_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PTP_PPS_REMAP` writer - Ethernet PTP PPS remapping"]
pub struct PTP_PPS_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> PTP_PPS_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 30)) | ((value as u32 & 0x01) << 30);
        self.w
    }
}
#[doc = "Field `SPI2_REMAP` reader - SPI2/I2S2 remapping"]
pub struct SPI2_REMAP_R(crate::FieldReader<bool, bool>);
impl SPI2_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI2_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI2_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPI2_REMAP` writer - SPI2/I2S2 remapping"]
pub struct SPI2_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI2_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 28)) | ((value as u32 & 0x01) << 28);
        self.w
    }
}
#[doc = "Field `SWJ_CFG` reader - Serial wire JTAG configuration"]
pub struct SWJ_CFG_R(crate::FieldReader<u8, u8>);
impl SWJ_CFG_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SWJ_CFG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWJ_CFG_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWJ_CFG` writer - Serial wire JTAG configuration"]
pub struct SWJ_CFG_W<'a> {
    w: &'a mut W,
}
impl<'a> SWJ_CFG_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 24)) | ((value as u32 & 0x07) << 24);
        self.w
    }
}
#[doc = "Field `CAN1_REMAP` reader - CAN1 I/O remapping"]
pub struct CAN1_REMAP_R(crate::FieldReader<bool, bool>);
impl CAN1_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CAN1_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CAN1_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CAN1_REMAP` writer - CAN1 I/O remapping"]
pub struct CAN1_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> CAN1_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Field `PD01_REMAP` reader - Port D0/Port D1 mapping on OSC_IN/OSC_OUT"]
pub struct PD01_REMAP_R(crate::FieldReader<bool, bool>);
impl PD01_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PD01_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PD01_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PD01_REMAP` writer - Port D0/Port D1 mapping on OSC_IN/OSC_OUT"]
pub struct PD01_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> PD01_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `CAN0_REMAP` reader - CAN0 alternate interface remapping"]
pub struct CAN0_REMAP_R(crate::FieldReader<u8, u8>);
impl CAN0_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        CAN0_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CAN0_REMAP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CAN0_REMAP` writer - CAN0 alternate interface remapping"]
pub struct CAN0_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> CAN0_REMAP_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 13)) | ((value as u32 & 0x03) << 13);
        self.w
    }
}
#[doc = "Field `TIMER3_REMAP` reader - TIMER3 remapping"]
pub struct TIMER3_REMAP_R(crate::FieldReader<bool, bool>);
impl TIMER3_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TIMER3_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER3_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER3_REMAP` writer - TIMER3 remapping"]
pub struct TIMER3_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER3_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `TIMER2_REMAP` reader - TIMER2 remapping"]
pub struct TIMER2_REMAP_R(crate::FieldReader<u8, u8>);
impl TIMER2_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        TIMER2_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER2_REMAP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER2_REMAP` writer - TIMER2 remapping"]
pub struct TIMER2_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER2_REMAP_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 10)) | ((value as u32 & 0x03) << 10);
        self.w
    }
}
#[doc = "Field `TIMER0_REMAP` reader - TIMER0 remapping"]
pub struct TIMER0_REMAP_R(crate::FieldReader<u8, u8>);
impl TIMER0_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        TIMER0_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER0_REMAP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER0_REMAP` writer - TIMER0 remapping"]
pub struct TIMER0_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER0_REMAP_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u32 & 0x03) << 6);
        self.w
    }
}
#[doc = "Field `USART2_REMAP` reader - USART2 remapping"]
pub struct USART2_REMAP_R(crate::FieldReader<u8, u8>);
impl USART2_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        USART2_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USART2_REMAP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USART2_REMAP` writer - USART2 remapping"]
pub struct USART2_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> USART2_REMAP_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u32 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `USART1_REMAP` reader - USART1 remapping"]
pub struct USART1_REMAP_R(crate::FieldReader<bool, bool>);
impl USART1_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        USART1_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USART1_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USART1_REMAP` writer - USART1 remapping"]
pub struct USART1_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> USART1_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `USART0_REMAP` reader - USART0 remapping"]
pub struct USART0_REMAP_R(crate::FieldReader<bool, bool>);
impl USART0_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        USART0_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USART0_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USART0_REMAP` writer - USART0 remapping"]
pub struct USART0_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> USART0_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `I2C0_REMAP` reader - I2C0 remapping"]
pub struct I2C0_REMAP_R(crate::FieldReader<bool, bool>);
impl I2C0_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        I2C0_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2C0_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2C0_REMAP` writer - I2C0 remapping"]
pub struct I2C0_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> I2C0_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `SPI0_REMAP` reader - SPI0 remapping"]
pub struct SPI0_REMAP_R(crate::FieldReader<bool, bool>);
impl SPI0_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI0_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI0_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPI0_REMAP` writer - SPI0 remapping"]
pub struct SPI0_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI0_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 30 - Ethernet PTP PPS remapping"]
    #[inline(always)]
    pub fn ptp_pps_remap(&self) -> PTP_PPS_REMAP_R {
        PTP_PPS_REMAP_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 28 - SPI2/I2S2 remapping"]
    #[inline(always)]
    pub fn spi2_remap(&self) -> SPI2_REMAP_R {
        SPI2_REMAP_R::new(((self.bits >> 28) & 0x01) != 0)
    }
    #[doc = "Bits 24:26 - Serial wire JTAG configuration"]
    #[inline(always)]
    pub fn swj_cfg(&self) -> SWJ_CFG_R {
        SWJ_CFG_R::new(((self.bits >> 24) & 0x07) as u8)
    }
    #[doc = "Bit 22 - CAN1 I/O remapping"]
    #[inline(always)]
    pub fn can1_remap(&self) -> CAN1_REMAP_R {
        CAN1_REMAP_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Port D0/Port D1 mapping on OSC_IN/OSC_OUT"]
    #[inline(always)]
    pub fn pd01_remap(&self) -> PD01_REMAP_R {
        PD01_REMAP_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bits 13:14 - CAN0 alternate interface remapping"]
    #[inline(always)]
    pub fn can0_remap(&self) -> CAN0_REMAP_R {
        CAN0_REMAP_R::new(((self.bits >> 13) & 0x03) as u8)
    }
    #[doc = "Bit 12 - TIMER3 remapping"]
    #[inline(always)]
    pub fn timer3_remap(&self) -> TIMER3_REMAP_R {
        TIMER3_REMAP_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bits 10:11 - TIMER2 remapping"]
    #[inline(always)]
    pub fn timer2_remap(&self) -> TIMER2_REMAP_R {
        TIMER2_REMAP_R::new(((self.bits >> 10) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - TIMER0 remapping"]
    #[inline(always)]
    pub fn timer0_remap(&self) -> TIMER0_REMAP_R {
        TIMER0_REMAP_R::new(((self.bits >> 6) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - USART2 remapping"]
    #[inline(always)]
    pub fn usart2_remap(&self) -> USART2_REMAP_R {
        USART2_REMAP_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 3 - USART1 remapping"]
    #[inline(always)]
    pub fn usart1_remap(&self) -> USART1_REMAP_R {
        USART1_REMAP_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - USART0 remapping"]
    #[inline(always)]
    pub fn usart0_remap(&self) -> USART0_REMAP_R {
        USART0_REMAP_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - I2C0 remapping"]
    #[inline(always)]
    pub fn i2c0_remap(&self) -> I2C0_REMAP_R {
        I2C0_REMAP_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - SPI0 remapping"]
    #[inline(always)]
    pub fn spi0_remap(&self) -> SPI0_REMAP_R {
        SPI0_REMAP_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 30 - Ethernet PTP PPS remapping"]
    #[inline(always)]
    pub fn ptp_pps_remap(&mut self) -> PTP_PPS_REMAP_W {
        PTP_PPS_REMAP_W { w: self }
    }
    #[doc = "Bit 28 - SPI2/I2S2 remapping"]
    #[inline(always)]
    pub fn spi2_remap(&mut self) -> SPI2_REMAP_W {
        SPI2_REMAP_W { w: self }
    }
    #[doc = "Bits 24:26 - Serial wire JTAG configuration"]
    #[inline(always)]
    pub fn swj_cfg(&mut self) -> SWJ_CFG_W {
        SWJ_CFG_W { w: self }
    }
    #[doc = "Bit 22 - CAN1 I/O remapping"]
    #[inline(always)]
    pub fn can1_remap(&mut self) -> CAN1_REMAP_W {
        CAN1_REMAP_W { w: self }
    }
    #[doc = "Bit 15 - Port D0/Port D1 mapping on OSC_IN/OSC_OUT"]
    #[inline(always)]
    pub fn pd01_remap(&mut self) -> PD01_REMAP_W {
        PD01_REMAP_W { w: self }
    }
    #[doc = "Bits 13:14 - CAN0 alternate interface remapping"]
    #[inline(always)]
    pub fn can0_remap(&mut self) -> CAN0_REMAP_W {
        CAN0_REMAP_W { w: self }
    }
    #[doc = "Bit 12 - TIMER3 remapping"]
    #[inline(always)]
    pub fn timer3_remap(&mut self) -> TIMER3_REMAP_W {
        TIMER3_REMAP_W { w: self }
    }
    #[doc = "Bits 10:11 - TIMER2 remapping"]
    #[inline(always)]
    pub fn timer2_remap(&mut self) -> TIMER2_REMAP_W {
        TIMER2_REMAP_W { w: self }
    }
    #[doc = "Bits 6:7 - TIMER0 remapping"]
    #[inline(always)]
    pub fn timer0_remap(&mut self) -> TIMER0_REMAP_W {
        TIMER0_REMAP_W { w: self }
    }
    #[doc = "Bits 4:5 - USART2 remapping"]
    #[inline(always)]
    pub fn usart2_remap(&mut self) -> USART2_REMAP_W {
        USART2_REMAP_W { w: self }
    }
    #[doc = "Bit 3 - USART1 remapping"]
    #[inline(always)]
    pub fn usart1_remap(&mut self) -> USART1_REMAP_W {
        USART1_REMAP_W { w: self }
    }
    #[doc = "Bit 2 - USART0 remapping"]
    #[inline(always)]
    pub fn usart0_remap(&mut self) -> USART0_REMAP_W {
        USART0_REMAP_W { w: self }
    }
    #[doc = "Bit 1 - I2C0 remapping"]
    #[inline(always)]
    pub fn i2c0_remap(&mut self) -> I2C0_REMAP_W {
        I2C0_REMAP_W { w: self }
    }
    #[doc = "Bit 0 - SPI0 remapping"]
    #[inline(always)]
    pub fn spi0_remap(&mut self) -> SPI0_REMAP_W {
        SPI0_REMAP_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "AFIO port configuration register 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pcf0](index.html) module"]
pub struct PCF0_SPEC;
impl crate::RegisterSpec for PCF0_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [pcf0::R](R) reader structure"]
impl crate::Readable for PCF0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pcf0::W](W) writer structure"]
impl crate::Writable for PCF0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PCF0 to value 0"]
impl crate::Resettable for PCF0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
