# gd32f4
This crate provides an autogenerated API for access to GD32F4 peripherals.
The API is generated using [svd2rust] with patched svd files containing
extensive type-safe support. For more information please see the [main repo].

Refer to the [documentation] for full details.

[svd2rust]: https://github.com/rust-embedded/svd2rust
[main repo]: https://github.com/gd32-rs/gd32-rs
[documentation]: https://docs.rs/gd32f4/latest/gd32f4/

## Usage
Each device supported by this crate is behind a feature gate so that you only
compile the device(s) you want. To use, in your Cargo.toml:

```toml
[dependencies.gd32f4]
version = "0.1.0-alpha.1"
features = ["gd32f403"]
```

The `rt` feature is enabled by default and brings in support for `cortex-m-rt`.
To disable, specify `default-features = false` in `Cargo.toml`.

In your code:

```rust
use gd32f4::gd32f403;

let mut peripherals = gd32f403::Peripherals::take().unwrap();
let gpioa = &peripherals.GPIOA;
gpioa.odr.modify(|_, w| w.odr0().set_bit());
```

For full details on the autogenerated API, please see:
https://docs.rs/svd2rust/0.21.0/svd2rust/#peripheral-api

## Supported Devices

| Module | Devices | Links |
|:------:|:-------:|:-----:|
| gd32f403 | GD32F403 | [GD32F40x](https://gd32mcu.21ic.com/data/documents/kaifaban/GD32F403_User_Manual_EN_v2.1.pdf), [st.com](https://www.gigadevice.com/products/microcontrollers/gd32/arm-cortex-m4/high-performance-line/gd32f403-series/) |
