#[doc = "Register `LPMCS` reader"]
pub struct R(crate::R<LPMCS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LPMCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LPMCS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LPMCS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LPMCS` writer"]
pub struct W(crate::W<LPMCS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LPMCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LPMCS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LPMCS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `BLSTAT` reader - bLinkState value"]
pub struct BLSTAT_R(crate::FieldReader<u8, u8>);
impl BLSTAT_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        BLSTAT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BLSTAT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BLSTAT` writer - bLinkState value"]
pub struct BLSTAT_W<'a> {
    w: &'a mut W,
}
impl<'a> BLSTAT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `REMWK` reader - bRemoteWake value"]
pub struct REMWK_R(crate::FieldReader<bool, bool>);
impl REMWK_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        REMWK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REMWK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `REMWK` writer - bRemoteWake value"]
pub struct REMWK_W<'a> {
    w: &'a mut W,
}
impl<'a> REMWK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `LPMACK` reader - LPM token acknowledge enable"]
pub struct LPMACK_R(crate::FieldReader<bool, bool>);
impl LPMACK_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        LPMACK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LPMACK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LPMACK` writer - LPM token acknowledge enable"]
pub struct LPMACK_W<'a> {
    w: &'a mut W,
}
impl<'a> LPMACK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `LPMEN` reader - LPM support enable"]
pub struct LPMEN_R(crate::FieldReader<bool, bool>);
impl LPMEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        LPMEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LPMEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LPMEN` writer - LPM support enable"]
pub struct LPMEN_W<'a> {
    w: &'a mut W,
}
impl<'a> LPMEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bits 4:7 - bLinkState value"]
    #[inline(always)]
    pub fn blstat(&self) -> BLSTAT_R {
        BLSTAT_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bit 3 - bRemoteWake value"]
    #[inline(always)]
    pub fn remwk(&self) -> REMWK_R {
        REMWK_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 1 - LPM token acknowledge enable"]
    #[inline(always)]
    pub fn lpmack(&self) -> LPMACK_R {
        LPMACK_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - LPM support enable"]
    #[inline(always)]
    pub fn lpmen(&self) -> LPMEN_R {
        LPMEN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 4:7 - bLinkState value"]
    #[inline(always)]
    pub fn blstat(&mut self) -> BLSTAT_W {
        BLSTAT_W { w: self }
    }
    #[doc = "Bit 3 - bRemoteWake value"]
    #[inline(always)]
    pub fn remwk(&mut self) -> REMWK_W {
        REMWK_W { w: self }
    }
    #[doc = "Bit 1 - LPM token acknowledge enable"]
    #[inline(always)]
    pub fn lpmack(&mut self) -> LPMACK_W {
        LPMACK_W { w: self }
    }
    #[doc = "Bit 0 - LPM support enable"]
    #[inline(always)]
    pub fn lpmen(&mut self) -> LPMEN_W {
        LPMEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB LPM control and status register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [lpmcs](index.html) module"]
pub struct LPMCS_SPEC;
impl crate::RegisterSpec for LPMCS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [lpmcs::R](R) reader structure"]
impl crate::Readable for LPMCS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [lpmcs::W](W) writer structure"]
impl crate::Writable for LPMCS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LPMCS to value 0"]
impl crate::Resettable for LPMCS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
