#[doc = "Register `INTEN` reader"]
pub struct R(crate::R<INTEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<INTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<INTEN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<INTEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `INTEN` writer"]
pub struct W(crate::W<INTEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<INTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<INTEN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<INTEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CCRCERRIE` reader - Command response CRC fail interrupt enable"]
pub struct CCRCERRIE_R(crate::FieldReader<bool, bool>);
impl CCRCERRIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CCRCERRIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CCRCERRIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CCRCERRIE` writer - Command response CRC fail interrupt enable"]
pub struct CCRCERRIE_W<'a> {
    w: &'a mut W,
}
impl<'a> CCRCERRIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `DTCRCERRIE` reader - Data CRC fail interrupt enable"]
pub struct DTCRCERRIE_R(crate::FieldReader<bool, bool>);
impl DTCRCERRIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTCRCERRIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTCRCERRIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTCRCERRIE` writer - Data CRC fail interrupt enable"]
pub struct DTCRCERRIE_W<'a> {
    w: &'a mut W,
}
impl<'a> DTCRCERRIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `CMDTMOUTIE` reader - Command response timeout interrupt enable"]
pub struct CMDTMOUTIE_R(crate::FieldReader<bool, bool>);
impl CMDTMOUTIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CMDTMOUTIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMDTMOUTIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMDTMOUTIE` writer - Command response timeout interrupt enable"]
pub struct CMDTMOUTIE_W<'a> {
    w: &'a mut W,
}
impl<'a> CMDTMOUTIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `DTTMOUTIE` reader - Data timeout interrupt enable"]
pub struct DTTMOUTIE_R(crate::FieldReader<bool, bool>);
impl DTTMOUTIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTTMOUTIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTTMOUTIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTTMOUTIE` writer - Data timeout interrupt enable"]
pub struct DTTMOUTIE_W<'a> {
    w: &'a mut W,
}
impl<'a> DTTMOUTIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `TXUREIE` reader - Transmit FIFO underrun error interrupt enable"]
pub struct TXUREIE_R(crate::FieldReader<bool, bool>);
impl TXUREIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXUREIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXUREIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXUREIE` writer - Transmit FIFO underrun error interrupt enable"]
pub struct TXUREIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TXUREIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `RXOREIE` reader - Received FIFO overrun error interrupt enable"]
pub struct RXOREIE_R(crate::FieldReader<bool, bool>);
impl RXOREIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RXOREIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXOREIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXOREIE` writer - Received FIFO overrun error interrupt enable"]
pub struct RXOREIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RXOREIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `CMDRECVIE` reader - Command response received interrupt enable"]
pub struct CMDRECVIE_R(crate::FieldReader<bool, bool>);
impl CMDRECVIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CMDRECVIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMDRECVIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMDRECVIE` writer - Command response received interrupt enable"]
pub struct CMDRECVIE_W<'a> {
    w: &'a mut W,
}
impl<'a> CMDRECVIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `CMDSENDIE` reader - Command sent interrupt enable"]
pub struct CMDSENDIE_R(crate::FieldReader<bool, bool>);
impl CMDSENDIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CMDSENDIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMDSENDIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMDSENDIE` writer - Command sent interrupt enable"]
pub struct CMDSENDIE_W<'a> {
    w: &'a mut W,
}
impl<'a> CMDSENDIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `DTENDIE` reader - Data end interrupt enable"]
pub struct DTENDIE_R(crate::FieldReader<bool, bool>);
impl DTENDIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTENDIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTENDIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTENDIE` writer - Data end interrupt enable"]
pub struct DTENDIE_W<'a> {
    w: &'a mut W,
}
impl<'a> DTENDIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `STBITEIE` reader - Start bit error interrupt enable"]
pub struct STBITEIE_R(crate::FieldReader<bool, bool>);
impl STBITEIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        STBITEIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STBITEIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STBITEIE` writer - Start bit error interrupt enable"]
pub struct STBITEIE_W<'a> {
    w: &'a mut W,
}
impl<'a> STBITEIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `DTBLKENDIE` reader - Data block end interrupt enable"]
pub struct DTBLKENDIE_R(crate::FieldReader<bool, bool>);
impl DTBLKENDIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTBLKENDIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTBLKENDIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTBLKENDIE` writer - Data block end interrupt enable"]
pub struct DTBLKENDIE_W<'a> {
    w: &'a mut W,
}
impl<'a> DTBLKENDIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `CMDRUNIE` reader - Command transmission interrupt enable"]
pub struct CMDRUNIE_R(crate::FieldReader<bool, bool>);
impl CMDRUNIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CMDRUNIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMDRUNIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMDRUNIE` writer - Command transmission interrupt enable"]
pub struct CMDRUNIE_W<'a> {
    w: &'a mut W,
}
impl<'a> CMDRUNIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `TXRUNIE` reader - Data transmission interrupt enable"]
pub struct TXRUNIE_R(crate::FieldReader<bool, bool>);
impl TXRUNIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXRUNIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXRUNIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXRUNIE` writer - Data transmission interrupt enable"]
pub struct TXRUNIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TXRUNIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `RXRUNIE` reader - Data reception interrupt enable"]
pub struct RXRUNIE_R(crate::FieldReader<bool, bool>);
impl RXRUNIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RXRUNIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXRUNIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXRUNIE` writer - Data reception interrupt enable"]
pub struct RXRUNIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RXRUNIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `TFHIE` reader - Transmit FIFO half empty interrupt enable"]
pub struct TFHIE_R(crate::FieldReader<bool, bool>);
impl TFHIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TFHIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFHIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFHIE` writer - Transmit FIFO half empty interrupt enable"]
pub struct TFHIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TFHIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `RFHIE` reader - Receive FIFO half full interrupt enable"]
pub struct RFHIE_R(crate::FieldReader<bool, bool>);
impl RFHIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RFHIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFHIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFHIE` writer - Receive FIFO half full interrupt enable"]
pub struct RFHIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RFHIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `TFFIE` reader - Transmit FIFO full interrupt enable"]
pub struct TFFIE_R(crate::FieldReader<bool, bool>);
impl TFFIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TFFIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFFIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFFIE` writer - Transmit FIFO full interrupt enable"]
pub struct TFFIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TFFIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `RFFIE` reader - Receive FIFO full interrupt enable"]
pub struct RFFIE_R(crate::FieldReader<bool, bool>);
impl RFFIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RFFIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFFIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFFIE` writer - Receive FIFO full interrupt enable"]
pub struct RFFIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RFFIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `TFEIE` reader - Transmit FIFO empty interrupt enable"]
pub struct TFEIE_R(crate::FieldReader<bool, bool>);
impl TFEIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TFEIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFEIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFEIE` writer - Transmit FIFO empty interrupt enable"]
pub struct TFEIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TFEIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `RFEIE` reader - Receive FIFO empty interrupt enable"]
pub struct RFEIE_R(crate::FieldReader<bool, bool>);
impl RFEIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RFEIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFEIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFEIE` writer - Receive FIFO empty interrupt enable"]
pub struct RFEIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RFEIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Field `TXDTVALIE` reader - Data valid in transmit FIFO interrupt enable"]
pub struct TXDTVALIE_R(crate::FieldReader<bool, bool>);
impl TXDTVALIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXDTVALIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXDTVALIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXDTVALIE` writer - Data valid in transmit FIFO interrupt enable"]
pub struct TXDTVALIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TXDTVALIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Field `RXDTVALIE` reader - Data valid in receive FIFO interrupt enable"]
pub struct RXDTVALIE_R(crate::FieldReader<bool, bool>);
impl RXDTVALIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RXDTVALIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXDTVALIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXDTVALIE` writer - Data valid in receive FIFO interrupt enable"]
pub struct RXDTVALIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RXDTVALIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Field `SDIOINTIE` reader - SD I/O interrupt received interrupt enable"]
pub struct SDIOINTIE_R(crate::FieldReader<bool, bool>);
impl SDIOINTIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SDIOINTIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SDIOINTIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SDIOINTIE` writer - SD I/O interrupt received interrupt enable"]
pub struct SDIOINTIE_W<'a> {
    w: &'a mut W,
}
impl<'a> SDIOINTIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Field `ATAENDIE` reader - CE-ATA command completion signal received interrupt enable"]
pub struct ATAENDIE_R(crate::FieldReader<bool, bool>);
impl ATAENDIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ATAENDIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ATAENDIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ATAENDIE` writer - CE-ATA command completion signal received interrupt enable"]
pub struct ATAENDIE_W<'a> {
    w: &'a mut W,
}
impl<'a> ATAENDIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Command response CRC fail interrupt enable"]
    #[inline(always)]
    pub fn ccrcerrie(&self) -> CCRCERRIE_R {
        CCRCERRIE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Data CRC fail interrupt enable"]
    #[inline(always)]
    pub fn dtcrcerrie(&self) -> DTCRCERRIE_R {
        DTCRCERRIE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Command response timeout interrupt enable"]
    #[inline(always)]
    pub fn cmdtmoutie(&self) -> CMDTMOUTIE_R {
        CMDTMOUTIE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Data timeout interrupt enable"]
    #[inline(always)]
    pub fn dttmoutie(&self) -> DTTMOUTIE_R {
        DTTMOUTIE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Transmit FIFO underrun error interrupt enable"]
    #[inline(always)]
    pub fn txureie(&self) -> TXUREIE_R {
        TXUREIE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Received FIFO overrun error interrupt enable"]
    #[inline(always)]
    pub fn rxoreie(&self) -> RXOREIE_R {
        RXOREIE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Command response received interrupt enable"]
    #[inline(always)]
    pub fn cmdrecvie(&self) -> CMDRECVIE_R {
        CMDRECVIE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Command sent interrupt enable"]
    #[inline(always)]
    pub fn cmdsendie(&self) -> CMDSENDIE_R {
        CMDSENDIE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Data end interrupt enable"]
    #[inline(always)]
    pub fn dtendie(&self) -> DTENDIE_R {
        DTENDIE_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Start bit error interrupt enable"]
    #[inline(always)]
    pub fn stbiteie(&self) -> STBITEIE_R {
        STBITEIE_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Data block end interrupt enable"]
    #[inline(always)]
    pub fn dtblkendie(&self) -> DTBLKENDIE_R {
        DTBLKENDIE_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Command transmission interrupt enable"]
    #[inline(always)]
    pub fn cmdrunie(&self) -> CMDRUNIE_R {
        CMDRUNIE_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Data transmission interrupt enable"]
    #[inline(always)]
    pub fn txrunie(&self) -> TXRUNIE_R {
        TXRUNIE_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Data reception interrupt enable"]
    #[inline(always)]
    pub fn rxrunie(&self) -> RXRUNIE_R {
        RXRUNIE_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Transmit FIFO half empty interrupt enable"]
    #[inline(always)]
    pub fn tfhie(&self) -> TFHIE_R {
        TFHIE_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Receive FIFO half full interrupt enable"]
    #[inline(always)]
    pub fn rfhie(&self) -> RFHIE_R {
        RFHIE_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Transmit FIFO full interrupt enable"]
    #[inline(always)]
    pub fn tffie(&self) -> TFFIE_R {
        TFFIE_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Receive FIFO full interrupt enable"]
    #[inline(always)]
    pub fn rffie(&self) -> RFFIE_R {
        RFFIE_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Transmit FIFO empty interrupt enable"]
    #[inline(always)]
    pub fn tfeie(&self) -> TFEIE_R {
        TFEIE_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Receive FIFO empty interrupt enable"]
    #[inline(always)]
    pub fn rfeie(&self) -> RFEIE_R {
        RFEIE_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Data valid in transmit FIFO interrupt enable"]
    #[inline(always)]
    pub fn txdtvalie(&self) -> TXDTVALIE_R {
        TXDTVALIE_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 21 - Data valid in receive FIFO interrupt enable"]
    #[inline(always)]
    pub fn rxdtvalie(&self) -> RXDTVALIE_R {
        RXDTVALIE_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 22 - SD I/O interrupt received interrupt enable"]
    #[inline(always)]
    pub fn sdiointie(&self) -> SDIOINTIE_R {
        SDIOINTIE_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 23 - CE-ATA command completion signal received interrupt enable"]
    #[inline(always)]
    pub fn ataendie(&self) -> ATAENDIE_R {
        ATAENDIE_R::new(((self.bits >> 23) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Command response CRC fail interrupt enable"]
    #[inline(always)]
    pub fn ccrcerrie(&mut self) -> CCRCERRIE_W {
        CCRCERRIE_W { w: self }
    }
    #[doc = "Bit 1 - Data CRC fail interrupt enable"]
    #[inline(always)]
    pub fn dtcrcerrie(&mut self) -> DTCRCERRIE_W {
        DTCRCERRIE_W { w: self }
    }
    #[doc = "Bit 2 - Command response timeout interrupt enable"]
    #[inline(always)]
    pub fn cmdtmoutie(&mut self) -> CMDTMOUTIE_W {
        CMDTMOUTIE_W { w: self }
    }
    #[doc = "Bit 3 - Data timeout interrupt enable"]
    #[inline(always)]
    pub fn dttmoutie(&mut self) -> DTTMOUTIE_W {
        DTTMOUTIE_W { w: self }
    }
    #[doc = "Bit 4 - Transmit FIFO underrun error interrupt enable"]
    #[inline(always)]
    pub fn txureie(&mut self) -> TXUREIE_W {
        TXUREIE_W { w: self }
    }
    #[doc = "Bit 5 - Received FIFO overrun error interrupt enable"]
    #[inline(always)]
    pub fn rxoreie(&mut self) -> RXOREIE_W {
        RXOREIE_W { w: self }
    }
    #[doc = "Bit 6 - Command response received interrupt enable"]
    #[inline(always)]
    pub fn cmdrecvie(&mut self) -> CMDRECVIE_W {
        CMDRECVIE_W { w: self }
    }
    #[doc = "Bit 7 - Command sent interrupt enable"]
    #[inline(always)]
    pub fn cmdsendie(&mut self) -> CMDSENDIE_W {
        CMDSENDIE_W { w: self }
    }
    #[doc = "Bit 8 - Data end interrupt enable"]
    #[inline(always)]
    pub fn dtendie(&mut self) -> DTENDIE_W {
        DTENDIE_W { w: self }
    }
    #[doc = "Bit 9 - Start bit error interrupt enable"]
    #[inline(always)]
    pub fn stbiteie(&mut self) -> STBITEIE_W {
        STBITEIE_W { w: self }
    }
    #[doc = "Bit 10 - Data block end interrupt enable"]
    #[inline(always)]
    pub fn dtblkendie(&mut self) -> DTBLKENDIE_W {
        DTBLKENDIE_W { w: self }
    }
    #[doc = "Bit 11 - Command transmission interrupt enable"]
    #[inline(always)]
    pub fn cmdrunie(&mut self) -> CMDRUNIE_W {
        CMDRUNIE_W { w: self }
    }
    #[doc = "Bit 12 - Data transmission interrupt enable"]
    #[inline(always)]
    pub fn txrunie(&mut self) -> TXRUNIE_W {
        TXRUNIE_W { w: self }
    }
    #[doc = "Bit 13 - Data reception interrupt enable"]
    #[inline(always)]
    pub fn rxrunie(&mut self) -> RXRUNIE_W {
        RXRUNIE_W { w: self }
    }
    #[doc = "Bit 14 - Transmit FIFO half empty interrupt enable"]
    #[inline(always)]
    pub fn tfhie(&mut self) -> TFHIE_W {
        TFHIE_W { w: self }
    }
    #[doc = "Bit 15 - Receive FIFO half full interrupt enable"]
    #[inline(always)]
    pub fn rfhie(&mut self) -> RFHIE_W {
        RFHIE_W { w: self }
    }
    #[doc = "Bit 16 - Transmit FIFO full interrupt enable"]
    #[inline(always)]
    pub fn tffie(&mut self) -> TFFIE_W {
        TFFIE_W { w: self }
    }
    #[doc = "Bit 17 - Receive FIFO full interrupt enable"]
    #[inline(always)]
    pub fn rffie(&mut self) -> RFFIE_W {
        RFFIE_W { w: self }
    }
    #[doc = "Bit 18 - Transmit FIFO empty interrupt enable"]
    #[inline(always)]
    pub fn tfeie(&mut self) -> TFEIE_W {
        TFEIE_W { w: self }
    }
    #[doc = "Bit 19 - Receive FIFO empty interrupt enable"]
    #[inline(always)]
    pub fn rfeie(&mut self) -> RFEIE_W {
        RFEIE_W { w: self }
    }
    #[doc = "Bit 20 - Data valid in transmit FIFO interrupt enable"]
    #[inline(always)]
    pub fn txdtvalie(&mut self) -> TXDTVALIE_W {
        TXDTVALIE_W { w: self }
    }
    #[doc = "Bit 21 - Data valid in receive FIFO interrupt enable"]
    #[inline(always)]
    pub fn rxdtvalie(&mut self) -> RXDTVALIE_W {
        RXDTVALIE_W { w: self }
    }
    #[doc = "Bit 22 - SD I/O interrupt received interrupt enable"]
    #[inline(always)]
    pub fn sdiointie(&mut self) -> SDIOINTIE_W {
        SDIOINTIE_W { w: self }
    }
    #[doc = "Bit 23 - CE-ATA command completion signal received interrupt enable"]
    #[inline(always)]
    pub fn ataendie(&mut self) -> ATAENDIE_W {
        ATAENDIE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Interrupt enable register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [inten](index.html) module"]
pub struct INTEN_SPEC;
impl crate::RegisterSpec for INTEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [inten::R](R) reader structure"]
impl crate::Readable for INTEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [inten::W](W) writer structure"]
impl crate::Writable for INTEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets INTEN to value 0"]
impl crate::Resettable for INTEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
