#[doc = "Register `DATACTL` reader"]
pub struct R(crate::R<DATACTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DATACTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DATACTL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DATACTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DATACTL` writer"]
pub struct W(crate::W<DATACTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DATACTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DATACTL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DATACTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DATAEN` reader - Data transfer enabled bit"]
pub struct DATAEN_R(crate::FieldReader<bool, bool>);
impl DATAEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DATAEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DATAEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DATAEN` writer - Data transfer enabled bit"]
pub struct DATAEN_W<'a> {
    w: &'a mut W,
}
impl<'a> DATAEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `DATADIR` reader - Data transfer direction"]
pub struct DATADIR_R(crate::FieldReader<bool, bool>);
impl DATADIR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DATADIR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DATADIR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DATADIR` writer - Data transfer direction"]
pub struct DATADIR_W<'a> {
    w: &'a mut W,
}
impl<'a> DATADIR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `TRANSMOD` reader - Data transfer mode"]
pub struct TRANSMOD_R(crate::FieldReader<bool, bool>);
impl TRANSMOD_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TRANSMOD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TRANSMOD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TRANSMOD` writer - Data transfer mode"]
pub struct TRANSMOD_W<'a> {
    w: &'a mut W,
}
impl<'a> TRANSMOD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `DMAEN` reader - DMA enable bit"]
pub struct DMAEN_R(crate::FieldReader<bool, bool>);
impl DMAEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DMAEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DMAEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DMAEN` writer - DMA enable bit"]
pub struct DMAEN_W<'a> {
    w: &'a mut W,
}
impl<'a> DMAEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `BLKSZ` reader - Data block size"]
pub struct BLKSZ_R(crate::FieldReader<u8, u8>);
impl BLKSZ_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        BLKSZ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BLKSZ_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BLKSZ` writer - Data block size"]
pub struct BLKSZ_W<'a> {
    w: &'a mut W,
}
impl<'a> BLKSZ_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `RWEN` reader - Read wait mode enabled"]
pub struct RWEN_R(crate::FieldReader<bool, bool>);
impl RWEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RWEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RWEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RWEN` writer - Read wait mode enabled"]
pub struct RWEN_W<'a> {
    w: &'a mut W,
}
impl<'a> RWEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `RWSTOP` reader - Read wait stop"]
pub struct RWSTOP_R(crate::FieldReader<bool, bool>);
impl RWSTOP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RWSTOP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RWSTOP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RWSTOP` writer - Read wait stop"]
pub struct RWSTOP_W<'a> {
    w: &'a mut W,
}
impl<'a> RWSTOP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `RWTYPE` reader - Read wait type"]
pub struct RWTYPE_R(crate::FieldReader<bool, bool>);
impl RWTYPE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RWTYPE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RWTYPE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RWTYPE` writer - Read wait type"]
pub struct RWTYPE_W<'a> {
    w: &'a mut W,
}
impl<'a> RWTYPE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `IOEN` reader - SD I/O specific function enable"]
pub struct IOEN_R(crate::FieldReader<bool, bool>);
impl IOEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        IOEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IOEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IOEN` writer - SD I/O specific function enable"]
pub struct IOEN_W<'a> {
    w: &'a mut W,
}
impl<'a> IOEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Data transfer enabled bit"]
    #[inline(always)]
    pub fn dataen(&self) -> DATAEN_R {
        DATAEN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Data transfer direction"]
    #[inline(always)]
    pub fn datadir(&self) -> DATADIR_R {
        DATADIR_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Data transfer mode"]
    #[inline(always)]
    pub fn transmod(&self) -> TRANSMOD_R {
        TRANSMOD_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - DMA enable bit"]
    #[inline(always)]
    pub fn dmaen(&self) -> DMAEN_R {
        DMAEN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bits 4:7 - Data block size"]
    #[inline(always)]
    pub fn blksz(&self) -> BLKSZ_R {
        BLKSZ_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bit 8 - Read wait mode enabled"]
    #[inline(always)]
    pub fn rwen(&self) -> RWEN_R {
        RWEN_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Read wait stop"]
    #[inline(always)]
    pub fn rwstop(&self) -> RWSTOP_R {
        RWSTOP_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Read wait type"]
    #[inline(always)]
    pub fn rwtype(&self) -> RWTYPE_R {
        RWTYPE_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - SD I/O specific function enable"]
    #[inline(always)]
    pub fn ioen(&self) -> IOEN_R {
        IOEN_R::new(((self.bits >> 11) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Data transfer enabled bit"]
    #[inline(always)]
    pub fn dataen(&mut self) -> DATAEN_W {
        DATAEN_W { w: self }
    }
    #[doc = "Bit 1 - Data transfer direction"]
    #[inline(always)]
    pub fn datadir(&mut self) -> DATADIR_W {
        DATADIR_W { w: self }
    }
    #[doc = "Bit 2 - Data transfer mode"]
    #[inline(always)]
    pub fn transmod(&mut self) -> TRANSMOD_W {
        TRANSMOD_W { w: self }
    }
    #[doc = "Bit 3 - DMA enable bit"]
    #[inline(always)]
    pub fn dmaen(&mut self) -> DMAEN_W {
        DMAEN_W { w: self }
    }
    #[doc = "Bits 4:7 - Data block size"]
    #[inline(always)]
    pub fn blksz(&mut self) -> BLKSZ_W {
        BLKSZ_W { w: self }
    }
    #[doc = "Bit 8 - Read wait mode enabled"]
    #[inline(always)]
    pub fn rwen(&mut self) -> RWEN_W {
        RWEN_W { w: self }
    }
    #[doc = "Bit 9 - Read wait stop"]
    #[inline(always)]
    pub fn rwstop(&mut self) -> RWSTOP_W {
        RWSTOP_W { w: self }
    }
    #[doc = "Bit 10 - Read wait type"]
    #[inline(always)]
    pub fn rwtype(&mut self) -> RWTYPE_W {
        RWTYPE_W { w: self }
    }
    #[doc = "Bit 11 - SD I/O specific function enable"]
    #[inline(always)]
    pub fn ioen(&mut self) -> IOEN_W {
        IOEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Data control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [datactl](index.html) module"]
pub struct DATACTL_SPEC;
impl crate::RegisterSpec for DATACTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [datactl::R](R) reader structure"]
impl crate::Readable for DATACTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [datactl::W](W) writer structure"]
impl crate::Writable for DATACTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DATACTL to value 0"]
impl crate::Resettable for DATACTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
