#[doc = "Register `CLKCTL` reader"]
pub struct R(crate::R<CLKCTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CLKCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CLKCTL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CLKCTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CLKCTL` writer"]
pub struct W(crate::W<CLKCTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CLKCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CLKCTL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CLKCTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DIV_8` reader - MSB of Clock division"]
pub struct DIV_8_R(crate::FieldReader<bool, bool>);
impl DIV_8_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DIV_8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DIV_8_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DIV_8` writer - MSB of Clock division"]
pub struct DIV_8_W<'a> {
    w: &'a mut W,
}
impl<'a> DIV_8_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
#[doc = "Field `HWCLKEN` reader - Hardware Clock Control enable bit"]
pub struct HWCLKEN_R(crate::FieldReader<bool, bool>);
impl HWCLKEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HWCLKEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HWCLKEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HWCLKEN` writer - Hardware Clock Control enable bit"]
pub struct HWCLKEN_W<'a> {
    w: &'a mut W,
}
impl<'a> HWCLKEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `CLKEDGE` reader - SDIO_CLK clock edge selection bit"]
pub struct CLKEDGE_R(crate::FieldReader<bool, bool>);
impl CLKEDGE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CLKEDGE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKEDGE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKEDGE` writer - SDIO_CLK clock edge selection bit"]
pub struct CLKEDGE_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKEDGE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `BUSMODE` reader - SDIO card bus mode control bit"]
pub struct BUSMODE_R(crate::FieldReader<u8, u8>);
impl BUSMODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        BUSMODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BUSMODE_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BUSMODE` writer - SDIO card bus mode control bit"]
pub struct BUSMODE_W<'a> {
    w: &'a mut W,
}
impl<'a> BUSMODE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 11)) | ((value as u32 & 0x03) << 11);
        self.w
    }
}
#[doc = "Field `CLKBYP` reader - Clock bypass enable bit"]
pub struct CLKBYP_R(crate::FieldReader<bool, bool>);
impl CLKBYP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CLKBYP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKBYP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKBYP` writer - Clock bypass enable bit"]
pub struct CLKBYP_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKBYP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `CLKPWRSAV` reader - SDIO_CLK clock dynamic switch on/off for power saving"]
pub struct CLKPWRSAV_R(crate::FieldReader<bool, bool>);
impl CLKPWRSAV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CLKPWRSAV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKPWRSAV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKPWRSAV` writer - SDIO_CLK clock dynamic switch on/off for power saving"]
pub struct CLKPWRSAV_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKPWRSAV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `CLKEN` reader - SDIO_CLK clock output enable bit"]
pub struct CLKEN_R(crate::FieldReader<bool, bool>);
impl CLKEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CLKEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKEN` writer - SDIO_CLK clock output enable bit"]
pub struct CLKEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `DIV_0_7` reader - Clock division"]
pub struct DIV_0_7_R(crate::FieldReader<u8, u8>);
impl DIV_0_7_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        DIV_0_7_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DIV_0_7_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DIV_0_7` writer - Clock division"]
pub struct DIV_0_7_W<'a> {
    w: &'a mut W,
}
impl<'a> DIV_0_7_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bit 31 - MSB of Clock division"]
    #[inline(always)]
    pub fn div_8(&self) -> DIV_8_R {
        DIV_8_R::new(((self.bits >> 31) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Hardware Clock Control enable bit"]
    #[inline(always)]
    pub fn hwclken(&self) -> HWCLKEN_R {
        HWCLKEN_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 13 - SDIO_CLK clock edge selection bit"]
    #[inline(always)]
    pub fn clkedge(&self) -> CLKEDGE_R {
        CLKEDGE_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bits 11:12 - SDIO card bus mode control bit"]
    #[inline(always)]
    pub fn busmode(&self) -> BUSMODE_R {
        BUSMODE_R::new(((self.bits >> 11) & 0x03) as u8)
    }
    #[doc = "Bit 10 - Clock bypass enable bit"]
    #[inline(always)]
    pub fn clkbyp(&self) -> CLKBYP_R {
        CLKBYP_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - SDIO_CLK clock dynamic switch on/off for power saving"]
    #[inline(always)]
    pub fn clkpwrsav(&self) -> CLKPWRSAV_R {
        CLKPWRSAV_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - SDIO_CLK clock output enable bit"]
    #[inline(always)]
    pub fn clken(&self) -> CLKEN_R {
        CLKEN_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bits 0:7 - Clock division"]
    #[inline(always)]
    pub fn div_0_7(&self) -> DIV_0_7_R {
        DIV_0_7_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bit 31 - MSB of Clock division"]
    #[inline(always)]
    pub fn div_8(&mut self) -> DIV_8_W {
        DIV_8_W { w: self }
    }
    #[doc = "Bit 14 - Hardware Clock Control enable bit"]
    #[inline(always)]
    pub fn hwclken(&mut self) -> HWCLKEN_W {
        HWCLKEN_W { w: self }
    }
    #[doc = "Bit 13 - SDIO_CLK clock edge selection bit"]
    #[inline(always)]
    pub fn clkedge(&mut self) -> CLKEDGE_W {
        CLKEDGE_W { w: self }
    }
    #[doc = "Bits 11:12 - SDIO card bus mode control bit"]
    #[inline(always)]
    pub fn busmode(&mut self) -> BUSMODE_W {
        BUSMODE_W { w: self }
    }
    #[doc = "Bit 10 - Clock bypass enable bit"]
    #[inline(always)]
    pub fn clkbyp(&mut self) -> CLKBYP_W {
        CLKBYP_W { w: self }
    }
    #[doc = "Bit 9 - SDIO_CLK clock dynamic switch on/off for power saving"]
    #[inline(always)]
    pub fn clkpwrsav(&mut self) -> CLKPWRSAV_W {
        CLKPWRSAV_W { w: self }
    }
    #[doc = "Bit 8 - SDIO_CLK clock output enable bit"]
    #[inline(always)]
    pub fn clken(&mut self) -> CLKEN_W {
        CLKEN_W { w: self }
    }
    #[doc = "Bits 0:7 - Clock division"]
    #[inline(always)]
    pub fn div_0_7(&mut self) -> DIV_0_7_W {
        DIV_0_7_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clock control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [clkctl](index.html) module"]
pub struct CLKCTL_SPEC;
impl crate::RegisterSpec for CLKCTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [clkctl::R](R) reader structure"]
impl crate::Readable for CLKCTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [clkctl::W](W) writer structure"]
impl crate::Writable for CLKCTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CLKCTL to value 0"]
impl crate::Resettable for CLKCTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
