#[doc = "Register `RSTSCK` reader"]
pub struct R(crate::R<RSTSCK_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<RSTSCK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<RSTSCK_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<RSTSCK_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `RSTSCK` writer"]
pub struct W(crate::W<RSTSCK_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<RSTSCK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<RSTSCK_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<RSTSCK_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `IRC40KEN` reader - IRC40K enable"]
pub struct IRC40KEN_R(crate::FieldReader<bool, bool>);
impl IRC40KEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        IRC40KEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IRC40KEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRC40KEN` writer - IRC40K enable"]
pub struct IRC40KEN_W<'a> {
    w: &'a mut W,
}
impl<'a> IRC40KEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `IRC40KSTB` reader - IRC40K stabilization"]
pub struct IRC40KSTB_R(crate::FieldReader<bool, bool>);
impl IRC40KSTB_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        IRC40KSTB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IRC40KSTB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSTFC` reader - Reset flag clear"]
pub struct RSTFC_R(crate::FieldReader<bool, bool>);
impl RSTFC_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RSTFC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSTFC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSTFC` writer - Reset flag clear"]
pub struct RSTFC_W<'a> {
    w: &'a mut W,
}
impl<'a> RSTFC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Field `EPRSTF` reader - External PIN reset flag"]
pub struct EPRSTF_R(crate::FieldReader<bool, bool>);
impl EPRSTF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        EPRSTF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EPRSTF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PORRSTF` reader - Power reset flag"]
pub struct PORRSTF_R(crate::FieldReader<bool, bool>);
impl PORRSTF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PORRSTF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PORRSTF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SWRSTF` reader - Software reset flag"]
pub struct SWRSTF_R(crate::FieldReader<bool, bool>);
impl SWRSTF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SWRSTF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SWRSTF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FWDGTRSTF` reader - Free Watchdog timer reset flag"]
pub struct FWDGTRSTF_R(crate::FieldReader<bool, bool>);
impl FWDGTRSTF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FWDGTRSTF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FWDGTRSTF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WWDGTRSTF` reader - Window watchdog timer reset flag"]
pub struct WWDGTRSTF_R(crate::FieldReader<bool, bool>);
impl WWDGTRSTF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        WWDGTRSTF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WWDGTRSTF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LPRSTF` reader - Low-power reset flag"]
pub struct LPRSTF_R(crate::FieldReader<bool, bool>);
impl LPRSTF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        LPRSTF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LPRSTF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - IRC40K enable"]
    #[inline(always)]
    pub fn irc40ken(&self) -> IRC40KEN_R {
        IRC40KEN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - IRC40K stabilization"]
    #[inline(always)]
    pub fn irc40kstb(&self) -> IRC40KSTB_R {
        IRC40KSTB_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 24 - Reset flag clear"]
    #[inline(always)]
    pub fn rstfc(&self) -> RSTFC_R {
        RSTFC_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 26 - External PIN reset flag"]
    #[inline(always)]
    pub fn eprstf(&self) -> EPRSTF_R {
        EPRSTF_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 27 - Power reset flag"]
    #[inline(always)]
    pub fn porrstf(&self) -> PORRSTF_R {
        PORRSTF_R::new(((self.bits >> 27) & 0x01) != 0)
    }
    #[doc = "Bit 28 - Software reset flag"]
    #[inline(always)]
    pub fn swrstf(&self) -> SWRSTF_R {
        SWRSTF_R::new(((self.bits >> 28) & 0x01) != 0)
    }
    #[doc = "Bit 29 - Free Watchdog timer reset flag"]
    #[inline(always)]
    pub fn fwdgtrstf(&self) -> FWDGTRSTF_R {
        FWDGTRSTF_R::new(((self.bits >> 29) & 0x01) != 0)
    }
    #[doc = "Bit 30 - Window watchdog timer reset flag"]
    #[inline(always)]
    pub fn wwdgtrstf(&self) -> WWDGTRSTF_R {
        WWDGTRSTF_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 31 - Low-power reset flag"]
    #[inline(always)]
    pub fn lprstf(&self) -> LPRSTF_R {
        LPRSTF_R::new(((self.bits >> 31) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - IRC40K enable"]
    #[inline(always)]
    pub fn irc40ken(&mut self) -> IRC40KEN_W {
        IRC40KEN_W { w: self }
    }
    #[doc = "Bit 24 - Reset flag clear"]
    #[inline(always)]
    pub fn rstfc(&mut self) -> RSTFC_W {
        RSTFC_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Reset source /clock register (RCU_RSTSCK)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rstsck](index.html) module"]
pub struct RSTSCK_SPEC;
impl crate::RegisterSpec for RSTSCK_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [rstsck::R](R) reader structure"]
impl crate::Readable for RSTSCK_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [rstsck::W](W) writer structure"]
impl crate::Writable for RSTSCK_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets RSTSCK to value 0x0c00_0000"]
impl crate::Resettable for RSTSCK_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0c00_0000
    }
}
