#[doc = "Register `ADDAPB1RST` reader"]
pub struct R(crate::R<ADDAPB1RST_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ADDAPB1RST_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ADDAPB1RST_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ADDAPB1RST_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ADDAPB1RST` writer"]
pub struct W(crate::W<ADDAPB1RST_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ADDAPB1RST_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ADDAPB1RST_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ADDAPB1RST_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CTCRST` reader - CTC reset"]
pub struct CTCRST_R(crate::FieldReader<bool, bool>);
impl CTCRST_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CTCRST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CTCRST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CTCRST` writer - CTC reset"]
pub struct CTCRST_W<'a> {
    w: &'a mut W,
}
impl<'a> CTCRST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
impl R {
    #[doc = "Bit 27 - CTC reset"]
    #[inline(always)]
    pub fn ctcrst(&self) -> CTCRST_R {
        CTCRST_R::new(((self.bits >> 27) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 27 - CTC reset"]
    #[inline(always)]
    pub fn ctcrst(&mut self) -> CTCRST_W {
        CTCRST_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "APB1 additional reset register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [addapb1rst](index.html) module"]
pub struct ADDAPB1RST_SPEC;
impl crate::RegisterSpec for ADDAPB1RST_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [addapb1rst::R](R) reader structure"]
impl crate::Readable for ADDAPB1RST_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [addapb1rst::W](W) writer structure"]
impl crate::Writable for ADDAPB1RST_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ADDAPB1RST to value 0"]
impl crate::Resettable for ADDAPB1RST_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
