#[doc = "Register `CKCFG` reader"]
pub struct R(crate::R<CKCFG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CKCFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CKCFG_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CKCFG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CKCFG` writer"]
pub struct W(crate::W<CKCFG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CKCFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CKCFG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CKCFG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `FAST` reader - I2C speed selection in master mode"]
pub struct FAST_R(crate::FieldReader<bool, bool>);
impl FAST_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FAST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FAST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FAST` writer - I2C speed selection in master mode"]
pub struct FAST_W<'a> {
    w: &'a mut W,
}
impl<'a> FAST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `DTCY` reader - Duty cycle in fast mode"]
pub struct DTCY_R(crate::FieldReader<bool, bool>);
impl DTCY_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTCY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTCY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTCY` writer - Duty cycle in fast mode"]
pub struct DTCY_W<'a> {
    w: &'a mut W,
}
impl<'a> DTCY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `CLKC` reader - I2C Clock control in master mode"]
pub struct CLKC_R(crate::FieldReader<u16, u16>);
impl CLKC_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        CLKC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKC_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKC` writer - I2C Clock control in master mode"]
pub struct CLKC_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0fff) | (value as u32 & 0x0fff);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - I2C speed selection in master mode"]
    #[inline(always)]
    pub fn fast(&self) -> FAST_R {
        FAST_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Duty cycle in fast mode"]
    #[inline(always)]
    pub fn dtcy(&self) -> DTCY_R {
        DTCY_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bits 0:11 - I2C Clock control in master mode"]
    #[inline(always)]
    pub fn clkc(&self) -> CLKC_R {
        CLKC_R::new((self.bits & 0x0fff) as u16)
    }
}
impl W {
    #[doc = "Bit 15 - I2C speed selection in master mode"]
    #[inline(always)]
    pub fn fast(&mut self) -> FAST_W {
        FAST_W { w: self }
    }
    #[doc = "Bit 14 - Duty cycle in fast mode"]
    #[inline(always)]
    pub fn dtcy(&mut self) -> DTCY_W {
        DTCY_W { w: self }
    }
    #[doc = "Bits 0:11 - I2C Clock control in master mode"]
    #[inline(always)]
    pub fn clkc(&mut self) -> CLKC_W {
        CLKC_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clock configure register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ckcfg](index.html) module"]
pub struct CKCFG_SPEC;
impl crate::RegisterSpec for CKCFG_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [ckcfg::R](R) reader structure"]
impl crate::Readable for CKCFG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ckcfg::W](W) writer structure"]
impl crate::Writable for CKCFG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CKCFG to value 0"]
impl crate::Resettable for CKCFG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
