#[doc = "Register `RLD` reader"]
pub struct R(crate::R<RLD_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<RLD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<RLD_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<RLD_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `RLD` writer"]
pub struct W(crate::W<RLD_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<RLD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<RLD_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<RLD_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `RLD` reader - Free watchdog timer counter reload value"]
pub struct RLD_R(crate::FieldReader<u16, u16>);
impl RLD_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        RLD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RLD_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RLD` writer - Free watchdog timer counter reload value"]
pub struct RLD_W<'a> {
    w: &'a mut W,
}
impl<'a> RLD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0fff) | (value as u32 & 0x0fff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:11 - Free watchdog timer counter reload value"]
    #[inline(always)]
    pub fn rld(&self) -> RLD_R {
        RLD_R::new((self.bits & 0x0fff) as u16)
    }
}
impl W {
    #[doc = "Bits 0:11 - Free watchdog timer counter reload value"]
    #[inline(always)]
    pub fn rld(&mut self) -> RLD_W {
        RLD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Reload register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rld](index.html) module"]
pub struct RLD_SPEC;
impl crate::RegisterSpec for RLD_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [rld::R](R) reader structure"]
impl crate::Readable for RLD_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [rld::W](W) writer structure"]
impl crate::Writable for RLD_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets RLD to value 0x0fff"]
impl crate::Resettable for RLD_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0fff
    }
}
