#[doc = "Register `NPCTL1` reader"]
pub struct R(crate::R<NPCTL1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<NPCTL1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<NPCTL1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<NPCTL1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `NPCTL1` writer"]
pub struct W(crate::W<NPCTL1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<NPCTL1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<NPCTL1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<NPCTL1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ECCSZ` reader - ECC size"]
pub struct ECCSZ_R(crate::FieldReader<u8, u8>);
impl ECCSZ_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ECCSZ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ECCSZ_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ECCSZ` writer - ECC size"]
pub struct ECCSZ_W<'a> {
    w: &'a mut W,
}
impl<'a> ECCSZ_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 17)) | ((value as u32 & 0x07) << 17);
        self.w
    }
}
#[doc = "Field `ATR` reader - ALE to RE delay"]
pub struct ATR_R(crate::FieldReader<u8, u8>);
impl ATR_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ATR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ATR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ATR` writer - ALE to RE delay"]
pub struct ATR_W<'a> {
    w: &'a mut W,
}
impl<'a> ATR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 13)) | ((value as u32 & 0x0f) << 13);
        self.w
    }
}
#[doc = "Field `CTR` reader - CLE to RE delay"]
pub struct CTR_R(crate::FieldReader<u8, u8>);
impl CTR_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        CTR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CTR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CTR` writer - CLE to RE delay"]
pub struct CTR_W<'a> {
    w: &'a mut W,
}
impl<'a> CTR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 9)) | ((value as u32 & 0x0f) << 9);
        self.w
    }
}
#[doc = "Field `ECCEN` reader - ECC enable"]
pub struct ECCEN_R(crate::FieldReader<bool, bool>);
impl ECCEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ECCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ECCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ECCEN` writer - ECC enable"]
pub struct ECCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> ECCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `NDW` reader - NAND bank memory data bus width"]
pub struct NDW_R(crate::FieldReader<u8, u8>);
impl NDW_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        NDW_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NDW_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NDW` writer - NAND bank memory data bus width"]
pub struct NDW_W<'a> {
    w: &'a mut W,
}
impl<'a> NDW_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u32 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `NDTP` reader - NAND bank memory type"]
pub struct NDTP_R(crate::FieldReader<bool, bool>);
impl NDTP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NDTP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NDTP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NDTP` writer - NAND bank memory type"]
pub struct NDTP_W<'a> {
    w: &'a mut W,
}
impl<'a> NDTP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `NDBKEN` reader - NAND bank enable"]
pub struct NDBKEN_R(crate::FieldReader<bool, bool>);
impl NDBKEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NDBKEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NDBKEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NDBKEN` writer - NAND bank enable"]
pub struct NDBKEN_W<'a> {
    w: &'a mut W,
}
impl<'a> NDBKEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `NDWTEN` reader - Wait feature enable"]
pub struct NDWTEN_R(crate::FieldReader<bool, bool>);
impl NDWTEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NDWTEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NDWTEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NDWTEN` writer - Wait feature enable"]
pub struct NDWTEN_W<'a> {
    w: &'a mut W,
}
impl<'a> NDWTEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bits 17:19 - ECC size"]
    #[inline(always)]
    pub fn eccsz(&self) -> ECCSZ_R {
        ECCSZ_R::new(((self.bits >> 17) & 0x07) as u8)
    }
    #[doc = "Bits 13:16 - ALE to RE delay"]
    #[inline(always)]
    pub fn atr(&self) -> ATR_R {
        ATR_R::new(((self.bits >> 13) & 0x0f) as u8)
    }
    #[doc = "Bits 9:12 - CLE to RE delay"]
    #[inline(always)]
    pub fn ctr(&self) -> CTR_R {
        CTR_R::new(((self.bits >> 9) & 0x0f) as u8)
    }
    #[doc = "Bit 6 - ECC enable"]
    #[inline(always)]
    pub fn eccen(&self) -> ECCEN_R {
        ECCEN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - NAND bank memory data bus width"]
    #[inline(always)]
    pub fn ndw(&self) -> NDW_R {
        NDW_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 3 - NAND bank memory type"]
    #[inline(always)]
    pub fn ndtp(&self) -> NDTP_R {
        NDTP_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - NAND bank enable"]
    #[inline(always)]
    pub fn ndbken(&self) -> NDBKEN_R {
        NDBKEN_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Wait feature enable"]
    #[inline(always)]
    pub fn ndwten(&self) -> NDWTEN_R {
        NDWTEN_R::new(((self.bits >> 1) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 17:19 - ECC size"]
    #[inline(always)]
    pub fn eccsz(&mut self) -> ECCSZ_W {
        ECCSZ_W { w: self }
    }
    #[doc = "Bits 13:16 - ALE to RE delay"]
    #[inline(always)]
    pub fn atr(&mut self) -> ATR_W {
        ATR_W { w: self }
    }
    #[doc = "Bits 9:12 - CLE to RE delay"]
    #[inline(always)]
    pub fn ctr(&mut self) -> CTR_W {
        CTR_W { w: self }
    }
    #[doc = "Bit 6 - ECC enable"]
    #[inline(always)]
    pub fn eccen(&mut self) -> ECCEN_W {
        ECCEN_W { w: self }
    }
    #[doc = "Bits 4:5 - NAND bank memory data bus width"]
    #[inline(always)]
    pub fn ndw(&mut self) -> NDW_W {
        NDW_W { w: self }
    }
    #[doc = "Bit 3 - NAND bank memory type"]
    #[inline(always)]
    pub fn ndtp(&mut self) -> NDTP_W {
        NDTP_W { w: self }
    }
    #[doc = "Bit 2 - NAND bank enable"]
    #[inline(always)]
    pub fn ndbken(&mut self) -> NDBKEN_W {
        NDBKEN_W { w: self }
    }
    #[doc = "Bit 1 - Wait feature enable"]
    #[inline(always)]
    pub fn ndwten(&mut self) -> NDWTEN_W {
        NDWTEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "NAND flash/PC card control register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [npctl1](index.html) module"]
pub struct NPCTL1_SPEC;
impl crate::RegisterSpec for NPCTL1_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [npctl1::R](R) reader structure"]
impl crate::Readable for NPCTL1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [npctl1::W](W) writer structure"]
impl crate::Writable for NPCTL1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets NPCTL1 to value 0x18"]
impl crate::Resettable for NPCTL1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x18
    }
}
