#[doc = "Register `NPATCFG3` reader"]
pub struct R(crate::R<NPATCFG3_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<NPATCFG3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<NPATCFG3_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<NPATCFG3_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `NPATCFG3` writer"]
pub struct W(crate::W<NPATCFG3_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<NPATCFG3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<NPATCFG3_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<NPATCFG3_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ATTHIZ` reader - Attribute memory data bus HiZ time"]
pub struct ATTHIZ_R(crate::FieldReader<u8, u8>);
impl ATTHIZ_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ATTHIZ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ATTHIZ_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ATTHIZ` writer - Attribute memory data bus HiZ time"]
pub struct ATTHIZ_W<'a> {
    w: &'a mut W,
}
impl<'a> ATTHIZ_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 24)) | ((value as u32 & 0xff) << 24);
        self.w
    }
}
#[doc = "Field `ATTHLD` reader - Attribute memory hold time"]
pub struct ATTHLD_R(crate::FieldReader<u8, u8>);
impl ATTHLD_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ATTHLD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ATTHLD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ATTHLD` writer - Attribute memory hold time"]
pub struct ATTHLD_W<'a> {
    w: &'a mut W,
}
impl<'a> ATTHLD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 16)) | ((value as u32 & 0xff) << 16);
        self.w
    }
}
#[doc = "Field `ATTWAIT` reader - Attribute memory wait time"]
pub struct ATTWAIT_R(crate::FieldReader<u8, u8>);
impl ATTWAIT_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ATTWAIT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ATTWAIT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ATTWAIT` writer - Attribute memory wait time"]
pub struct ATTWAIT_W<'a> {
    w: &'a mut W,
}
impl<'a> ATTWAIT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 8)) | ((value as u32 & 0xff) << 8);
        self.w
    }
}
#[doc = "Field `ATTSET` reader - Attribute memory setup time"]
pub struct ATTSET_R(crate::FieldReader<u8, u8>);
impl ATTSET_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        ATTSET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ATTSET_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ATTSET` writer - Attribute memory setup time"]
pub struct ATTSET_W<'a> {
    w: &'a mut W,
}
impl<'a> ATTSET_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 24:31 - Attribute memory data bus HiZ time"]
    #[inline(always)]
    pub fn atthiz(&self) -> ATTHIZ_R {
        ATTHIZ_R::new(((self.bits >> 24) & 0xff) as u8)
    }
    #[doc = "Bits 16:23 - Attribute memory hold time"]
    #[inline(always)]
    pub fn atthld(&self) -> ATTHLD_R {
        ATTHLD_R::new(((self.bits >> 16) & 0xff) as u8)
    }
    #[doc = "Bits 8:15 - Attribute memory wait time"]
    #[inline(always)]
    pub fn attwait(&self) -> ATTWAIT_R {
        ATTWAIT_R::new(((self.bits >> 8) & 0xff) as u8)
    }
    #[doc = "Bits 0:7 - Attribute memory setup time"]
    #[inline(always)]
    pub fn attset(&self) -> ATTSET_R {
        ATTSET_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 24:31 - Attribute memory data bus HiZ time"]
    #[inline(always)]
    pub fn atthiz(&mut self) -> ATTHIZ_W {
        ATTHIZ_W { w: self }
    }
    #[doc = "Bits 16:23 - Attribute memory hold time"]
    #[inline(always)]
    pub fn atthld(&mut self) -> ATTHLD_W {
        ATTHLD_W { w: self }
    }
    #[doc = "Bits 8:15 - Attribute memory wait time"]
    #[inline(always)]
    pub fn attwait(&mut self) -> ATTWAIT_W {
        ATTWAIT_W { w: self }
    }
    #[doc = "Bits 0:7 - Attribute memory setup time"]
    #[inline(always)]
    pub fn attset(&mut self) -> ATTSET_W {
        ATTSET_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "NAND flash/PC card attribute space timing configuration register 3\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [npatcfg3](index.html) module"]
pub struct NPATCFG3_SPEC;
impl crate::RegisterSpec for NPATCFG3_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [npatcfg3::R](R) reader structure"]
impl crate::Readable for NPATCFG3_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [npatcfg3::W](W) writer structure"]
impl crate::Writable for NPATCFG3_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets NPATCFG3 to value 0xfcfc_fcfc"]
impl crate::Resettable for NPATCFG3_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0xfcfc_fcfc
    }
}
