#[doc = "Register `TSTAT` reader"]
pub struct R(crate::R<TSTAT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TSTAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TSTAT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TSTAT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TSTAT` writer"]
pub struct W(crate::W<TSTAT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TSTAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TSTAT_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TSTAT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TMLS2` reader - Transmit mailbox 2 last sending in transmit FIFO"]
pub struct TMLS2_R(crate::FieldReader<bool, bool>);
impl TMLS2_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TMLS2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TMLS2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TMLS1` reader - Transmit mailbox 1 last sending in transmit FIFO"]
pub struct TMLS1_R(crate::FieldReader<bool, bool>);
impl TMLS1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TMLS1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TMLS1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TMLS0` reader - Transmit mailbox 0 last sending in transmit FIFO"]
pub struct TMLS0_R(crate::FieldReader<bool, bool>);
impl TMLS0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TMLS0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TMLS0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TME2` reader - Transmit mailbox 2 empty"]
pub struct TME2_R(crate::FieldReader<bool, bool>);
impl TME2_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TME2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TME2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TME1` reader - Transmit mailbox 1 empty"]
pub struct TME1_R(crate::FieldReader<bool, bool>);
impl TME1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TME1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TME1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TME0` reader - Transmit mailbox 0 empty"]
pub struct TME0_R(crate::FieldReader<bool, bool>);
impl TME0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TME0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TME0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NUM` reader - number of the transmit FIFO mailbox in which the frame will be transmitted if at least one mailbox is empty"]
pub struct NUM_R(crate::FieldReader<u8, u8>);
impl NUM_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        NUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NUM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MST2` reader - Mailbox 2 stop transmitting"]
pub struct MST2_R(crate::FieldReader<bool, bool>);
impl MST2_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MST2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MST2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MST2` writer - Mailbox 2 stop transmitting"]
pub struct MST2_W<'a> {
    w: &'a mut W,
}
impl<'a> MST2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Field `MTE2` reader - Mailbox 2 transmit error"]
pub struct MTE2_R(crate::FieldReader<bool, bool>);
impl MTE2_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MTE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MTE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MTE2` writer - Mailbox 2 transmit error"]
pub struct MTE2_W<'a> {
    w: &'a mut W,
}
impl<'a> MTE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Field `MAL2` reader - Mailbox 2 arbitration lost"]
pub struct MAL2_R(crate::FieldReader<bool, bool>);
impl MAL2_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MAL2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MAL2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MAL2` writer - Mailbox 2 arbitration lost"]
pub struct MAL2_W<'a> {
    w: &'a mut W,
}
impl<'a> MAL2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `MTFNERR2` reader - Mailbox 2 transmit finished and no error"]
pub struct MTFNERR2_R(crate::FieldReader<bool, bool>);
impl MTFNERR2_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MTFNERR2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MTFNERR2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MTFNERR2` writer - Mailbox 2 transmit finished and no error"]
pub struct MTFNERR2_W<'a> {
    w: &'a mut W,
}
impl<'a> MTFNERR2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `MTF2` reader - Mailbox 2 transmit finished"]
pub struct MTF2_R(crate::FieldReader<bool, bool>);
impl MTF2_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MTF2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MTF2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MTF2` writer - Mailbox 2 transmit finished"]
pub struct MTF2_W<'a> {
    w: &'a mut W,
}
impl<'a> MTF2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `MST1` reader - Mailbox 1 stop transmitting"]
pub struct MST1_R(crate::FieldReader<bool, bool>);
impl MST1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MST1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MST1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MST1` writer - Mailbox 1 stop transmitting"]
pub struct MST1_W<'a> {
    w: &'a mut W,
}
impl<'a> MST1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `MTE1` reader - Mailbox 1 transmit error"]
pub struct MTE1_R(crate::FieldReader<bool, bool>);
impl MTE1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MTE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MTE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MTE1` writer - Mailbox 1 transmit error"]
pub struct MTE1_W<'a> {
    w: &'a mut W,
}
impl<'a> MTE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `MAL1` reader - Mailbox 1 arbitration lost"]
pub struct MAL1_R(crate::FieldReader<bool, bool>);
impl MAL1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MAL1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MAL1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MAL1` writer - Mailbox 1 arbitration lost"]
pub struct MAL1_W<'a> {
    w: &'a mut W,
}
impl<'a> MAL1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `MTFNERR1` reader - Mailbox 1 transmit finished and no error"]
pub struct MTFNERR1_R(crate::FieldReader<bool, bool>);
impl MTFNERR1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MTFNERR1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MTFNERR1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MTFNERR1` writer - Mailbox 1 transmit finished and no error"]
pub struct MTFNERR1_W<'a> {
    w: &'a mut W,
}
impl<'a> MTFNERR1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `MTF1` reader - Mailbox 1 transmit finished"]
pub struct MTF1_R(crate::FieldReader<bool, bool>);
impl MTF1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MTF1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MTF1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MTF1` writer - Mailbox 1 transmit finished"]
pub struct MTF1_W<'a> {
    w: &'a mut W,
}
impl<'a> MTF1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `MST0` reader - Mailbox 0 stop transmitting"]
pub struct MST0_R(crate::FieldReader<bool, bool>);
impl MST0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MST0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MST0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MST0` writer - Mailbox 0 stop transmitting"]
pub struct MST0_W<'a> {
    w: &'a mut W,
}
impl<'a> MST0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `MTE0` reader - Mailbox 0 transmit error"]
pub struct MTE0_R(crate::FieldReader<bool, bool>);
impl MTE0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MTE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MTE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MTE0` writer - Mailbox 0 transmit error"]
pub struct MTE0_W<'a> {
    w: &'a mut W,
}
impl<'a> MTE0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `MAL0` reader - Mailbox 0 arbitration lost"]
pub struct MAL0_R(crate::FieldReader<bool, bool>);
impl MAL0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MAL0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MAL0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MAL0` writer - Mailbox 0 arbitration lost"]
pub struct MAL0_W<'a> {
    w: &'a mut W,
}
impl<'a> MAL0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `MTFNERR0` reader - Mailbox 0 transmit finished and no error"]
pub struct MTFNERR0_R(crate::FieldReader<bool, bool>);
impl MTFNERR0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MTFNERR0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MTFNERR0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MTFNERR0` writer - Mailbox 0 transmit finished and no error"]
pub struct MTFNERR0_W<'a> {
    w: &'a mut W,
}
impl<'a> MTFNERR0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `MTF0` reader - Mailbox 0 transmit finished"]
pub struct MTF0_R(crate::FieldReader<bool, bool>);
impl MTF0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MTF0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MTF0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MTF0` writer - Mailbox 0 transmit finished"]
pub struct MTF0_W<'a> {
    w: &'a mut W,
}
impl<'a> MTF0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 31 - Transmit mailbox 2 last sending in transmit FIFO"]
    #[inline(always)]
    pub fn tmls2(&self) -> TMLS2_R {
        TMLS2_R::new(((self.bits >> 31) & 0x01) != 0)
    }
    #[doc = "Bit 30 - Transmit mailbox 1 last sending in transmit FIFO"]
    #[inline(always)]
    pub fn tmls1(&self) -> TMLS1_R {
        TMLS1_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 29 - Transmit mailbox 0 last sending in transmit FIFO"]
    #[inline(always)]
    pub fn tmls0(&self) -> TMLS0_R {
        TMLS0_R::new(((self.bits >> 29) & 0x01) != 0)
    }
    #[doc = "Bit 28 - Transmit mailbox 2 empty"]
    #[inline(always)]
    pub fn tme2(&self) -> TME2_R {
        TME2_R::new(((self.bits >> 28) & 0x01) != 0)
    }
    #[doc = "Bit 27 - Transmit mailbox 1 empty"]
    #[inline(always)]
    pub fn tme1(&self) -> TME1_R {
        TME1_R::new(((self.bits >> 27) & 0x01) != 0)
    }
    #[doc = "Bit 26 - Transmit mailbox 0 empty"]
    #[inline(always)]
    pub fn tme0(&self) -> TME0_R {
        TME0_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bits 24:25 - number of the transmit FIFO mailbox in which the frame will be transmitted if at least one mailbox is empty"]
    #[inline(always)]
    pub fn num(&self) -> NUM_R {
        NUM_R::new(((self.bits >> 24) & 0x03) as u8)
    }
    #[doc = "Bit 23 - Mailbox 2 stop transmitting"]
    #[inline(always)]
    pub fn mst2(&self) -> MST2_R {
        MST2_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Mailbox 2 transmit error"]
    #[inline(always)]
    pub fn mte2(&self) -> MTE2_R {
        MTE2_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Mailbox 2 arbitration lost"]
    #[inline(always)]
    pub fn mal2(&self) -> MAL2_R {
        MAL2_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Mailbox 2 transmit finished and no error"]
    #[inline(always)]
    pub fn mtfnerr2(&self) -> MTFNERR2_R {
        MTFNERR2_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Mailbox 2 transmit finished"]
    #[inline(always)]
    pub fn mtf2(&self) -> MTF2_R {
        MTF2_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Mailbox 1 stop transmitting"]
    #[inline(always)]
    pub fn mst1(&self) -> MST1_R {
        MST1_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Mailbox 1 transmit error"]
    #[inline(always)]
    pub fn mte1(&self) -> MTE1_R {
        MTE1_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Mailbox 1 arbitration lost"]
    #[inline(always)]
    pub fn mal1(&self) -> MAL1_R {
        MAL1_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Mailbox 1 transmit finished and no error"]
    #[inline(always)]
    pub fn mtfnerr1(&self) -> MTFNERR1_R {
        MTFNERR1_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Mailbox 1 transmit finished"]
    #[inline(always)]
    pub fn mtf1(&self) -> MTF1_R {
        MTF1_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Mailbox 0 stop transmitting"]
    #[inline(always)]
    pub fn mst0(&self) -> MST0_R {
        MST0_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Mailbox 0 transmit error"]
    #[inline(always)]
    pub fn mte0(&self) -> MTE0_R {
        MTE0_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Mailbox 0 arbitration lost"]
    #[inline(always)]
    pub fn mal0(&self) -> MAL0_R {
        MAL0_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Mailbox 0 transmit finished and no error"]
    #[inline(always)]
    pub fn mtfnerr0(&self) -> MTFNERR0_R {
        MTFNERR0_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Mailbox 0 transmit finished"]
    #[inline(always)]
    pub fn mtf0(&self) -> MTF0_R {
        MTF0_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 23 - Mailbox 2 stop transmitting"]
    #[inline(always)]
    pub fn mst2(&mut self) -> MST2_W {
        MST2_W { w: self }
    }
    #[doc = "Bit 19 - Mailbox 2 transmit error"]
    #[inline(always)]
    pub fn mte2(&mut self) -> MTE2_W {
        MTE2_W { w: self }
    }
    #[doc = "Bit 18 - Mailbox 2 arbitration lost"]
    #[inline(always)]
    pub fn mal2(&mut self) -> MAL2_W {
        MAL2_W { w: self }
    }
    #[doc = "Bit 17 - Mailbox 2 transmit finished and no error"]
    #[inline(always)]
    pub fn mtfnerr2(&mut self) -> MTFNERR2_W {
        MTFNERR2_W { w: self }
    }
    #[doc = "Bit 16 - Mailbox 2 transmit finished"]
    #[inline(always)]
    pub fn mtf2(&mut self) -> MTF2_W {
        MTF2_W { w: self }
    }
    #[doc = "Bit 15 - Mailbox 1 stop transmitting"]
    #[inline(always)]
    pub fn mst1(&mut self) -> MST1_W {
        MST1_W { w: self }
    }
    #[doc = "Bit 11 - Mailbox 1 transmit error"]
    #[inline(always)]
    pub fn mte1(&mut self) -> MTE1_W {
        MTE1_W { w: self }
    }
    #[doc = "Bit 10 - Mailbox 1 arbitration lost"]
    #[inline(always)]
    pub fn mal1(&mut self) -> MAL1_W {
        MAL1_W { w: self }
    }
    #[doc = "Bit 9 - Mailbox 1 transmit finished and no error"]
    #[inline(always)]
    pub fn mtfnerr1(&mut self) -> MTFNERR1_W {
        MTFNERR1_W { w: self }
    }
    #[doc = "Bit 8 - Mailbox 1 transmit finished"]
    #[inline(always)]
    pub fn mtf1(&mut self) -> MTF1_W {
        MTF1_W { w: self }
    }
    #[doc = "Bit 7 - Mailbox 0 stop transmitting"]
    #[inline(always)]
    pub fn mst0(&mut self) -> MST0_W {
        MST0_W { w: self }
    }
    #[doc = "Bit 3 - Mailbox 0 transmit error"]
    #[inline(always)]
    pub fn mte0(&mut self) -> MTE0_W {
        MTE0_W { w: self }
    }
    #[doc = "Bit 2 - Mailbox 0 arbitration lost"]
    #[inline(always)]
    pub fn mal0(&mut self) -> MAL0_W {
        MAL0_W { w: self }
    }
    #[doc = "Bit 1 - Mailbox 0 transmit finished and no error"]
    #[inline(always)]
    pub fn mtfnerr0(&mut self) -> MTFNERR0_W {
        MTFNERR0_W { w: self }
    }
    #[doc = "Bit 0 - Mailbox 0 transmit finished"]
    #[inline(always)]
    pub fn mtf0(&mut self) -> MTF0_W {
        MTF0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transmit status register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tstat](index.html) module"]
pub struct TSTAT_SPEC;
impl crate::RegisterSpec for TSTAT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [tstat::R](R) reader structure"]
impl crate::Readable for TSTAT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tstat::W](W) writer structure"]
impl crate::Writable for TSTAT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TSTAT to value 0x1c00_0000"]
impl crate::Resettable for TSTAT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x1c00_0000
    }
}
