#[doc = "Register `RFIFOMI0` reader"]
pub struct R(crate::R<RFIFOMI0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<RFIFOMI0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<RFIFOMI0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<RFIFOMI0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `SFID_EFID` reader - The frame identifier"]
pub struct SFID_EFID_R(crate::FieldReader<u16, u16>);
impl SFID_EFID_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        SFID_EFID_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SFID_EFID_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EFID` reader - The frame identifier"]
pub struct EFID_R(crate::FieldReader<u32, u32>);
impl EFID_R {
    #[inline(always)]
    pub(crate) fn new(bits: u32) -> Self {
        EFID_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EFID_R {
    type Target = crate::FieldReader<u32, u32>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FF` reader - Frame format"]
pub struct FF_R(crate::FieldReader<bool, bool>);
impl FF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FT` reader - Frame type"]
pub struct FT_R(crate::FieldReader<bool, bool>);
impl FT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bits 21:31 - The frame identifier"]
    #[inline(always)]
    pub fn sfid_efid(&self) -> SFID_EFID_R {
        SFID_EFID_R::new(((self.bits >> 21) & 0x07ff) as u16)
    }
    #[doc = "Bits 3:20 - The frame identifier"]
    #[inline(always)]
    pub fn efid(&self) -> EFID_R {
        EFID_R::new(((self.bits >> 3) & 0x0003_ffff) as u32)
    }
    #[doc = "Bit 2 - Frame format"]
    #[inline(always)]
    pub fn ff(&self) -> FF_R {
        FF_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Frame type"]
    #[inline(always)]
    pub fn ft(&self) -> FT_R {
        FT_R::new(((self.bits >> 1) & 0x01) != 0)
    }
}
#[doc = "Receive FIFO mailbox identifier register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rfifomi0](index.html) module"]
pub struct RFIFOMI0_SPEC;
impl crate::RegisterSpec for RFIFOMI0_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [rfifomi0::R](R) reader structure"]
impl crate::Readable for RFIFOMI0_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets RFIFOMI0 to value 0"]
impl crate::Resettable for RFIFOMI0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
