#[doc = "Register `RFIFO1` reader"]
pub struct R(crate::R<RFIFO1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<RFIFO1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<RFIFO1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<RFIFO1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `RFIFO1` writer"]
pub struct W(crate::W<RFIFO1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<RFIFO1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<RFIFO1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<RFIFO1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `RFD1` reader - Receive FIFO1 dequeue"]
pub struct RFD1_R(crate::FieldReader<bool, bool>);
impl RFD1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RFD1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFD1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFD1` writer - Receive FIFO1 dequeue"]
pub struct RFD1_W<'a> {
    w: &'a mut W,
}
impl<'a> RFD1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `RFO1` reader - Receive FIFO1 overfull"]
pub struct RFO1_R(crate::FieldReader<bool, bool>);
impl RFO1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RFO1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFO1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFO1` writer - Receive FIFO1 overfull"]
pub struct RFO1_W<'a> {
    w: &'a mut W,
}
impl<'a> RFO1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `RFF1` reader - Receive FIFO1 full"]
pub struct RFF1_R(crate::FieldReader<bool, bool>);
impl RFF1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RFF1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFF1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFF1` writer - Receive FIFO1 full"]
pub struct RFF1_W<'a> {
    w: &'a mut W,
}
impl<'a> RFF1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RFL1` reader - Receive FIFO1 length"]
pub struct RFL1_R(crate::FieldReader<u8, u8>);
impl RFL1_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        RFL1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFL1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 5 - Receive FIFO1 dequeue"]
    #[inline(always)]
    pub fn rfd1(&self) -> RFD1_R {
        RFD1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Receive FIFO1 overfull"]
    #[inline(always)]
    pub fn rfo1(&self) -> RFO1_R {
        RFO1_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Receive FIFO1 full"]
    #[inline(always)]
    pub fn rff1(&self) -> RFF1_R {
        RFF1_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bits 0:1 - Receive FIFO1 length"]
    #[inline(always)]
    pub fn rfl1(&self) -> RFL1_R {
        RFL1_R::new((self.bits & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 5 - Receive FIFO1 dequeue"]
    #[inline(always)]
    pub fn rfd1(&mut self) -> RFD1_W {
        RFD1_W { w: self }
    }
    #[doc = "Bit 4 - Receive FIFO1 overfull"]
    #[inline(always)]
    pub fn rfo1(&mut self) -> RFO1_W {
        RFO1_W { w: self }
    }
    #[doc = "Bit 3 - Receive FIFO1 full"]
    #[inline(always)]
    pub fn rff1(&mut self) -> RFF1_W {
        RFF1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Receive message FIFO1 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rfifo1](index.html) module"]
pub struct RFIFO1_SPEC;
impl crate::RegisterSpec for RFIFO1_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [rfifo1::R](R) reader structure"]
impl crate::Readable for RFIFO1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [rfifo1::W](W) writer structure"]
impl crate::Writable for RFIFO1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets RFIFO1 to value 0"]
impl crate::Resettable for RFIFO1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
