#[doc = "Register `FSCFG` reader"]
pub struct R(crate::R<FSCFG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<FSCFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<FSCFG_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<FSCFG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `FSCFG` writer"]
pub struct W(crate::W<FSCFG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<FSCFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<FSCFG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<FSCFG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `FS0` reader - Filter scale configuration"]
pub struct FS0_R(crate::FieldReader<bool, bool>);
impl FS0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS0` writer - Filter scale configuration"]
pub struct FS0_W<'a> {
    w: &'a mut W,
}
impl<'a> FS0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `FS1` reader - Filter scale configuration"]
pub struct FS1_R(crate::FieldReader<bool, bool>);
impl FS1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS1` writer - Filter scale configuration"]
pub struct FS1_W<'a> {
    w: &'a mut W,
}
impl<'a> FS1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `FS2` reader - Filter scale configuration"]
pub struct FS2_R(crate::FieldReader<bool, bool>);
impl FS2_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS2` writer - Filter scale configuration"]
pub struct FS2_W<'a> {
    w: &'a mut W,
}
impl<'a> FS2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `FS3` reader - Filter scale configuration"]
pub struct FS3_R(crate::FieldReader<bool, bool>);
impl FS3_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS3` writer - Filter scale configuration"]
pub struct FS3_W<'a> {
    w: &'a mut W,
}
impl<'a> FS3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `FS4` reader - Filter scale configuration"]
pub struct FS4_R(crate::FieldReader<bool, bool>);
impl FS4_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS4` writer - Filter scale configuration"]
pub struct FS4_W<'a> {
    w: &'a mut W,
}
impl<'a> FS4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `FS5` reader - Filter scale configuration"]
pub struct FS5_R(crate::FieldReader<bool, bool>);
impl FS5_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS5` writer - Filter scale configuration"]
pub struct FS5_W<'a> {
    w: &'a mut W,
}
impl<'a> FS5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `FS6` reader - Filter scale configuration"]
pub struct FS6_R(crate::FieldReader<bool, bool>);
impl FS6_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS6_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS6` writer - Filter scale configuration"]
pub struct FS6_W<'a> {
    w: &'a mut W,
}
impl<'a> FS6_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `FS7` reader - Filter scale configuration"]
pub struct FS7_R(crate::FieldReader<bool, bool>);
impl FS7_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS7_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS7_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS7` writer - Filter scale configuration"]
pub struct FS7_W<'a> {
    w: &'a mut W,
}
impl<'a> FS7_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `FS8` reader - Filter scale configuration"]
pub struct FS8_R(crate::FieldReader<bool, bool>);
impl FS8_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS8_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS8` writer - Filter scale configuration"]
pub struct FS8_W<'a> {
    w: &'a mut W,
}
impl<'a> FS8_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `FS9` reader - Filter scale configuration"]
pub struct FS9_R(crate::FieldReader<bool, bool>);
impl FS9_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS9_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS9_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS9` writer - Filter scale configuration"]
pub struct FS9_W<'a> {
    w: &'a mut W,
}
impl<'a> FS9_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `FS10` reader - Filter scale configuration"]
pub struct FS10_R(crate::FieldReader<bool, bool>);
impl FS10_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS10_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS10_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS10` writer - Filter scale configuration"]
pub struct FS10_W<'a> {
    w: &'a mut W,
}
impl<'a> FS10_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `FS11` reader - Filter scale configuration"]
pub struct FS11_R(crate::FieldReader<bool, bool>);
impl FS11_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS11_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS11_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS11` writer - Filter scale configuration"]
pub struct FS11_W<'a> {
    w: &'a mut W,
}
impl<'a> FS11_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `FS12` reader - Filter scale configuration"]
pub struct FS12_R(crate::FieldReader<bool, bool>);
impl FS12_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS12_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS12_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS12` writer - Filter scale configuration"]
pub struct FS12_W<'a> {
    w: &'a mut W,
}
impl<'a> FS12_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `FS13` reader - Filter scale configuration"]
pub struct FS13_R(crate::FieldReader<bool, bool>);
impl FS13_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS13_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS13_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS13` writer - Filter scale configuration"]
pub struct FS13_W<'a> {
    w: &'a mut W,
}
impl<'a> FS13_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `FS14` reader - Filter scale configuration"]
pub struct FS14_R(crate::FieldReader<bool, bool>);
impl FS14_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS14_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS14_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS14` writer - Filter scale configuration"]
pub struct FS14_W<'a> {
    w: &'a mut W,
}
impl<'a> FS14_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `FS15` reader - Filter scale configuration"]
pub struct FS15_R(crate::FieldReader<bool, bool>);
impl FS15_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS15_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS15_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS15` writer - Filter scale configuration"]
pub struct FS15_W<'a> {
    w: &'a mut W,
}
impl<'a> FS15_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `FS16` reader - Filter scale configuration"]
pub struct FS16_R(crate::FieldReader<bool, bool>);
impl FS16_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS16_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS16_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS16` writer - Filter scale configuration"]
pub struct FS16_W<'a> {
    w: &'a mut W,
}
impl<'a> FS16_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `FS17` reader - Filter scale configuration"]
pub struct FS17_R(crate::FieldReader<bool, bool>);
impl FS17_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS17_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS17_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS17` writer - Filter scale configuration"]
pub struct FS17_W<'a> {
    w: &'a mut W,
}
impl<'a> FS17_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `FS18` reader - Filter scale configuration"]
pub struct FS18_R(crate::FieldReader<bool, bool>);
impl FS18_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS18_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS18_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS18` writer - Filter scale configuration"]
pub struct FS18_W<'a> {
    w: &'a mut W,
}
impl<'a> FS18_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `FS19` reader - Filter scale configuration"]
pub struct FS19_R(crate::FieldReader<bool, bool>);
impl FS19_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS19_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS19_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS19` writer - Filter scale configuration"]
pub struct FS19_W<'a> {
    w: &'a mut W,
}
impl<'a> FS19_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Field `FS20` reader - Filter scale configuration"]
pub struct FS20_R(crate::FieldReader<bool, bool>);
impl FS20_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS20_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS20_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS20` writer - Filter scale configuration"]
pub struct FS20_W<'a> {
    w: &'a mut W,
}
impl<'a> FS20_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Field `FS21` reader - Filter scale configuration"]
pub struct FS21_R(crate::FieldReader<bool, bool>);
impl FS21_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS21_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS21_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS21` writer - Filter scale configuration"]
pub struct FS21_W<'a> {
    w: &'a mut W,
}
impl<'a> FS21_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Field `FS22` reader - Filter scale configuration"]
pub struct FS22_R(crate::FieldReader<bool, bool>);
impl FS22_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS22_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS22_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS22` writer - Filter scale configuration"]
pub struct FS22_W<'a> {
    w: &'a mut W,
}
impl<'a> FS22_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Field `FS23` reader - Filter scale configuration"]
pub struct FS23_R(crate::FieldReader<bool, bool>);
impl FS23_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS23_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS23_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS23` writer - Filter scale configuration"]
pub struct FS23_W<'a> {
    w: &'a mut W,
}
impl<'a> FS23_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Field `FS24` reader - Filter scale configuration"]
pub struct FS24_R(crate::FieldReader<bool, bool>);
impl FS24_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS24_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS24_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS24` writer - Filter scale configuration"]
pub struct FS24_W<'a> {
    w: &'a mut W,
}
impl<'a> FS24_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Field `FS25` reader - Filter scale configuration"]
pub struct FS25_R(crate::FieldReader<bool, bool>);
impl FS25_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS25_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS25_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS25` writer - Filter scale configuration"]
pub struct FS25_W<'a> {
    w: &'a mut W,
}
impl<'a> FS25_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 25)) | ((value as u32 & 0x01) << 25);
        self.w
    }
}
#[doc = "Field `FS26` reader - Filter scale configuration"]
pub struct FS26_R(crate::FieldReader<bool, bool>);
impl FS26_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS26_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS26_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS26` writer - Filter scale configuration"]
pub struct FS26_W<'a> {
    w: &'a mut W,
}
impl<'a> FS26_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 26)) | ((value as u32 & 0x01) << 26);
        self.w
    }
}
#[doc = "Field `FS27` reader - Filter scale configuration"]
pub struct FS27_R(crate::FieldReader<bool, bool>);
impl FS27_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FS27_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FS27_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FS27` writer - Filter scale configuration"]
pub struct FS27_W<'a> {
    w: &'a mut W,
}
impl<'a> FS27_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs0(&self) -> FS0_R {
        FS0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs1(&self) -> FS1_R {
        FS1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs2(&self) -> FS2_R {
        FS2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs3(&self) -> FS3_R {
        FS3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs4(&self) -> FS4_R {
        FS4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs5(&self) -> FS5_R {
        FS5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs6(&self) -> FS6_R {
        FS6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs7(&self) -> FS7_R {
        FS7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs8(&self) -> FS8_R {
        FS8_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs9(&self) -> FS9_R {
        FS9_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs10(&self) -> FS10_R {
        FS10_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs11(&self) -> FS11_R {
        FS11_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs12(&self) -> FS12_R {
        FS12_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs13(&self) -> FS13_R {
        FS13_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs14(&self) -> FS14_R {
        FS14_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs15(&self) -> FS15_R {
        FS15_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs16(&self) -> FS16_R {
        FS16_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs17(&self) -> FS17_R {
        FS17_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs18(&self) -> FS18_R {
        FS18_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs19(&self) -> FS19_R {
        FS19_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs20(&self) -> FS20_R {
        FS20_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 21 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs21(&self) -> FS21_R {
        FS21_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 22 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs22(&self) -> FS22_R {
        FS22_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 23 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs23(&self) -> FS23_R {
        FS23_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 24 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs24(&self) -> FS24_R {
        FS24_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 25 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs25(&self) -> FS25_R {
        FS25_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 26 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs26(&self) -> FS26_R {
        FS26_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 27 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs27(&self) -> FS27_R {
        FS27_R::new(((self.bits >> 27) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs0(&mut self) -> FS0_W {
        FS0_W { w: self }
    }
    #[doc = "Bit 1 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs1(&mut self) -> FS1_W {
        FS1_W { w: self }
    }
    #[doc = "Bit 2 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs2(&mut self) -> FS2_W {
        FS2_W { w: self }
    }
    #[doc = "Bit 3 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs3(&mut self) -> FS3_W {
        FS3_W { w: self }
    }
    #[doc = "Bit 4 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs4(&mut self) -> FS4_W {
        FS4_W { w: self }
    }
    #[doc = "Bit 5 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs5(&mut self) -> FS5_W {
        FS5_W { w: self }
    }
    #[doc = "Bit 6 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs6(&mut self) -> FS6_W {
        FS6_W { w: self }
    }
    #[doc = "Bit 7 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs7(&mut self) -> FS7_W {
        FS7_W { w: self }
    }
    #[doc = "Bit 8 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs8(&mut self) -> FS8_W {
        FS8_W { w: self }
    }
    #[doc = "Bit 9 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs9(&mut self) -> FS9_W {
        FS9_W { w: self }
    }
    #[doc = "Bit 10 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs10(&mut self) -> FS10_W {
        FS10_W { w: self }
    }
    #[doc = "Bit 11 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs11(&mut self) -> FS11_W {
        FS11_W { w: self }
    }
    #[doc = "Bit 12 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs12(&mut self) -> FS12_W {
        FS12_W { w: self }
    }
    #[doc = "Bit 13 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs13(&mut self) -> FS13_W {
        FS13_W { w: self }
    }
    #[doc = "Bit 14 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs14(&mut self) -> FS14_W {
        FS14_W { w: self }
    }
    #[doc = "Bit 15 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs15(&mut self) -> FS15_W {
        FS15_W { w: self }
    }
    #[doc = "Bit 16 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs16(&mut self) -> FS16_W {
        FS16_W { w: self }
    }
    #[doc = "Bit 17 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs17(&mut self) -> FS17_W {
        FS17_W { w: self }
    }
    #[doc = "Bit 18 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs18(&mut self) -> FS18_W {
        FS18_W { w: self }
    }
    #[doc = "Bit 19 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs19(&mut self) -> FS19_W {
        FS19_W { w: self }
    }
    #[doc = "Bit 20 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs20(&mut self) -> FS20_W {
        FS20_W { w: self }
    }
    #[doc = "Bit 21 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs21(&mut self) -> FS21_W {
        FS21_W { w: self }
    }
    #[doc = "Bit 22 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs22(&mut self) -> FS22_W {
        FS22_W { w: self }
    }
    #[doc = "Bit 23 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs23(&mut self) -> FS23_W {
        FS23_W { w: self }
    }
    #[doc = "Bit 24 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs24(&mut self) -> FS24_W {
        FS24_W { w: self }
    }
    #[doc = "Bit 25 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs25(&mut self) -> FS25_W {
        FS25_W { w: self }
    }
    #[doc = "Bit 26 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs26(&mut self) -> FS26_W {
        FS26_W { w: self }
    }
    #[doc = "Bit 27 - Filter scale configuration"]
    #[inline(always)]
    pub fn fs27(&mut self) -> FS27_W {
        FS27_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Filter scale configuration register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fscfg](index.html) module"]
pub struct FSCFG_SPEC;
impl crate::RegisterSpec for FSCFG_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [fscfg::R](R) reader structure"]
impl crate::Readable for FSCFG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [fscfg::W](W) writer structure"]
impl crate::Writable for FSCFG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets FSCFG to value 0"]
impl crate::Resettable for FSCFG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
