#[doc = "Register `PCF1` reader"]
pub struct R(crate::R<PCF1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PCF1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PCF1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PCF1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PCF1` writer"]
pub struct W(crate::W<PCF1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PCF1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PCF1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PCF1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CTC_REMAP` reader - CTC remapping"]
pub struct CTC_REMAP_R(crate::FieldReader<u8, u8>);
impl CTC_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        CTC_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CTC_REMAP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CTC_REMAP` writer - CTC remapping"]
pub struct CTC_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> CTC_REMAP_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 11)) | ((value as u32 & 0x03) << 11);
        self.w
    }
}
#[doc = "Field `FSMC_NADV` reader - FSMC_NADV connect/disconnect"]
pub struct FSMC_NADV_R(crate::FieldReader<bool, bool>);
impl FSMC_NADV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FSMC_NADV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FSMC_NADV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FSMC_NADV` writer - FSMC_NADV connect/disconnect"]
pub struct FSMC_NADV_W<'a> {
    w: &'a mut W,
}
impl<'a> FSMC_NADV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `TIMER13_REMAP` reader - TIMER13 remapping"]
pub struct TIMER13_REMAP_R(crate::FieldReader<bool, bool>);
impl TIMER13_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TIMER13_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER13_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER13_REMAP` writer - TIMER13 remapping"]
pub struct TIMER13_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER13_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `TIMER12_REMAP` reader - TIMER12 remapping"]
pub struct TIMER12_REMAP_R(crate::FieldReader<bool, bool>);
impl TIMER12_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TIMER12_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER12_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER12_REMAP` writer - TIMER12 remapping"]
pub struct TIMER12_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER12_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `TIMER10_REMAP` reader - TIMER10 remapping"]
pub struct TIMER10_REMAP_R(crate::FieldReader<bool, bool>);
impl TIMER10_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TIMER10_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER10_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER10_REMAP` writer - TIMER10 remapping"]
pub struct TIMER10_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER10_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `TIMER9_REMAP` reader - TIMER9 remapping"]
pub struct TIMER9_REMAP_R(crate::FieldReader<bool, bool>);
impl TIMER9_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TIMER9_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER9_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER9_REMAP` writer - TIMER9 remapping"]
pub struct TIMER9_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER9_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `TIMER8_REMAP` reader - TIMER8 remapping"]
pub struct TIMER8_REMAP_R(crate::FieldReader<bool, bool>);
impl TIMER8_REMAP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TIMER8_REMAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER8_REMAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER8_REMAP` writer - TIMER8 remapping"]
pub struct TIMER8_REMAP_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER8_REMAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bits 11:12 - CTC remapping"]
    #[inline(always)]
    pub fn ctc_remap(&self) -> CTC_REMAP_R {
        CTC_REMAP_R::new(((self.bits >> 11) & 0x03) as u8)
    }
    #[doc = "Bit 10 - FSMC_NADV connect/disconnect"]
    #[inline(always)]
    pub fn fsmc_nadv(&self) -> FSMC_NADV_R {
        FSMC_NADV_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - TIMER13 remapping"]
    #[inline(always)]
    pub fn timer13_remap(&self) -> TIMER13_REMAP_R {
        TIMER13_REMAP_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - TIMER12 remapping"]
    #[inline(always)]
    pub fn timer12_remap(&self) -> TIMER12_REMAP_R {
        TIMER12_REMAP_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - TIMER10 remapping"]
    #[inline(always)]
    pub fn timer10_remap(&self) -> TIMER10_REMAP_R {
        TIMER10_REMAP_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - TIMER9 remapping"]
    #[inline(always)]
    pub fn timer9_remap(&self) -> TIMER9_REMAP_R {
        TIMER9_REMAP_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - TIMER8 remapping"]
    #[inline(always)]
    pub fn timer8_remap(&self) -> TIMER8_REMAP_R {
        TIMER8_REMAP_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 11:12 - CTC remapping"]
    #[inline(always)]
    pub fn ctc_remap(&mut self) -> CTC_REMAP_W {
        CTC_REMAP_W { w: self }
    }
    #[doc = "Bit 10 - FSMC_NADV connect/disconnect"]
    #[inline(always)]
    pub fn fsmc_nadv(&mut self) -> FSMC_NADV_W {
        FSMC_NADV_W { w: self }
    }
    #[doc = "Bit 9 - TIMER13 remapping"]
    #[inline(always)]
    pub fn timer13_remap(&mut self) -> TIMER13_REMAP_W {
        TIMER13_REMAP_W { w: self }
    }
    #[doc = "Bit 8 - TIMER12 remapping"]
    #[inline(always)]
    pub fn timer12_remap(&mut self) -> TIMER12_REMAP_W {
        TIMER12_REMAP_W { w: self }
    }
    #[doc = "Bit 7 - TIMER10 remapping"]
    #[inline(always)]
    pub fn timer10_remap(&mut self) -> TIMER10_REMAP_W {
        TIMER10_REMAP_W { w: self }
    }
    #[doc = "Bit 6 - TIMER9 remapping"]
    #[inline(always)]
    pub fn timer9_remap(&mut self) -> TIMER9_REMAP_W {
        TIMER9_REMAP_W { w: self }
    }
    #[doc = "Bit 5 - TIMER8 remapping"]
    #[inline(always)]
    pub fn timer8_remap(&mut self) -> TIMER8_REMAP_W {
        TIMER8_REMAP_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "AFIO port configuration register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pcf1](index.html) module"]
pub struct PCF1_SPEC;
impl crate::RegisterSpec for PCF1_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [pcf1::R](R) reader structure"]
impl crate::Readable for PCF1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pcf1::W](W) writer structure"]
impl crate::Writable for PCF1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PCF1 to value 0"]
impl crate::Resettable for PCF1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
