#[doc = "Register `EXTISS3` reader"]
pub struct R(crate::R<EXTISS3_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EXTISS3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EXTISS3_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EXTISS3_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EXTISS3` writer"]
pub struct W(crate::W<EXTISS3_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EXTISS3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EXTISS3_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EXTISS3_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `EXTI15_SS` reader - EXTI 15 sources selection"]
pub struct EXTI15_SS_R(crate::FieldReader<u8, u8>);
impl EXTI15_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI15_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI15_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI15_SS` writer - EXTI 15 sources selection"]
pub struct EXTI15_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI15_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 12)) | ((value as u32 & 0x0f) << 12);
        self.w
    }
}
#[doc = "Field `EXTI14_SS` reader - EXTI 14 sources selection"]
pub struct EXTI14_SS_R(crate::FieldReader<u8, u8>);
impl EXTI14_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI14_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI14_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI14_SS` writer - EXTI 14 sources selection"]
pub struct EXTI14_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI14_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 8)) | ((value as u32 & 0x0f) << 8);
        self.w
    }
}
#[doc = "Field `EXTI13_SS` reader - EXTI 13 sources selection"]
pub struct EXTI13_SS_R(crate::FieldReader<u8, u8>);
impl EXTI13_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI13_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI13_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI13_SS` writer - EXTI 13 sources selection"]
pub struct EXTI13_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI13_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `EXTI12_SS` reader - EXTI 12 sources selection"]
pub struct EXTI12_SS_R(crate::FieldReader<u8, u8>);
impl EXTI12_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI12_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI12_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI12_SS` writer - EXTI 12 sources selection"]
pub struct EXTI12_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI12_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
        self.w
    }
}
impl R {
    #[doc = "Bits 12:15 - EXTI 15 sources selection"]
    #[inline(always)]
    pub fn exti15_ss(&self) -> EXTI15_SS_R {
        EXTI15_SS_R::new(((self.bits >> 12) & 0x0f) as u8)
    }
    #[doc = "Bits 8:11 - EXTI 14 sources selection"]
    #[inline(always)]
    pub fn exti14_ss(&self) -> EXTI14_SS_R {
        EXTI14_SS_R::new(((self.bits >> 8) & 0x0f) as u8)
    }
    #[doc = "Bits 4:7 - EXTI 13 sources selection"]
    #[inline(always)]
    pub fn exti13_ss(&self) -> EXTI13_SS_R {
        EXTI13_SS_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 0:3 - EXTI 12 sources selection"]
    #[inline(always)]
    pub fn exti12_ss(&self) -> EXTI12_SS_R {
        EXTI12_SS_R::new((self.bits & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bits 12:15 - EXTI 15 sources selection"]
    #[inline(always)]
    pub fn exti15_ss(&mut self) -> EXTI15_SS_W {
        EXTI15_SS_W { w: self }
    }
    #[doc = "Bits 8:11 - EXTI 14 sources selection"]
    #[inline(always)]
    pub fn exti14_ss(&mut self) -> EXTI14_SS_W {
        EXTI14_SS_W { w: self }
    }
    #[doc = "Bits 4:7 - EXTI 13 sources selection"]
    #[inline(always)]
    pub fn exti13_ss(&mut self) -> EXTI13_SS_W {
        EXTI13_SS_W { w: self }
    }
    #[doc = "Bits 0:3 - EXTI 12 sources selection"]
    #[inline(always)]
    pub fn exti12_ss(&mut self) -> EXTI12_SS_W {
        EXTI12_SS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "EXTI sources selection register 3\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [extiss3](index.html) module"]
pub struct EXTISS3_SPEC;
impl crate::RegisterSpec for EXTISS3_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [extiss3::R](R) reader structure"]
impl crate::Readable for EXTISS3_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [extiss3::W](W) writer structure"]
impl crate::Writable for EXTISS3_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EXTISS3 to value 0"]
impl crate::Resettable for EXTISS3_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
