#[doc = "Register `EXTISS1` reader"]
pub struct R(crate::R<EXTISS1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EXTISS1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EXTISS1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EXTISS1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EXTISS1` writer"]
pub struct W(crate::W<EXTISS1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EXTISS1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EXTISS1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EXTISS1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `EXTI7_SS` reader - EXTI 7 sources selection"]
pub struct EXTI7_SS_R(crate::FieldReader<u8, u8>);
impl EXTI7_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI7_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI7_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI7_SS` writer - EXTI 7 sources selection"]
pub struct EXTI7_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI7_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 12)) | ((value as u32 & 0x0f) << 12);
        self.w
    }
}
#[doc = "Field `EXTI6_SS` reader - EXTI 6 sources selection"]
pub struct EXTI6_SS_R(crate::FieldReader<u8, u8>);
impl EXTI6_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI6_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI6_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI6_SS` writer - EXTI 6 sources selection"]
pub struct EXTI6_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI6_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 8)) | ((value as u32 & 0x0f) << 8);
        self.w
    }
}
#[doc = "Field `EXTI5_SS` reader - EXTI 5 sources selection"]
pub struct EXTI5_SS_R(crate::FieldReader<u8, u8>);
impl EXTI5_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI5_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI5_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI5_SS` writer - EXTI 5 sources selection"]
pub struct EXTI5_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI5_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `EXTI4_SS` reader - EXTI 4 sources selection"]
pub struct EXTI4_SS_R(crate::FieldReader<u8, u8>);
impl EXTI4_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI4_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI4_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI4_SS` writer - EXTI 4 sources selection"]
pub struct EXTI4_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI4_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
        self.w
    }
}
impl R {
    #[doc = "Bits 12:15 - EXTI 7 sources selection"]
    #[inline(always)]
    pub fn exti7_ss(&self) -> EXTI7_SS_R {
        EXTI7_SS_R::new(((self.bits >> 12) & 0x0f) as u8)
    }
    #[doc = "Bits 8:11 - EXTI 6 sources selection"]
    #[inline(always)]
    pub fn exti6_ss(&self) -> EXTI6_SS_R {
        EXTI6_SS_R::new(((self.bits >> 8) & 0x0f) as u8)
    }
    #[doc = "Bits 4:7 - EXTI 5 sources selection"]
    #[inline(always)]
    pub fn exti5_ss(&self) -> EXTI5_SS_R {
        EXTI5_SS_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 0:3 - EXTI 4 sources selection"]
    #[inline(always)]
    pub fn exti4_ss(&self) -> EXTI4_SS_R {
        EXTI4_SS_R::new((self.bits & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bits 12:15 - EXTI 7 sources selection"]
    #[inline(always)]
    pub fn exti7_ss(&mut self) -> EXTI7_SS_W {
        EXTI7_SS_W { w: self }
    }
    #[doc = "Bits 8:11 - EXTI 6 sources selection"]
    #[inline(always)]
    pub fn exti6_ss(&mut self) -> EXTI6_SS_W {
        EXTI6_SS_W { w: self }
    }
    #[doc = "Bits 4:7 - EXTI 5 sources selection"]
    #[inline(always)]
    pub fn exti5_ss(&mut self) -> EXTI5_SS_W {
        EXTI5_SS_W { w: self }
    }
    #[doc = "Bits 0:3 - EXTI 4 sources selection"]
    #[inline(always)]
    pub fn exti4_ss(&mut self) -> EXTI4_SS_W {
        EXTI4_SS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "EXTI sources selection register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [extiss1](index.html) module"]
pub struct EXTISS1_SPEC;
impl crate::RegisterSpec for EXTISS1_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [extiss1::R](R) reader structure"]
impl crate::Readable for EXTISS1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [extiss1::W](W) writer structure"]
impl crate::Writable for EXTISS1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EXTISS1 to value 0"]
impl crate::Resettable for EXTISS1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
