#[doc = "Register `EXTISS0` reader"]
pub struct R(crate::R<EXTISS0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EXTISS0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EXTISS0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EXTISS0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EXTISS0` writer"]
pub struct W(crate::W<EXTISS0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EXTISS0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EXTISS0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EXTISS0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `EXTI3_SS` reader - EXTI 3 sources selection"]
pub struct EXTI3_SS_R(crate::FieldReader<u8, u8>);
impl EXTI3_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI3_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI3_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI3_SS` writer - EXTI 3 sources selection"]
pub struct EXTI3_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI3_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 12)) | ((value as u32 & 0x0f) << 12);
        self.w
    }
}
#[doc = "Field `EXTI2_SS` reader - EXTI 2 sources selection"]
pub struct EXTI2_SS_R(crate::FieldReader<u8, u8>);
impl EXTI2_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI2_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI2_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI2_SS` writer - EXTI 2 sources selection"]
pub struct EXTI2_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI2_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 8)) | ((value as u32 & 0x0f) << 8);
        self.w
    }
}
#[doc = "Field `EXTI1_SS` reader - EXTI 1 sources selection"]
pub struct EXTI1_SS_R(crate::FieldReader<u8, u8>);
impl EXTI1_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI1_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI1_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI1_SS` writer - EXTI 1 sources selection"]
pub struct EXTI1_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI1_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `EXTI0_SS` reader - EXTI 0 sources selection"]
pub struct EXTI0_SS_R(crate::FieldReader<u8, u8>);
impl EXTI0_SS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EXTI0_SS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTI0_SS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTI0_SS` writer - EXTI 0 sources selection"]
pub struct EXTI0_SS_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTI0_SS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
        self.w
    }
}
impl R {
    #[doc = "Bits 12:15 - EXTI 3 sources selection"]
    #[inline(always)]
    pub fn exti3_ss(&self) -> EXTI3_SS_R {
        EXTI3_SS_R::new(((self.bits >> 12) & 0x0f) as u8)
    }
    #[doc = "Bits 8:11 - EXTI 2 sources selection"]
    #[inline(always)]
    pub fn exti2_ss(&self) -> EXTI2_SS_R {
        EXTI2_SS_R::new(((self.bits >> 8) & 0x0f) as u8)
    }
    #[doc = "Bits 4:7 - EXTI 1 sources selection"]
    #[inline(always)]
    pub fn exti1_ss(&self) -> EXTI1_SS_R {
        EXTI1_SS_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 0:3 - EXTI 0 sources selection"]
    #[inline(always)]
    pub fn exti0_ss(&self) -> EXTI0_SS_R {
        EXTI0_SS_R::new((self.bits & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bits 12:15 - EXTI 3 sources selection"]
    #[inline(always)]
    pub fn exti3_ss(&mut self) -> EXTI3_SS_W {
        EXTI3_SS_W { w: self }
    }
    #[doc = "Bits 8:11 - EXTI 2 sources selection"]
    #[inline(always)]
    pub fn exti2_ss(&mut self) -> EXTI2_SS_W {
        EXTI2_SS_W { w: self }
    }
    #[doc = "Bits 4:7 - EXTI 1 sources selection"]
    #[inline(always)]
    pub fn exti1_ss(&mut self) -> EXTI1_SS_W {
        EXTI1_SS_W { w: self }
    }
    #[doc = "Bits 0:3 - EXTI 0 sources selection"]
    #[inline(always)]
    pub fn exti0_ss(&mut self) -> EXTI0_SS_W {
        EXTI0_SS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "EXTI sources selection register 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [extiss0](index.html) module"]
pub struct EXTISS0_SPEC;
impl crate::RegisterSpec for EXTISS0_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [extiss0::R](R) reader structure"]
impl crate::Readable for EXTISS0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [extiss0::W](W) writer structure"]
impl crate::Writable for EXTISS0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EXTISS0 to value 0"]
impl crate::Resettable for EXTISS0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
