#[doc = "Register `SAMPT1` reader"]
pub struct R(crate::R<SAMPT1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SAMPT1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SAMPT1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SAMPT1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SAMPT1` writer"]
pub struct W(crate::W<SAMPT1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SAMPT1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SAMPT1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SAMPT1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SPT0` reader - Channel 0 sample time selection"]
pub struct SPT0_R(crate::FieldReader<u8, u8>);
impl SPT0_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPT0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPT0_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPT0` writer - Channel 0 sample time selection"]
pub struct SPT0_W<'a> {
    w: &'a mut W,
}
impl<'a> SPT0_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u32 & 0x07);
        self.w
    }
}
#[doc = "Field `SPT1` reader - Channel 1 sample time selection"]
pub struct SPT1_R(crate::FieldReader<u8, u8>);
impl SPT1_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPT1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPT1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPT1` writer - Channel 1 sample time selection"]
pub struct SPT1_W<'a> {
    w: &'a mut W,
}
impl<'a> SPT1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 3)) | ((value as u32 & 0x07) << 3);
        self.w
    }
}
#[doc = "Field `SPT2` reader - Channel 2 sample time selection"]
pub struct SPT2_R(crate::FieldReader<u8, u8>);
impl SPT2_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPT2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPT2_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPT2` writer - Channel 2 sample time selection"]
pub struct SPT2_W<'a> {
    w: &'a mut W,
}
impl<'a> SPT2_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 6)) | ((value as u32 & 0x07) << 6);
        self.w
    }
}
#[doc = "Field `SPT3` reader - Channel 3 sample time selection"]
pub struct SPT3_R(crate::FieldReader<u8, u8>);
impl SPT3_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPT3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPT3_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPT3` writer - Channel 3 sample time selection"]
pub struct SPT3_W<'a> {
    w: &'a mut W,
}
impl<'a> SPT3_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 9)) | ((value as u32 & 0x07) << 9);
        self.w
    }
}
#[doc = "Field `SPT4` reader - Channel 4 sample time selection"]
pub struct SPT4_R(crate::FieldReader<u8, u8>);
impl SPT4_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPT4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPT4_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPT4` writer - Channel 4 sample time selection"]
pub struct SPT4_W<'a> {
    w: &'a mut W,
}
impl<'a> SPT4_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 12)) | ((value as u32 & 0x07) << 12);
        self.w
    }
}
#[doc = "Field `SPT5` reader - Channel 5 sample time selection"]
pub struct SPT5_R(crate::FieldReader<u8, u8>);
impl SPT5_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPT5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPT5_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPT5` writer - Channel 5 sample time selection"]
pub struct SPT5_W<'a> {
    w: &'a mut W,
}
impl<'a> SPT5_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 15)) | ((value as u32 & 0x07) << 15);
        self.w
    }
}
#[doc = "Field `SPT6` reader - Channel 6 sample time selection"]
pub struct SPT6_R(crate::FieldReader<u8, u8>);
impl SPT6_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPT6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPT6_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPT6` writer - Channel 6 sample time selection"]
pub struct SPT6_W<'a> {
    w: &'a mut W,
}
impl<'a> SPT6_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 18)) | ((value as u32 & 0x07) << 18);
        self.w
    }
}
#[doc = "Field `SPT7` reader - Channel 7 sample time selection"]
pub struct SPT7_R(crate::FieldReader<u8, u8>);
impl SPT7_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPT7_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPT7_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPT7` writer - Channel 7 sample time selection"]
pub struct SPT7_W<'a> {
    w: &'a mut W,
}
impl<'a> SPT7_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 21)) | ((value as u32 & 0x07) << 21);
        self.w
    }
}
#[doc = "Field `SPT8` reader - Channel 8 sample time selection"]
pub struct SPT8_R(crate::FieldReader<u8, u8>);
impl SPT8_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPT8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPT8_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPT8` writer - Channel 8 sample time selection"]
pub struct SPT8_W<'a> {
    w: &'a mut W,
}
impl<'a> SPT8_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 24)) | ((value as u32 & 0x07) << 24);
        self.w
    }
}
#[doc = "Field `SPT9` reader - Channel 9 sample time selection"]
pub struct SPT9_R(crate::FieldReader<u8, u8>);
impl SPT9_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPT9_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPT9_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPT9` writer - Channel 9 sample time selection"]
pub struct SPT9_W<'a> {
    w: &'a mut W,
}
impl<'a> SPT9_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 27)) | ((value as u32 & 0x07) << 27);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Channel 0 sample time selection"]
    #[inline(always)]
    pub fn spt0(&self) -> SPT0_R {
        SPT0_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bits 3:5 - Channel 1 sample time selection"]
    #[inline(always)]
    pub fn spt1(&self) -> SPT1_R {
        SPT1_R::new(((self.bits >> 3) & 0x07) as u8)
    }
    #[doc = "Bits 6:8 - Channel 2 sample time selection"]
    #[inline(always)]
    pub fn spt2(&self) -> SPT2_R {
        SPT2_R::new(((self.bits >> 6) & 0x07) as u8)
    }
    #[doc = "Bits 9:11 - Channel 3 sample time selection"]
    #[inline(always)]
    pub fn spt3(&self) -> SPT3_R {
        SPT3_R::new(((self.bits >> 9) & 0x07) as u8)
    }
    #[doc = "Bits 12:14 - Channel 4 sample time selection"]
    #[inline(always)]
    pub fn spt4(&self) -> SPT4_R {
        SPT4_R::new(((self.bits >> 12) & 0x07) as u8)
    }
    #[doc = "Bits 15:17 - Channel 5 sample time selection"]
    #[inline(always)]
    pub fn spt5(&self) -> SPT5_R {
        SPT5_R::new(((self.bits >> 15) & 0x07) as u8)
    }
    #[doc = "Bits 18:20 - Channel 6 sample time selection"]
    #[inline(always)]
    pub fn spt6(&self) -> SPT6_R {
        SPT6_R::new(((self.bits >> 18) & 0x07) as u8)
    }
    #[doc = "Bits 21:23 - Channel 7 sample time selection"]
    #[inline(always)]
    pub fn spt7(&self) -> SPT7_R {
        SPT7_R::new(((self.bits >> 21) & 0x07) as u8)
    }
    #[doc = "Bits 24:26 - Channel 8 sample time selection"]
    #[inline(always)]
    pub fn spt8(&self) -> SPT8_R {
        SPT8_R::new(((self.bits >> 24) & 0x07) as u8)
    }
    #[doc = "Bits 27:29 - Channel 9 sample time selection"]
    #[inline(always)]
    pub fn spt9(&self) -> SPT9_R {
        SPT9_R::new(((self.bits >> 27) & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bits 0:2 - Channel 0 sample time selection"]
    #[inline(always)]
    pub fn spt0(&mut self) -> SPT0_W {
        SPT0_W { w: self }
    }
    #[doc = "Bits 3:5 - Channel 1 sample time selection"]
    #[inline(always)]
    pub fn spt1(&mut self) -> SPT1_W {
        SPT1_W { w: self }
    }
    #[doc = "Bits 6:8 - Channel 2 sample time selection"]
    #[inline(always)]
    pub fn spt2(&mut self) -> SPT2_W {
        SPT2_W { w: self }
    }
    #[doc = "Bits 9:11 - Channel 3 sample time selection"]
    #[inline(always)]
    pub fn spt3(&mut self) -> SPT3_W {
        SPT3_W { w: self }
    }
    #[doc = "Bits 12:14 - Channel 4 sample time selection"]
    #[inline(always)]
    pub fn spt4(&mut self) -> SPT4_W {
        SPT4_W { w: self }
    }
    #[doc = "Bits 15:17 - Channel 5 sample time selection"]
    #[inline(always)]
    pub fn spt5(&mut self) -> SPT5_W {
        SPT5_W { w: self }
    }
    #[doc = "Bits 18:20 - Channel 6 sample time selection"]
    #[inline(always)]
    pub fn spt6(&mut self) -> SPT6_W {
        SPT6_W { w: self }
    }
    #[doc = "Bits 21:23 - Channel 7 sample time selection"]
    #[inline(always)]
    pub fn spt7(&mut self) -> SPT7_W {
        SPT7_W { w: self }
    }
    #[doc = "Bits 24:26 - Channel 8 sample time selection"]
    #[inline(always)]
    pub fn spt8(&mut self) -> SPT8_W {
        SPT8_W { w: self }
    }
    #[doc = "Bits 27:29 - Channel 9 sample time selection"]
    #[inline(always)]
    pub fn spt9(&mut self) -> SPT9_W {
        SPT9_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Sample time register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sampt1](index.html) module"]
pub struct SAMPT1_SPEC;
impl crate::RegisterSpec for SAMPT1_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [sampt1::R](R) reader structure"]
impl crate::Readable for SAMPT1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [sampt1::W](W) writer structure"]
impl crate::Writable for SAMPT1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SAMPT1 to value 0"]
impl crate::Resettable for SAMPT1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
