#[doc = "Register `ASW` reader"]
pub struct R(crate::R<ASW_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ASW_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ASW_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ASW_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ASW` writer"]
pub struct W(crate::W<ASW_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ASW_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ASW_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ASW_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `G5P3` reader - G5P3 analog switch enable"]
pub struct G5P3_R(crate::FieldReader<bool, bool>);
impl G5P3_R {
    pub(crate) fn new(bits: bool) -> Self {
        G5P3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G5P3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G5P3` writer - G5P3 analog switch enable"]
pub struct G5P3_W<'a> {
    w: &'a mut W,
}
impl<'a> G5P3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Field `G5P2` reader - G5P2 analog switch enable"]
pub struct G5P2_R(crate::FieldReader<bool, bool>);
impl G5P2_R {
    pub(crate) fn new(bits: bool) -> Self {
        G5P2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G5P2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G5P2` writer - G5P2 analog switch enable"]
pub struct G5P2_W<'a> {
    w: &'a mut W,
}
impl<'a> G5P2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Field `G5P1` reader - G5P1 analog switch enable"]
pub struct G5P1_R(crate::FieldReader<bool, bool>);
impl G5P1_R {
    pub(crate) fn new(bits: bool) -> Self {
        G5P1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G5P1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G5P1` writer - G5P1 analog switch enable"]
pub struct G5P1_W<'a> {
    w: &'a mut W,
}
impl<'a> G5P1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Field `G5P0` reader - G5P0 analog switch enable"]
pub struct G5P0_R(crate::FieldReader<bool, bool>);
impl G5P0_R {
    pub(crate) fn new(bits: bool) -> Self {
        G5P0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G5P0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G5P0` writer - G5P0 analog switch enable"]
pub struct G5P0_W<'a> {
    w: &'a mut W,
}
impl<'a> G5P0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Field `G4P3` reader - G4P3 analog switch enable"]
pub struct G4P3_R(crate::FieldReader<bool, bool>);
impl G4P3_R {
    pub(crate) fn new(bits: bool) -> Self {
        G4P3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G4P3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G4P3` writer - G4P3 analog switch enable"]
pub struct G4P3_W<'a> {
    w: &'a mut W,
}
impl<'a> G4P3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Field `G4P2` reader - G4P2 analog switch enable"]
pub struct G4P2_R(crate::FieldReader<bool, bool>);
impl G4P2_R {
    pub(crate) fn new(bits: bool) -> Self {
        G4P2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G4P2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G4P2` writer - G4P2 analog switch enable"]
pub struct G4P2_W<'a> {
    w: &'a mut W,
}
impl<'a> G4P2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `G4P1` reader - G4P1 analog switch enable"]
pub struct G4P1_R(crate::FieldReader<bool, bool>);
impl G4P1_R {
    pub(crate) fn new(bits: bool) -> Self {
        G4P1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G4P1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G4P1` writer - G4P1 analog switch enable"]
pub struct G4P1_W<'a> {
    w: &'a mut W,
}
impl<'a> G4P1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `G4P0` reader - G4P0 analog switch enable"]
pub struct G4P0_R(crate::FieldReader<bool, bool>);
impl G4P0_R {
    pub(crate) fn new(bits: bool) -> Self {
        G4P0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G4P0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G4P0` writer - G4P0 analog switch enable"]
pub struct G4P0_W<'a> {
    w: &'a mut W,
}
impl<'a> G4P0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `G3P3` reader - G3P3 analog switch enable"]
pub struct G3P3_R(crate::FieldReader<bool, bool>);
impl G3P3_R {
    pub(crate) fn new(bits: bool) -> Self {
        G3P3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G3P3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G3P3` writer - G3P3 analog switch enable"]
pub struct G3P3_W<'a> {
    w: &'a mut W,
}
impl<'a> G3P3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `G3P2` reader - G3P2 analog switch enable"]
pub struct G3P2_R(crate::FieldReader<bool, bool>);
impl G3P2_R {
    pub(crate) fn new(bits: bool) -> Self {
        G3P2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G3P2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G3P2` writer - G3P2 analog switch enable"]
pub struct G3P2_W<'a> {
    w: &'a mut W,
}
impl<'a> G3P2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `G3P1` reader - G3P1 analog switch enable"]
pub struct G3P1_R(crate::FieldReader<bool, bool>);
impl G3P1_R {
    pub(crate) fn new(bits: bool) -> Self {
        G3P1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G3P1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G3P1` writer - G3P1 analog switch enable"]
pub struct G3P1_W<'a> {
    w: &'a mut W,
}
impl<'a> G3P1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `G3P0` reader - G3P0 analog switch enable"]
pub struct G3P0_R(crate::FieldReader<bool, bool>);
impl G3P0_R {
    pub(crate) fn new(bits: bool) -> Self {
        G3P0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G3P0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G3P0` writer - G3P0 analog switch enable"]
pub struct G3P0_W<'a> {
    w: &'a mut W,
}
impl<'a> G3P0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `G2P3` reader - G2P3 analog switch enable"]
pub struct G2P3_R(crate::FieldReader<bool, bool>);
impl G2P3_R {
    pub(crate) fn new(bits: bool) -> Self {
        G2P3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G2P3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G2P3` writer - G2P3 analog switch enable"]
pub struct G2P3_W<'a> {
    w: &'a mut W,
}
impl<'a> G2P3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `G2P2` reader - G2P2 analog switch enable"]
pub struct G2P2_R(crate::FieldReader<bool, bool>);
impl G2P2_R {
    pub(crate) fn new(bits: bool) -> Self {
        G2P2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G2P2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G2P2` writer - G2P2 analog switch enable"]
pub struct G2P2_W<'a> {
    w: &'a mut W,
}
impl<'a> G2P2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `G2P1` reader - G2P1 analog switch enable"]
pub struct G2P1_R(crate::FieldReader<bool, bool>);
impl G2P1_R {
    pub(crate) fn new(bits: bool) -> Self {
        G2P1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G2P1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G2P1` writer - G2P1 analog switch enable"]
pub struct G2P1_W<'a> {
    w: &'a mut W,
}
impl<'a> G2P1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `G2P0` reader - G2P0 analog switch enable"]
pub struct G2P0_R(crate::FieldReader<bool, bool>);
impl G2P0_R {
    pub(crate) fn new(bits: bool) -> Self {
        G2P0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G2P0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G2P0` writer - G2P0 analog switch enable"]
pub struct G2P0_W<'a> {
    w: &'a mut W,
}
impl<'a> G2P0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `G1P3` reader - G1P3 analog switch enable"]
pub struct G1P3_R(crate::FieldReader<bool, bool>);
impl G1P3_R {
    pub(crate) fn new(bits: bool) -> Self {
        G1P3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G1P3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G1P3` writer - G1P3 analog switch enable"]
pub struct G1P3_W<'a> {
    w: &'a mut W,
}
impl<'a> G1P3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `G1P2` reader - G1P2 analog switch enable"]
pub struct G1P2_R(crate::FieldReader<bool, bool>);
impl G1P2_R {
    pub(crate) fn new(bits: bool) -> Self {
        G1P2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G1P2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G1P2` writer - G1P2 analog switch enable"]
pub struct G1P2_W<'a> {
    w: &'a mut W,
}
impl<'a> G1P2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `G1P1` reader - G1P1 analog switch enable"]
pub struct G1P1_R(crate::FieldReader<bool, bool>);
impl G1P1_R {
    pub(crate) fn new(bits: bool) -> Self {
        G1P1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G1P1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G1P1` writer - G1P1 analog switch enable"]
pub struct G1P1_W<'a> {
    w: &'a mut W,
}
impl<'a> G1P1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `G1P0` reader - G1P0 analog switch enable"]
pub struct G1P0_R(crate::FieldReader<bool, bool>);
impl G1P0_R {
    pub(crate) fn new(bits: bool) -> Self {
        G1P0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G1P0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G1P0` writer - G1P0 analog switch enable"]
pub struct G1P0_W<'a> {
    w: &'a mut W,
}
impl<'a> G1P0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `G0P3` reader - G0P3 analog switch enable"]
pub struct G0P3_R(crate::FieldReader<bool, bool>);
impl G0P3_R {
    pub(crate) fn new(bits: bool) -> Self {
        G0P3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G0P3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G0P3` writer - G0P3 analog switch enable"]
pub struct G0P3_W<'a> {
    w: &'a mut W,
}
impl<'a> G0P3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `G0P2` reader - G0P2 analog switch enable"]
pub struct G0P2_R(crate::FieldReader<bool, bool>);
impl G0P2_R {
    pub(crate) fn new(bits: bool) -> Self {
        G0P2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G0P2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G0P2` writer - G0P2 analog switch enable"]
pub struct G0P2_W<'a> {
    w: &'a mut W,
}
impl<'a> G0P2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `G0P1` reader - G0P1 analog switch enable"]
pub struct G0P1_R(crate::FieldReader<bool, bool>);
impl G0P1_R {
    pub(crate) fn new(bits: bool) -> Self {
        G0P1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G0P1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G0P1` writer - G0P1 analog switch enable"]
pub struct G0P1_W<'a> {
    w: &'a mut W,
}
impl<'a> G0P1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `G0P0` reader - G0P0 analog switch enable"]
pub struct G0P0_R(crate::FieldReader<bool, bool>);
impl G0P0_R {
    pub(crate) fn new(bits: bool) -> Self {
        G0P0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for G0P0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `G0P0` writer - G0P0 analog switch enable"]
pub struct G0P0_W<'a> {
    w: &'a mut W,
}
impl<'a> G0P0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 23 - G5P3 analog switch enable"]
    #[inline(always)]
    pub fn g5p3(&self) -> G5P3_R {
        G5P3_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 22 - G5P2 analog switch enable"]
    #[inline(always)]
    pub fn g5p2(&self) -> G5P2_R {
        G5P2_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 21 - G5P1 analog switch enable"]
    #[inline(always)]
    pub fn g5p1(&self) -> G5P1_R {
        G5P1_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 20 - G5P0 analog switch enable"]
    #[inline(always)]
    pub fn g5p0(&self) -> G5P0_R {
        G5P0_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 19 - G4P3 analog switch enable"]
    #[inline(always)]
    pub fn g4p3(&self) -> G4P3_R {
        G4P3_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 18 - G4P2 analog switch enable"]
    #[inline(always)]
    pub fn g4p2(&self) -> G4P2_R {
        G4P2_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 17 - G4P1 analog switch enable"]
    #[inline(always)]
    pub fn g4p1(&self) -> G4P1_R {
        G4P1_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 16 - G4P0 analog switch enable"]
    #[inline(always)]
    pub fn g4p0(&self) -> G4P0_R {
        G4P0_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 15 - G3P3 analog switch enable"]
    #[inline(always)]
    pub fn g3p3(&self) -> G3P3_R {
        G3P3_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - G3P2 analog switch enable"]
    #[inline(always)]
    pub fn g3p2(&self) -> G3P2_R {
        G3P2_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 13 - G3P1 analog switch enable"]
    #[inline(always)]
    pub fn g3p1(&self) -> G3P1_R {
        G3P1_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 12 - G3P0 analog switch enable"]
    #[inline(always)]
    pub fn g3p0(&self) -> G3P0_R {
        G3P0_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - G2P3 analog switch enable"]
    #[inline(always)]
    pub fn g2p3(&self) -> G2P3_R {
        G2P3_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - G2P2 analog switch enable"]
    #[inline(always)]
    pub fn g2p2(&self) -> G2P2_R {
        G2P2_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - G2P1 analog switch enable"]
    #[inline(always)]
    pub fn g2p1(&self) -> G2P1_R {
        G2P1_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - G2P0 analog switch enable"]
    #[inline(always)]
    pub fn g2p0(&self) -> G2P0_R {
        G2P0_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - G1P3 analog switch enable"]
    #[inline(always)]
    pub fn g1p3(&self) -> G1P3_R {
        G1P3_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - G1P2 analog switch enable"]
    #[inline(always)]
    pub fn g1p2(&self) -> G1P2_R {
        G1P2_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - G1P1 analog switch enable"]
    #[inline(always)]
    pub fn g1p1(&self) -> G1P1_R {
        G1P1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - G1P0 analog switch enable"]
    #[inline(always)]
    pub fn g1p0(&self) -> G1P0_R {
        G1P0_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - G0P3 analog switch enable"]
    #[inline(always)]
    pub fn g0p3(&self) -> G0P3_R {
        G0P3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - G0P2 analog switch enable"]
    #[inline(always)]
    pub fn g0p2(&self) -> G0P2_R {
        G0P2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - G0P1 analog switch enable"]
    #[inline(always)]
    pub fn g0p1(&self) -> G0P1_R {
        G0P1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - G0P0 analog switch enable"]
    #[inline(always)]
    pub fn g0p0(&self) -> G0P0_R {
        G0P0_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 23 - G5P3 analog switch enable"]
    #[inline(always)]
    pub fn g5p3(&mut self) -> G5P3_W {
        G5P3_W { w: self }
    }
    #[doc = "Bit 22 - G5P2 analog switch enable"]
    #[inline(always)]
    pub fn g5p2(&mut self) -> G5P2_W {
        G5P2_W { w: self }
    }
    #[doc = "Bit 21 - G5P1 analog switch enable"]
    #[inline(always)]
    pub fn g5p1(&mut self) -> G5P1_W {
        G5P1_W { w: self }
    }
    #[doc = "Bit 20 - G5P0 analog switch enable"]
    #[inline(always)]
    pub fn g5p0(&mut self) -> G5P0_W {
        G5P0_W { w: self }
    }
    #[doc = "Bit 19 - G4P3 analog switch enable"]
    #[inline(always)]
    pub fn g4p3(&mut self) -> G4P3_W {
        G4P3_W { w: self }
    }
    #[doc = "Bit 18 - G4P2 analog switch enable"]
    #[inline(always)]
    pub fn g4p2(&mut self) -> G4P2_W {
        G4P2_W { w: self }
    }
    #[doc = "Bit 17 - G4P1 analog switch enable"]
    #[inline(always)]
    pub fn g4p1(&mut self) -> G4P1_W {
        G4P1_W { w: self }
    }
    #[doc = "Bit 16 - G4P0 analog switch enable"]
    #[inline(always)]
    pub fn g4p0(&mut self) -> G4P0_W {
        G4P0_W { w: self }
    }
    #[doc = "Bit 15 - G3P3 analog switch enable"]
    #[inline(always)]
    pub fn g3p3(&mut self) -> G3P3_W {
        G3P3_W { w: self }
    }
    #[doc = "Bit 14 - G3P2 analog switch enable"]
    #[inline(always)]
    pub fn g3p2(&mut self) -> G3P2_W {
        G3P2_W { w: self }
    }
    #[doc = "Bit 13 - G3P1 analog switch enable"]
    #[inline(always)]
    pub fn g3p1(&mut self) -> G3P1_W {
        G3P1_W { w: self }
    }
    #[doc = "Bit 12 - G3P0 analog switch enable"]
    #[inline(always)]
    pub fn g3p0(&mut self) -> G3P0_W {
        G3P0_W { w: self }
    }
    #[doc = "Bit 11 - G2P3 analog switch enable"]
    #[inline(always)]
    pub fn g2p3(&mut self) -> G2P3_W {
        G2P3_W { w: self }
    }
    #[doc = "Bit 10 - G2P2 analog switch enable"]
    #[inline(always)]
    pub fn g2p2(&mut self) -> G2P2_W {
        G2P2_W { w: self }
    }
    #[doc = "Bit 9 - G2P1 analog switch enable"]
    #[inline(always)]
    pub fn g2p1(&mut self) -> G2P1_W {
        G2P1_W { w: self }
    }
    #[doc = "Bit 8 - G2P0 analog switch enable"]
    #[inline(always)]
    pub fn g2p0(&mut self) -> G2P0_W {
        G2P0_W { w: self }
    }
    #[doc = "Bit 7 - G1P3 analog switch enable"]
    #[inline(always)]
    pub fn g1p3(&mut self) -> G1P3_W {
        G1P3_W { w: self }
    }
    #[doc = "Bit 6 - G1P2 analog switch enable"]
    #[inline(always)]
    pub fn g1p2(&mut self) -> G1P2_W {
        G1P2_W { w: self }
    }
    #[doc = "Bit 5 - G1P1 analog switch enable"]
    #[inline(always)]
    pub fn g1p1(&mut self) -> G1P1_W {
        G1P1_W { w: self }
    }
    #[doc = "Bit 4 - G1P0 analog switch enable"]
    #[inline(always)]
    pub fn g1p0(&mut self) -> G1P0_W {
        G1P0_W { w: self }
    }
    #[doc = "Bit 3 - G0P3 analog switch enable"]
    #[inline(always)]
    pub fn g0p3(&mut self) -> G0P3_W {
        G0P3_W { w: self }
    }
    #[doc = "Bit 2 - G0P2 analog switch enable"]
    #[inline(always)]
    pub fn g0p2(&mut self) -> G0P2_W {
        G0P2_W { w: self }
    }
    #[doc = "Bit 1 - G0P1 analog switch enable"]
    #[inline(always)]
    pub fn g0p1(&mut self) -> G0P1_W {
        G0P1_W { w: self }
    }
    #[doc = "Bit 0 - G0P0 analog switch enable"]
    #[inline(always)]
    pub fn g0p0(&mut self) -> G0P0_W {
        G0P0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "I/O analog switch register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [asw](index.html) module"]
pub struct ASW_SPEC;
impl crate::RegisterSpec for ASW_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [asw::R](R) reader structure"]
impl crate::Readable for ASW_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [asw::W](W) writer structure"]
impl crate::Writable for ASW_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ASW to value 0"]
impl crate::Resettable for ASW_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
