#[doc = "Register `STAT` reader"]
pub struct R(crate::R<STAT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<STAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<STAT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<STAT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `STAT` writer"]
pub struct W(crate::W<STAT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<STAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<STAT_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<STAT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ONF` reader - SLCD controller on flag"]
pub struct ONF_R(crate::FieldReader<bool, bool>);
impl ONF_R {
    pub(crate) fn new(bits: bool) -> Self {
        ONF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ONF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SOF` reader - Start of frame flag"]
pub struct SOF_R(crate::FieldReader<bool, bool>);
impl SOF_R {
    pub(crate) fn new(bits: bool) -> Self {
        SOF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SOF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UPRF` reader - Update SLCD data request flag"]
pub struct UPRF_R(crate::FieldReader<bool, bool>);
impl UPRF_R {
    pub(crate) fn new(bits: bool) -> Self {
        UPRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UPRF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UPRF` writer - Update SLCD data request flag"]
pub struct UPRF_W<'a> {
    w: &'a mut W,
}
impl<'a> UPRF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `UPDF` reader - Update SLCD data done flag"]
pub struct UPDF_R(crate::FieldReader<bool, bool>);
impl UPDF_R {
    pub(crate) fn new(bits: bool) -> Self {
        UPDF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UPDF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `VRDYF` reader - SLCD voltage ready flag"]
pub struct VRDYF_R(crate::FieldReader<bool, bool>);
impl VRDYF_R {
    pub(crate) fn new(bits: bool) -> Self {
        VRDYF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for VRDYF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SYNF` reader - SLCD_CFG register synchronization flag"]
pub struct SYNF_R(crate::FieldReader<bool, bool>);
impl SYNF_R {
    pub(crate) fn new(bits: bool) -> Self {
        SYNF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SYNF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - SLCD controller on flag"]
    #[inline(always)]
    pub fn onf(&self) -> ONF_R {
        ONF_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Start of frame flag"]
    #[inline(always)]
    pub fn sof(&self) -> SOF_R {
        SOF_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Update SLCD data request flag"]
    #[inline(always)]
    pub fn uprf(&self) -> UPRF_R {
        UPRF_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Update SLCD data done flag"]
    #[inline(always)]
    pub fn updf(&self) -> UPDF_R {
        UPDF_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - SLCD voltage ready flag"]
    #[inline(always)]
    pub fn vrdyf(&self) -> VRDYF_R {
        VRDYF_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - SLCD_CFG register synchronization flag"]
    #[inline(always)]
    pub fn synf(&self) -> SYNF_R {
        SYNF_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - Update SLCD data request flag"]
    #[inline(always)]
    pub fn uprf(&mut self) -> UPRF_W {
        UPRF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SLCD status flag register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [stat](index.html) module"]
pub struct STAT_SPEC;
impl crate::RegisterSpec for STAT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [stat::R](R) reader structure"]
impl crate::Readable for STAT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [stat::W](W) writer structure"]
impl crate::Writable for STAT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets STAT to value 0x20"]
impl crate::Resettable for STAT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x20
    }
}
