#[doc = "Register `SAMCS` reader"]
pub struct R(crate::R<SAMCS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SAMCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SAMCS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SAMCS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SAMCS` writer"]
pub struct W(crate::W<SAMCS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SAMCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SAMCS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SAMCS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "SAM_V interface enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum SAMEN_A {
    #[doc = "0: SAM_V interface disabled"]
    DISABLED = 0,
    #[doc = "1: SAM_V interface enabled"]
    ENABLED = 1,
}
impl From<SAMEN_A> for bool {
    #[inline(always)]
    fn from(variant: SAMEN_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `SAMEN` reader - SAM_V interface enable"]
pub struct SAMEN_R(crate::FieldReader<bool, SAMEN_A>);
impl SAMEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        SAMEN_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> SAMEN_A {
        match self.bits {
            false => SAMEN_A::DISABLED,
            true => SAMEN_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == SAMEN_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == SAMEN_A::ENABLED
    }
}
impl core::ops::Deref for SAMEN_R {
    type Target = crate::FieldReader<bool, SAMEN_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SAMEN` writer - SAM_V interface enable"]
pub struct SAMEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SAMEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SAMEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "SAM_V interface disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(SAMEN_A::DISABLED)
    }
    #[doc = "SAM_V interface enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(SAMEN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "SAM_V interface timeout detect enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum STOEN_A {
    #[doc = "0: SAM_V interface timeout detect disabled"]
    DISABLED = 0,
    #[doc = "1: SAM_V interface timeout detect enabled"]
    ENABLED = 1,
}
impl From<STOEN_A> for bool {
    #[inline(always)]
    fn from(variant: STOEN_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `STOEN` reader - SAM_V interface timeout detect enable"]
pub struct STOEN_R(crate::FieldReader<bool, STOEN_A>);
impl STOEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        STOEN_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> STOEN_A {
        match self.bits {
            false => STOEN_A::DISABLED,
            true => STOEN_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == STOEN_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == STOEN_A::ENABLED
    }
}
impl core::ops::Deref for STOEN_R {
    type Target = crate::FieldReader<bool, STOEN_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STOEN` writer - SAM_V interface timeout detect enable"]
pub struct STOEN_W<'a> {
    w: &'a mut W,
}
impl<'a> STOEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: STOEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "SAM_V interface timeout detect disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(STOEN_A::DISABLED)
    }
    #[doc = "SAM_V interface timeout detect enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(STOEN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Txframe fall interrupt enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum TFFIE_A {
    #[doc = "0: Txframe fall interrupt disabled"]
    DISABLED = 0,
    #[doc = "1: Txframe fall interrupt enabled"]
    ENABLED = 1,
}
impl From<TFFIE_A> for bool {
    #[inline(always)]
    fn from(variant: TFFIE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `TFFIE` reader - Txframe fall interrupt enable"]
pub struct TFFIE_R(crate::FieldReader<bool, TFFIE_A>);
impl TFFIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TFFIE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> TFFIE_A {
        match self.bits {
            false => TFFIE_A::DISABLED,
            true => TFFIE_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == TFFIE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == TFFIE_A::ENABLED
    }
}
impl core::ops::Deref for TFFIE_R {
    type Target = crate::FieldReader<bool, TFFIE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFFIE` writer - Txframe fall interrupt enable"]
pub struct TFFIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TFFIE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TFFIE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Txframe fall interrupt disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(TFFIE_A::DISABLED)
    }
    #[doc = "Txframe fall interrupt enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(TFFIE_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Txframe rise interrupt enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum TFRIE_A {
    #[doc = "0: Txframe rise interrupt disabled"]
    DISABLED = 0,
    #[doc = "1: Txframe rise interrupt enabled"]
    ENABLED = 1,
}
impl From<TFRIE_A> for bool {
    #[inline(always)]
    fn from(variant: TFRIE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `TFRIE` reader - Txframe rise interrupt enable"]
pub struct TFRIE_R(crate::FieldReader<bool, TFRIE_A>);
impl TFRIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TFRIE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> TFRIE_A {
        match self.bits {
            false => TFRIE_A::DISABLED,
            true => TFRIE_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == TFRIE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == TFRIE_A::ENABLED
    }
}
impl core::ops::Deref for TFRIE_R {
    type Target = crate::FieldReader<bool, TFRIE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFRIE` writer - Txframe rise interrupt enable"]
pub struct TFRIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TFRIE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TFRIE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Txframe rise interrupt disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(TFRIE_A::DISABLED)
    }
    #[doc = "Txframe rise interrupt enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(TFRIE_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Rxframe fall interrupt enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum RFFIE_A {
    #[doc = "0: Rxframe fall interrupt disabled"]
    DISABLED = 0,
    #[doc = "1: Rxframe fall interrupt enabled"]
    ENABLED = 1,
}
impl From<RFFIE_A> for bool {
    #[inline(always)]
    fn from(variant: RFFIE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `RFFIE` reader - Rxframe fall interrupt enable"]
pub struct RFFIE_R(crate::FieldReader<bool, RFFIE_A>);
impl RFFIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RFFIE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> RFFIE_A {
        match self.bits {
            false => RFFIE_A::DISABLED,
            true => RFFIE_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == RFFIE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == RFFIE_A::ENABLED
    }
}
impl core::ops::Deref for RFFIE_R {
    type Target = crate::FieldReader<bool, RFFIE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFFIE` writer - Rxframe fall interrupt enable"]
pub struct RFFIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RFFIE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: RFFIE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Rxframe fall interrupt disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(RFFIE_A::DISABLED)
    }
    #[doc = "Rxframe fall interrupt enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(RFFIE_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Rxframe rise interrupt enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum RFRIE_A {
    #[doc = "0: Rxframe rise interrupt disabled"]
    DISABLED = 0,
    #[doc = "1: Rxframe rise interrupt enabled"]
    ENABLED = 1,
}
impl From<RFRIE_A> for bool {
    #[inline(always)]
    fn from(variant: RFRIE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `RFRIE` reader - Rxframe rise interrupt enable"]
pub struct RFRIE_R(crate::FieldReader<bool, RFRIE_A>);
impl RFRIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RFRIE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> RFRIE_A {
        match self.bits {
            false => RFRIE_A::DISABLED,
            true => RFRIE_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == RFRIE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == RFRIE_A::ENABLED
    }
}
impl core::ops::Deref for RFRIE_R {
    type Target = crate::FieldReader<bool, RFRIE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFRIE` writer - Rxframe rise interrupt enable"]
pub struct RFRIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RFRIE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: RFRIE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Rxframe rise interrupt disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(RFRIE_A::DISABLED)
    }
    #[doc = "Rxframe rise interrupt enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(RFRIE_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `TXF` reader - Level of Txframe signal"]
pub struct TXF_R(crate::FieldReader<bool, bool>);
impl TXF_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXF` writer - Level of Txframe signal"]
pub struct TXF_W<'a> {
    w: &'a mut W,
}
impl<'a> TXF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `RXF` reader - Level of Rxframe signal"]
pub struct RXF_R(crate::FieldReader<bool, bool>);
impl RXF_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXF` writer - Level of Rxframe signal"]
pub struct RXF_W<'a> {
    w: &'a mut W,
}
impl<'a> RXF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `TFF` reader - Txframe fall flag"]
pub struct TFF_R(crate::FieldReader<bool, bool>);
impl TFF_R {
    pub(crate) fn new(bits: bool) -> Self {
        TFF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFF` writer - Txframe fall flag"]
pub struct TFF_W<'a> {
    w: &'a mut W,
}
impl<'a> TFF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `TFR` reader - Txframe rise flag"]
pub struct TFR_R(crate::FieldReader<bool, bool>);
impl TFR_R {
    pub(crate) fn new(bits: bool) -> Self {
        TFR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFR` writer - Txframe rise flag"]
pub struct TFR_W<'a> {
    w: &'a mut W,
}
impl<'a> TFR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `RFF` reader - Rxframe fall flag"]
pub struct RFF_R(crate::FieldReader<bool, bool>);
impl RFF_R {
    pub(crate) fn new(bits: bool) -> Self {
        RFF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFF` writer - Rxframe fall flag"]
pub struct RFF_W<'a> {
    w: &'a mut W,
}
impl<'a> RFF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `RFR` reader - Rxframe rise flag"]
pub struct RFR_R(crate::FieldReader<bool, bool>);
impl RFR_R {
    pub(crate) fn new(bits: bool) -> Self {
        RFR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFR` writer - Rxframe rise flag"]
pub struct RFR_W<'a> {
    w: &'a mut W,
}
impl<'a> RFR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - SAM_V interface enable"]
    #[inline(always)]
    pub fn samen(&self) -> SAMEN_R {
        SAMEN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - SAM_V interface timeout detect enable"]
    #[inline(always)]
    pub fn stoen(&self) -> STOEN_R {
        STOEN_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Txframe fall interrupt enable"]
    #[inline(always)]
    pub fn tffie(&self) -> TFFIE_R {
        TFFIE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Txframe rise interrupt enable"]
    #[inline(always)]
    pub fn tfrie(&self) -> TFRIE_R {
        TFRIE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Rxframe fall interrupt enable"]
    #[inline(always)]
    pub fn rffie(&self) -> RFFIE_R {
        RFFIE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Rxframe rise interrupt enable"]
    #[inline(always)]
    pub fn rfrie(&self) -> RFRIE_R {
        RFRIE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Level of Txframe signal"]
    #[inline(always)]
    pub fn txf(&self) -> TXF_R {
        TXF_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Level of Rxframe signal"]
    #[inline(always)]
    pub fn rxf(&self) -> RXF_R {
        RXF_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Txframe fall flag"]
    #[inline(always)]
    pub fn tff(&self) -> TFF_R {
        TFF_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Txframe rise flag"]
    #[inline(always)]
    pub fn tfr(&self) -> TFR_R {
        TFR_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Rxframe fall flag"]
    #[inline(always)]
    pub fn rff(&self) -> RFF_R {
        RFF_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Rxframe rise flag"]
    #[inline(always)]
    pub fn rfr(&self) -> RFR_R {
        RFR_R::new(((self.bits >> 15) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - SAM_V interface enable"]
    #[inline(always)]
    pub fn samen(&mut self) -> SAMEN_W {
        SAMEN_W { w: self }
    }
    #[doc = "Bit 1 - SAM_V interface timeout detect enable"]
    #[inline(always)]
    pub fn stoen(&mut self) -> STOEN_W {
        STOEN_W { w: self }
    }
    #[doc = "Bit 4 - Txframe fall interrupt enable"]
    #[inline(always)]
    pub fn tffie(&mut self) -> TFFIE_W {
        TFFIE_W { w: self }
    }
    #[doc = "Bit 5 - Txframe rise interrupt enable"]
    #[inline(always)]
    pub fn tfrie(&mut self) -> TFRIE_W {
        TFRIE_W { w: self }
    }
    #[doc = "Bit 6 - Rxframe fall interrupt enable"]
    #[inline(always)]
    pub fn rffie(&mut self) -> RFFIE_W {
        RFFIE_W { w: self }
    }
    #[doc = "Bit 7 - Rxframe rise interrupt enable"]
    #[inline(always)]
    pub fn rfrie(&mut self) -> RFRIE_W {
        RFRIE_W { w: self }
    }
    #[doc = "Bit 8 - Level of Txframe signal"]
    #[inline(always)]
    pub fn txf(&mut self) -> TXF_W {
        TXF_W { w: self }
    }
    #[doc = "Bit 9 - Level of Rxframe signal"]
    #[inline(always)]
    pub fn rxf(&mut self) -> RXF_W {
        RXF_W { w: self }
    }
    #[doc = "Bit 12 - Txframe fall flag"]
    #[inline(always)]
    pub fn tff(&mut self) -> TFF_W {
        TFF_W { w: self }
    }
    #[doc = "Bit 13 - Txframe rise flag"]
    #[inline(always)]
    pub fn tfr(&mut self) -> TFR_W {
        TFR_W { w: self }
    }
    #[doc = "Bit 14 - Rxframe fall flag"]
    #[inline(always)]
    pub fn rff(&mut self) -> RFF_W {
        RFF_W { w: self }
    }
    #[doc = "Bit 15 - Rxframe rise flag"]
    #[inline(always)]
    pub fn rfr(&mut self) -> RFR_W {
        RFR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SAM Controland status register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [samcs](index.html) module"]
pub struct SAMCS_SPEC;
impl crate::RegisterSpec for SAMCS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [samcs::R](R) reader structure"]
impl crate::Readable for SAMCS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [samcs::W](W) writer structure"]
impl crate::Writable for SAMCS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SAMCS to value 0"]
impl crate::Resettable for SAMCS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
