#[doc = "Register `TG` writer"]
pub struct W(crate::W<TG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Port toggle bit 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum TG0_AW {
    #[doc = "1: Toggles the corresponding OCTLx bit"]
    TOGGLE = 1,
}
impl From<TG0_AW> for bool {
    #[inline(always)]
    fn from(variant: TG0_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `TG0` writer - Port toggle bit 0"]
pub struct TG0_W<'a> {
    w: &'a mut W,
}
impl<'a> TG0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG0_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG0_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Port toggle bit 1"]
pub type TG1_AW = TG0_AW;
#[doc = "Field `TG1` writer - Port toggle bit 1"]
pub struct TG1_W<'a> {
    w: &'a mut W,
}
impl<'a> TG1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG1_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG1_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Port toggle bit 2"]
pub type TG2_AW = TG0_AW;
#[doc = "Field `TG2` writer - Port toggle bit 2"]
pub struct TG2_W<'a> {
    w: &'a mut W,
}
impl<'a> TG2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG2_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG2_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Port toggle bit 3"]
pub type TG3_AW = TG0_AW;
#[doc = "Field `TG3` writer - Port toggle bit 3"]
pub struct TG3_W<'a> {
    w: &'a mut W,
}
impl<'a> TG3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG3_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG3_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Port toggle bit 4"]
pub type TG4_AW = TG0_AW;
#[doc = "Field `TG4` writer - Port toggle bit 4"]
pub struct TG4_W<'a> {
    w: &'a mut W,
}
impl<'a> TG4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG4_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG4_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Port toggle bit 5"]
pub type TG5_AW = TG0_AW;
#[doc = "Field `TG5` writer - Port toggle bit 5"]
pub struct TG5_W<'a> {
    w: &'a mut W,
}
impl<'a> TG5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG5_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG5_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Port toggle bit 6"]
pub type TG6_AW = TG0_AW;
#[doc = "Field `TG6` writer - Port toggle bit 6"]
pub struct TG6_W<'a> {
    w: &'a mut W,
}
impl<'a> TG6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG6_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG6_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Port toggle bit 7"]
pub type TG7_AW = TG0_AW;
#[doc = "Field `TG7` writer - Port toggle bit 7"]
pub struct TG7_W<'a> {
    w: &'a mut W,
}
impl<'a> TG7_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG7_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG7_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Port toggle bit 8"]
pub type TG8_AW = TG0_AW;
#[doc = "Field `TG8` writer - Port toggle bit 8"]
pub struct TG8_W<'a> {
    w: &'a mut W,
}
impl<'a> TG8_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG8_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG8_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Port toggle bit 9"]
pub type TG9_AW = TG0_AW;
#[doc = "Field `TG9` writer - Port toggle bit 9"]
pub struct TG9_W<'a> {
    w: &'a mut W,
}
impl<'a> TG9_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG9_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG9_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Port toggle bit 10"]
pub type TG10_AW = TG0_AW;
#[doc = "Field `TG10` writer - Port toggle bit 10"]
pub struct TG10_W<'a> {
    w: &'a mut W,
}
impl<'a> TG10_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG10_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG10_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Port toggle bit 11"]
pub type TG11_AW = TG0_AW;
#[doc = "Field `TG11` writer - Port toggle bit 11"]
pub struct TG11_W<'a> {
    w: &'a mut W,
}
impl<'a> TG11_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG11_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG11_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Port toggle bit 12"]
pub type TG12_AW = TG0_AW;
#[doc = "Field `TG12` writer - Port toggle bit 12"]
pub struct TG12_W<'a> {
    w: &'a mut W,
}
impl<'a> TG12_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG12_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG12_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Port toggle bit 13"]
pub type TG13_AW = TG0_AW;
#[doc = "Field `TG13` writer - Port toggle bit 13"]
pub struct TG13_W<'a> {
    w: &'a mut W,
}
impl<'a> TG13_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG13_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG13_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Port toggle bit 14"]
pub type TG14_AW = TG0_AW;
#[doc = "Field `TG14` writer - Port toggle bit 14"]
pub struct TG14_W<'a> {
    w: &'a mut W,
}
impl<'a> TG14_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG14_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG14_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Port toggle bit 15"]
pub type TG15_AW = TG0_AW;
#[doc = "Field `TG15` writer - Port toggle bit 15"]
pub struct TG15_W<'a> {
    w: &'a mut W,
}
impl<'a> TG15_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TG15_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Toggles the corresponding OCTLx bit"]
    #[inline(always)]
    pub fn toggle(self) -> &'a mut W {
        self.variant(TG15_AW::TOGGLE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
impl W {
    #[doc = "Bit 0 - Port toggle bit 0"]
    #[inline(always)]
    pub fn tg0(&mut self) -> TG0_W {
        TG0_W { w: self }
    }
    #[doc = "Bit 1 - Port toggle bit 1"]
    #[inline(always)]
    pub fn tg1(&mut self) -> TG1_W {
        TG1_W { w: self }
    }
    #[doc = "Bit 2 - Port toggle bit 2"]
    #[inline(always)]
    pub fn tg2(&mut self) -> TG2_W {
        TG2_W { w: self }
    }
    #[doc = "Bit 3 - Port toggle bit 3"]
    #[inline(always)]
    pub fn tg3(&mut self) -> TG3_W {
        TG3_W { w: self }
    }
    #[doc = "Bit 4 - Port toggle bit 4"]
    #[inline(always)]
    pub fn tg4(&mut self) -> TG4_W {
        TG4_W { w: self }
    }
    #[doc = "Bit 5 - Port toggle bit 5"]
    #[inline(always)]
    pub fn tg5(&mut self) -> TG5_W {
        TG5_W { w: self }
    }
    #[doc = "Bit 6 - Port toggle bit 6"]
    #[inline(always)]
    pub fn tg6(&mut self) -> TG6_W {
        TG6_W { w: self }
    }
    #[doc = "Bit 7 - Port toggle bit 7"]
    #[inline(always)]
    pub fn tg7(&mut self) -> TG7_W {
        TG7_W { w: self }
    }
    #[doc = "Bit 8 - Port toggle bit 8"]
    #[inline(always)]
    pub fn tg8(&mut self) -> TG8_W {
        TG8_W { w: self }
    }
    #[doc = "Bit 9 - Port toggle bit 9"]
    #[inline(always)]
    pub fn tg9(&mut self) -> TG9_W {
        TG9_W { w: self }
    }
    #[doc = "Bit 10 - Port toggle bit 10"]
    #[inline(always)]
    pub fn tg10(&mut self) -> TG10_W {
        TG10_W { w: self }
    }
    #[doc = "Bit 11 - Port toggle bit 11"]
    #[inline(always)]
    pub fn tg11(&mut self) -> TG11_W {
        TG11_W { w: self }
    }
    #[doc = "Bit 12 - Port toggle bit 12"]
    #[inline(always)]
    pub fn tg12(&mut self) -> TG12_W {
        TG12_W { w: self }
    }
    #[doc = "Bit 13 - Port toggle bit 13"]
    #[inline(always)]
    pub fn tg13(&mut self) -> TG13_W {
        TG13_W { w: self }
    }
    #[doc = "Bit 14 - Port toggle bit 14"]
    #[inline(always)]
    pub fn tg14(&mut self) -> TG14_W {
        TG14_W { w: self }
    }
    #[doc = "Bit 15 - Port toggle bit 15"]
    #[inline(always)]
    pub fn tg15(&mut self) -> TG15_W {
        TG15_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Port bit toggle register\n\nThis register you can [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tg](index.html) module"]
pub struct TG_SPEC;
impl crate::RegisterSpec for TG_SPEC {
    type Ux = u32;
}
#[doc = "`write(|w| ..)` method takes [tg::W](W) writer structure"]
impl crate::Writable for TG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TG to value 0"]
impl crate::Resettable for TG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
