#[doc = "Register `WS` reader"]
pub struct R(crate::R<WS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<WS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<WS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<WS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `WS` writer"]
pub struct W(crate::W<WS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<WS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<WS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<WS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Wait state counter register\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum WSCNT_A {
    #[doc = "0: 0 wait states added"]
    WS0 = 0,
    #[doc = "1: 1 wait state added"]
    WS1 = 1,
    #[doc = "2: 2 wait states added"]
    WS2 = 2,
}
impl From<WSCNT_A> for u8 {
    #[inline(always)]
    fn from(variant: WSCNT_A) -> Self {
        variant as _
    }
}
#[doc = "Field `WSCNT` reader - Wait state counter register"]
pub struct WSCNT_R(crate::FieldReader<u8, WSCNT_A>);
impl WSCNT_R {
    pub(crate) fn new(bits: u8) -> Self {
        WSCNT_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<WSCNT_A> {
        match self.bits {
            0 => Some(WSCNT_A::WS0),
            1 => Some(WSCNT_A::WS1),
            2 => Some(WSCNT_A::WS2),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `WS0`"]
    #[inline(always)]
    pub fn is_ws0(&self) -> bool {
        **self == WSCNT_A::WS0
    }
    #[doc = "Checks if the value of the field is `WS1`"]
    #[inline(always)]
    pub fn is_ws1(&self) -> bool {
        **self == WSCNT_A::WS1
    }
    #[doc = "Checks if the value of the field is `WS2`"]
    #[inline(always)]
    pub fn is_ws2(&self) -> bool {
        **self == WSCNT_A::WS2
    }
}
impl core::ops::Deref for WSCNT_R {
    type Target = crate::FieldReader<u8, WSCNT_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WSCNT` writer - Wait state counter register"]
pub struct WSCNT_W<'a> {
    w: &'a mut W,
}
impl<'a> WSCNT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WSCNT_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "0 wait states added"]
    #[inline(always)]
    pub fn ws0(self) -> &'a mut W {
        self.variant(WSCNT_A::WS0)
    }
    #[doc = "1 wait state added"]
    #[inline(always)]
    pub fn ws1(self) -> &'a mut W {
        self.variant(WSCNT_A::WS1)
    }
    #[doc = "2 wait states added"]
    #[inline(always)]
    pub fn ws2(self) -> &'a mut W {
        self.variant(WSCNT_A::WS2)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u32 & 0x07);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Wait state counter register"]
    #[inline(always)]
    pub fn wscnt(&self) -> WSCNT_R {
        WSCNT_R::new((self.bits & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bits 0:2 - Wait state counter register"]
    #[inline(always)]
    pub fn wscnt(&mut self) -> WSCNT_W {
        WSCNT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Wait state register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ws](index.html) module"]
pub struct WS_SPEC;
impl crate::RegisterSpec for WS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [ws::R](R) reader structure"]
impl crate::Readable for WS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ws::W](W) writer structure"]
impl crate::Writable for WS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets WS to value 0"]
impl crate::Resettable for WS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
