#[doc = "Register `OPA_CTL` reader"]
pub struct R(crate::R<OPA_CTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<OPA_CTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<OPA_CTL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<OPA_CTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `OPA_CTL` writer"]
pub struct W(crate::W<OPA_CTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<OPA_CTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<OPA_CTL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<OPA_CTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "OPA0 power down\n\nValue on reset: 1"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum OPA0PD_A {
    #[doc = "0: OPA enabled"]
    ENABLED = 0,
    #[doc = "1: OPA disabled"]
    DISABLED = 1,
}
impl From<OPA0PD_A> for bool {
    #[inline(always)]
    fn from(variant: OPA0PD_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `OPA0PD` reader - OPA0 power down"]
pub struct OPA0PD_R(crate::FieldReader<bool, OPA0PD_A>);
impl OPA0PD_R {
    pub(crate) fn new(bits: bool) -> Self {
        OPA0PD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> OPA0PD_A {
        match self.bits {
            false => OPA0PD_A::ENABLED,
            true => OPA0PD_A::DISABLED,
        }
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == OPA0PD_A::ENABLED
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == OPA0PD_A::DISABLED
    }
}
impl core::ops::Deref for OPA0PD_R {
    type Target = crate::FieldReader<bool, OPA0PD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OPA0PD` writer - OPA0 power down"]
pub struct OPA0PD_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA0PD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA0PD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "OPA enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA0PD_A::ENABLED)
    }
    #[doc = "OPA disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA0PD_A::DISABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "T3 switch enable for OPA0"]
pub type T3OPA0_A = S1OPA0_A;
#[doc = "Field `T3OPA0` reader - T3 switch enable for OPA0"]
pub type T3OPA0_R = S1OPA0_R;
#[doc = "Field `T3OPA0` writer - T3 switch enable for OPA0"]
pub struct T3OPA0_W<'a> {
    w: &'a mut W,
}
impl<'a> T3OPA0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: T3OPA0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(T3OPA0_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(T3OPA0_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "S1 switch enable for OPA0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum S1OPA0_A {
    #[doc = "0: Switch opened"]
    OPENED = 0,
    #[doc = "1: Switch closed"]
    CLOSED = 1,
}
impl From<S1OPA0_A> for bool {
    #[inline(always)]
    fn from(variant: S1OPA0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `S1OPA0` reader - S1 switch enable for OPA0"]
pub struct S1OPA0_R(crate::FieldReader<bool, S1OPA0_A>);
impl S1OPA0_R {
    pub(crate) fn new(bits: bool) -> Self {
        S1OPA0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> S1OPA0_A {
        match self.bits {
            false => S1OPA0_A::OPENED,
            true => S1OPA0_A::CLOSED,
        }
    }
    #[doc = "Checks if the value of the field is `OPENED`"]
    #[inline(always)]
    pub fn is_opened(&self) -> bool {
        **self == S1OPA0_A::OPENED
    }
    #[doc = "Checks if the value of the field is `CLOSED`"]
    #[inline(always)]
    pub fn is_closed(&self) -> bool {
        **self == S1OPA0_A::CLOSED
    }
}
impl core::ops::Deref for S1OPA0_R {
    type Target = crate::FieldReader<bool, S1OPA0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `S1OPA0` writer - S1 switch enable for OPA0"]
pub struct S1OPA0_W<'a> {
    w: &'a mut W,
}
impl<'a> S1OPA0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: S1OPA0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(S1OPA0_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(S1OPA0_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "S2 switch enable for OPA0"]
pub type S2OPA0_A = S1OPA0_A;
#[doc = "Field `S2OPA0` reader - S2 switch enable for OPA0"]
pub type S2OPA0_R = S1OPA0_R;
#[doc = "Field `S2OPA0` writer - S2 switch enable for OPA0"]
pub struct S2OPA0_W<'a> {
    w: &'a mut W,
}
impl<'a> S2OPA0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: S2OPA0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(S2OPA0_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(S2OPA0_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "S3 switch enable for OPA0"]
pub type S3OPA0_A = S1OPA0_A;
#[doc = "Field `S3OPA0` reader - S3 switch enable for OPA0"]
pub type S3OPA0_R = S1OPA0_R;
#[doc = "Field `S3OPA0` writer - S3 switch enable for OPA0"]
pub struct S3OPA0_W<'a> {
    w: &'a mut W,
}
impl<'a> S3OPA0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: S3OPA0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(S3OPA0_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(S3OPA0_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "OPA0 offset calibration for P diff\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum OPA0CAL_L_A {
    #[doc = "0: Offset calibration for P diff disabled"]
    DISABLED = 0,
    #[doc = "1: Offset calibration for P diff enabled"]
    ENABLED = 1,
}
impl From<OPA0CAL_L_A> for bool {
    #[inline(always)]
    fn from(variant: OPA0CAL_L_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `OPA0CAL_L` reader - OPA0 offset calibration for P diff"]
pub struct OPA0CAL_L_R(crate::FieldReader<bool, OPA0CAL_L_A>);
impl OPA0CAL_L_R {
    pub(crate) fn new(bits: bool) -> Self {
        OPA0CAL_L_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> OPA0CAL_L_A {
        match self.bits {
            false => OPA0CAL_L_A::DISABLED,
            true => OPA0CAL_L_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == OPA0CAL_L_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == OPA0CAL_L_A::ENABLED
    }
}
impl core::ops::Deref for OPA0CAL_L_R {
    type Target = crate::FieldReader<bool, OPA0CAL_L_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OPA0CAL_L` writer - OPA0 offset calibration for P diff"]
pub struct OPA0CAL_L_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA0CAL_L_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA0CAL_L_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Offset calibration for P diff disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA0CAL_L_A::DISABLED)
    }
    #[doc = "Offset calibration for P diff enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA0CAL_L_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "OPA0 offset calibration for N diff\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum OPA0CAL_H_A {
    #[doc = "0: Offset calibration for N diff disabled"]
    DISABLED = 0,
    #[doc = "1: Offset calibration for N diff enabled"]
    ENABLED = 1,
}
impl From<OPA0CAL_H_A> for bool {
    #[inline(always)]
    fn from(variant: OPA0CAL_H_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `OPA0CAL_H` reader - OPA0 offset calibration for N diff"]
pub struct OPA0CAL_H_R(crate::FieldReader<bool, OPA0CAL_H_A>);
impl OPA0CAL_H_R {
    pub(crate) fn new(bits: bool) -> Self {
        OPA0CAL_H_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> OPA0CAL_H_A {
        match self.bits {
            false => OPA0CAL_H_A::DISABLED,
            true => OPA0CAL_H_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == OPA0CAL_H_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == OPA0CAL_H_A::ENABLED
    }
}
impl core::ops::Deref for OPA0CAL_H_R {
    type Target = crate::FieldReader<bool, OPA0CAL_H_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OPA0CAL_H` writer - OPA0 offset calibration for N diff"]
pub struct OPA0CAL_H_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA0CAL_H_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA0CAL_H_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Offset calibration for N diff disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA0CAL_H_A::DISABLED)
    }
    #[doc = "Offset calibration for N diff enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA0CAL_H_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "OPA0 low power mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum OPA0LPM_A {
    #[doc = "0: Low power mode disabled"]
    DISABLED = 0,
    #[doc = "1: Low power mode enabled"]
    ENABLED = 1,
}
impl From<OPA0LPM_A> for bool {
    #[inline(always)]
    fn from(variant: OPA0LPM_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `OPA0LPM` reader - OPA0 low power mode"]
pub struct OPA0LPM_R(crate::FieldReader<bool, OPA0LPM_A>);
impl OPA0LPM_R {
    pub(crate) fn new(bits: bool) -> Self {
        OPA0LPM_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> OPA0LPM_A {
        match self.bits {
            false => OPA0LPM_A::DISABLED,
            true => OPA0LPM_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == OPA0LPM_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == OPA0LPM_A::ENABLED
    }
}
impl core::ops::Deref for OPA0LPM_R {
    type Target = crate::FieldReader<bool, OPA0LPM_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OPA0LPM` writer - OPA0 low power mode"]
pub struct OPA0LPM_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA0LPM_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA0LPM_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Low power mode disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA0LPM_A::DISABLED)
    }
    #[doc = "Low power mode enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA0LPM_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "OPA1 power down"]
pub type OPA1PD_A = OPA0PD_A;
#[doc = "Field `OPA1PD` reader - OPA1 power down"]
pub type OPA1PD_R = OPA0PD_R;
#[doc = "Field `OPA1PD` writer - OPA1 power down"]
pub struct OPA1PD_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA1PD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA1PD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "OPA enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA1PD_A::ENABLED)
    }
    #[doc = "OPA disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA1PD_A::DISABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "T3 switch enable for OPA1"]
pub type T3OPA1_A = S1OPA0_A;
#[doc = "Field `T3OPA1` reader - T3 switch enable for OPA1"]
pub type T3OPA1_R = S1OPA0_R;
#[doc = "Field `T3OPA1` writer - T3 switch enable for OPA1"]
pub struct T3OPA1_W<'a> {
    w: &'a mut W,
}
impl<'a> T3OPA1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: T3OPA1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(T3OPA1_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(T3OPA1_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "S1 switch enable for OPA1"]
pub type S1OPA1_A = S1OPA0_A;
#[doc = "Field `S1OPA1` reader - S1 switch enable for OPA1"]
pub type S1OPA1_R = S1OPA0_R;
#[doc = "Field `S1OPA1` writer - S1 switch enable for OPA1"]
pub struct S1OPA1_W<'a> {
    w: &'a mut W,
}
impl<'a> S1OPA1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: S1OPA1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(S1OPA1_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(S1OPA1_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "S2 switch enable for OPA1"]
pub type S2OPA1_A = S1OPA0_A;
#[doc = "Field `S2OPA1` reader - S2 switch enable for OPA1"]
pub type S2OPA1_R = S1OPA0_R;
#[doc = "Field `S2OPA1` writer - S2 switch enable for OPA1"]
pub struct S2OPA1_W<'a> {
    w: &'a mut W,
}
impl<'a> S2OPA1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: S2OPA1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(S2OPA1_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(S2OPA1_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "S3 switch enable for OPA1"]
pub type S3OPA1_A = S1OPA0_A;
#[doc = "Field `S3OPA1` reader - S3 switch enable for OPA1"]
pub type S3OPA1_R = S1OPA0_R;
#[doc = "Field `S3OPA1` writer - S3 switch enable for OPA1"]
pub struct S3OPA1_W<'a> {
    w: &'a mut W,
}
impl<'a> S3OPA1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: S3OPA1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(S3OPA1_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(S3OPA1_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "OPA1 offset calibration for P diff"]
pub type OPA1CAL_L_A = OPA0CAL_L_A;
#[doc = "Field `OPA1CAL_L` reader - OPA1 offset calibration for P diff"]
pub type OPA1CAL_L_R = OPA0CAL_L_R;
#[doc = "Field `OPA1CAL_L` writer - OPA1 offset calibration for P diff"]
pub struct OPA1CAL_L_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA1CAL_L_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA1CAL_L_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Offset calibration for P diff disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA1CAL_L_A::DISABLED)
    }
    #[doc = "Offset calibration for P diff enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA1CAL_L_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "OPA1 offset calibration for N diff"]
pub type OPA1CAL_H_A = OPA0CAL_H_A;
#[doc = "Field `OPA1CAL_H` reader - OPA1 offset calibration for N diff"]
pub type OPA1CAL_H_R = OPA0CAL_H_R;
#[doc = "Field `OPA1CAL_H` writer - OPA1 offset calibration for N diff"]
pub struct OPA1CAL_H_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA1CAL_H_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA1CAL_H_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Offset calibration for N diff disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA1CAL_H_A::DISABLED)
    }
    #[doc = "Offset calibration for N diff enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA1CAL_H_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "OPA1 low power mode"]
pub type OPA1LPM_A = OPA0LPM_A;
#[doc = "Field `OPA1LPM` reader - OPA1 low power mode"]
pub type OPA1LPM_R = OPA0LPM_R;
#[doc = "Field `OPA1LPM` writer - OPA1 low power mode"]
pub struct OPA1LPM_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA1LPM_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA1LPM_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Low power mode disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA1LPM_A::DISABLED)
    }
    #[doc = "Low power mode enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA1LPM_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "OPA2 power down"]
pub type OPA2PD_A = OPA0PD_A;
#[doc = "Field `OPA2PD` reader - OPA2 power down"]
pub type OPA2PD_R = OPA0PD_R;
#[doc = "Field `OPA2PD` writer - OPA2 power down"]
pub struct OPA2PD_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA2PD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA2PD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "OPA enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA2PD_A::ENABLED)
    }
    #[doc = "OPA disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA2PD_A::DISABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "T3 switch enable for OPA2"]
pub type T3OPA2_A = S1OPA0_A;
#[doc = "Field `T3OPA2` reader - T3 switch enable for OPA2"]
pub type T3OPA2_R = S1OPA0_R;
#[doc = "Field `T3OPA2` writer - T3 switch enable for OPA2"]
pub struct T3OPA2_W<'a> {
    w: &'a mut W,
}
impl<'a> T3OPA2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: T3OPA2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(T3OPA2_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(T3OPA2_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "S1 switch enable for OPA2"]
pub type S1OPA2_A = S1OPA0_A;
#[doc = "Field `S1OPA2` reader - S1 switch enable for OPA2"]
pub type S1OPA2_R = S1OPA0_R;
#[doc = "Field `S1OPA2` writer - S1 switch enable for OPA2"]
pub struct S1OPA2_W<'a> {
    w: &'a mut W,
}
impl<'a> S1OPA2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: S1OPA2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(S1OPA2_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(S1OPA2_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "S2 switch enable for OPA2"]
pub type S2OPA2_A = S1OPA0_A;
#[doc = "Field `S2OPA2` reader - S2 switch enable for OPA2"]
pub type S2OPA2_R = S1OPA0_R;
#[doc = "Field `S2OPA2` writer - S2 switch enable for OPA2"]
pub struct S2OPA2_W<'a> {
    w: &'a mut W,
}
impl<'a> S2OPA2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: S2OPA2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(S2OPA2_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(S2OPA2_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "S3 switch enable for OPA2"]
pub type S3OPA2_A = S1OPA0_A;
#[doc = "Field `S3OPA2` reader - S3 switch enable for OPA2"]
pub type S3OPA2_R = S1OPA0_R;
#[doc = "Field `S3OPA2` writer - S3 switch enable for OPA2"]
pub struct S3OPA2_W<'a> {
    w: &'a mut W,
}
impl<'a> S3OPA2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: S3OPA2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(S3OPA2_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(S3OPA2_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "OPA2 offset calibration for P diff"]
pub type OPA2CAL_L_A = OPA0CAL_L_A;
#[doc = "Field `OPA2CAL_L` reader - OPA2 offset calibration for P diff"]
pub type OPA2CAL_L_R = OPA0CAL_L_R;
#[doc = "Field `OPA2CAL_L` writer - OPA2 offset calibration for P diff"]
pub struct OPA2CAL_L_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA2CAL_L_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA2CAL_L_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Offset calibration for P diff disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA2CAL_L_A::DISABLED)
    }
    #[doc = "Offset calibration for P diff enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA2CAL_L_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "OPA2 offset calibration for N diff"]
pub type OPA2CAL_H_A = OPA0CAL_H_A;
#[doc = "Field `OPA2CAL_H` reader - OPA2 offset calibration for N diff"]
pub type OPA2CAL_H_R = OPA0CAL_H_R;
#[doc = "Field `OPA2CAL_H` writer - OPA2 offset calibration for N diff"]
pub struct OPA2CAL_H_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA2CAL_H_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA2CAL_H_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Offset calibration for N diff disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA2CAL_H_A::DISABLED)
    }
    #[doc = "Offset calibration for N diff enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA2CAL_H_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "OPA2 low power mode"]
pub type OPA2LPM_A = OPA0LPM_A;
#[doc = "Field `OPA2LPM` reader - OPA2 low power mode"]
pub type OPA2LPM_R = OPA0LPM_R;
#[doc = "Field `OPA2LPM` writer - OPA2 low power mode"]
pub struct OPA2LPM_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA2LPM_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA2LPM_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Low power mode disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(OPA2LPM_A::DISABLED)
    }
    #[doc = "Low power mode enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(OPA2LPM_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "S4 switch enable for OPA1"]
pub type S4OPA1_A = S1OPA0_A;
#[doc = "Field `S4OPA1` reader - S4 switch enable for OPA1"]
pub type S4OPA1_R = S1OPA0_R;
#[doc = "Field `S4OPA1` writer - S4 switch enable for OPA1"]
pub struct S4OPA1_W<'a> {
    w: &'a mut W,
}
impl<'a> S4OPA1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: S4OPA1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch opened"]
    #[inline(always)]
    pub fn opened(self) -> &'a mut W {
        self.variant(S4OPA1_A::OPENED)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(S4OPA1_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
#[doc = "Power supply range\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum OPA_RANGE_A {
    #[doc = "0: Low range, < 3.3 V"]
    LOW = 0,
    #[doc = "1: High range, > 3.3 V"]
    HIGH = 1,
}
impl From<OPA_RANGE_A> for bool {
    #[inline(always)]
    fn from(variant: OPA_RANGE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `OPA_RANGE` reader - Power supply range"]
pub struct OPA_RANGE_R(crate::FieldReader<bool, OPA_RANGE_A>);
impl OPA_RANGE_R {
    pub(crate) fn new(bits: bool) -> Self {
        OPA_RANGE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> OPA_RANGE_A {
        match self.bits {
            false => OPA_RANGE_A::LOW,
            true => OPA_RANGE_A::HIGH,
        }
    }
    #[doc = "Checks if the value of the field is `LOW`"]
    #[inline(always)]
    pub fn is_low(&self) -> bool {
        **self == OPA_RANGE_A::LOW
    }
    #[doc = "Checks if the value of the field is `HIGH`"]
    #[inline(always)]
    pub fn is_high(&self) -> bool {
        **self == OPA_RANGE_A::HIGH
    }
}
impl core::ops::Deref for OPA_RANGE_R {
    type Target = crate::FieldReader<bool, OPA_RANGE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OPA_RANGE` writer - Power supply range"]
pub struct OPA_RANGE_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA_RANGE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA_RANGE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Low range, < 3.3 V"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OPA_RANGE_A::LOW)
    }
    #[doc = "High range, > 3.3 V"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OPA_RANGE_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 28)) | ((value as u32 & 0x01) << 28);
        self.w
    }
}
#[doc = "OPA0 calibration output\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum OPA0CALOUT_A {
    #[doc = "0: The offset is not trimmed"]
    NOTTRIMMED = 0,
    #[doc = "1: The offset is trimmed, in calibration mode"]
    TRIMMED = 1,
}
impl From<OPA0CALOUT_A> for bool {
    #[inline(always)]
    fn from(variant: OPA0CALOUT_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `OPA0CALOUT` reader - OPA0 calibration output"]
pub struct OPA0CALOUT_R(crate::FieldReader<bool, OPA0CALOUT_A>);
impl OPA0CALOUT_R {
    pub(crate) fn new(bits: bool) -> Self {
        OPA0CALOUT_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> OPA0CALOUT_A {
        match self.bits {
            false => OPA0CALOUT_A::NOTTRIMMED,
            true => OPA0CALOUT_A::TRIMMED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTTRIMMED`"]
    #[inline(always)]
    pub fn is_not_trimmed(&self) -> bool {
        **self == OPA0CALOUT_A::NOTTRIMMED
    }
    #[doc = "Checks if the value of the field is `TRIMMED`"]
    #[inline(always)]
    pub fn is_trimmed(&self) -> bool {
        **self == OPA0CALOUT_A::TRIMMED
    }
}
impl core::ops::Deref for OPA0CALOUT_R {
    type Target = crate::FieldReader<bool, OPA0CALOUT_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OPA0CALOUT` writer - OPA0 calibration output"]
pub struct OPA0CALOUT_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA0CALOUT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA0CALOUT_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "The offset is not trimmed"]
    #[inline(always)]
    pub fn not_trimmed(self) -> &'a mut W {
        self.variant(OPA0CALOUT_A::NOTTRIMMED)
    }
    #[doc = "The offset is trimmed, in calibration mode"]
    #[inline(always)]
    pub fn trimmed(self) -> &'a mut W {
        self.variant(OPA0CALOUT_A::TRIMMED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 29)) | ((value as u32 & 0x01) << 29);
        self.w
    }
}
#[doc = "OPA1 calibration output"]
pub type OPA1CALOUT_A = OPA0CALOUT_A;
#[doc = "Field `OPA1CALOUT` reader - OPA1 calibration output"]
pub type OPA1CALOUT_R = OPA0CALOUT_R;
#[doc = "Field `OPA1CALOUT` writer - OPA1 calibration output"]
pub struct OPA1CALOUT_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA1CALOUT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA1CALOUT_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "The offset is not trimmed"]
    #[inline(always)]
    pub fn not_trimmed(self) -> &'a mut W {
        self.variant(OPA1CALOUT_A::NOTTRIMMED)
    }
    #[doc = "The offset is trimmed, in calibration mode"]
    #[inline(always)]
    pub fn trimmed(self) -> &'a mut W {
        self.variant(OPA1CALOUT_A::TRIMMED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 30)) | ((value as u32 & 0x01) << 30);
        self.w
    }
}
#[doc = "OPA2 calibration output"]
pub type OPA2CALOUT_A = OPA0CALOUT_A;
#[doc = "Field `OPA2CALOUT` reader - OPA2 calibration output"]
pub type OPA2CALOUT_R = OPA0CALOUT_R;
#[doc = "Field `OPA2CALOUT` writer - OPA2 calibration output"]
pub struct OPA2CALOUT_W<'a> {
    w: &'a mut W,
}
impl<'a> OPA2CALOUT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OPA2CALOUT_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "The offset is not trimmed"]
    #[inline(always)]
    pub fn not_trimmed(self) -> &'a mut W {
        self.variant(OPA2CALOUT_A::NOTTRIMMED)
    }
    #[doc = "The offset is trimmed, in calibration mode"]
    #[inline(always)]
    pub fn trimmed(self) -> &'a mut W {
        self.variant(OPA2CALOUT_A::TRIMMED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - OPA0 power down"]
    #[inline(always)]
    pub fn opa0pd(&self) -> OPA0PD_R {
        OPA0PD_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - T3 switch enable for OPA0"]
    #[inline(always)]
    pub fn t3opa0(&self) -> T3OPA0_R {
        T3OPA0_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - S1 switch enable for OPA0"]
    #[inline(always)]
    pub fn s1opa0(&self) -> S1OPA0_R {
        S1OPA0_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - S2 switch enable for OPA0"]
    #[inline(always)]
    pub fn s2opa0(&self) -> S2OPA0_R {
        S2OPA0_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - S3 switch enable for OPA0"]
    #[inline(always)]
    pub fn s3opa0(&self) -> S3OPA0_R {
        S3OPA0_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - OPA0 offset calibration for P diff"]
    #[inline(always)]
    pub fn opa0cal_l(&self) -> OPA0CAL_L_R {
        OPA0CAL_L_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - OPA0 offset calibration for N diff"]
    #[inline(always)]
    pub fn opa0cal_h(&self) -> OPA0CAL_H_R {
        OPA0CAL_H_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - OPA0 low power mode"]
    #[inline(always)]
    pub fn opa0lpm(&self) -> OPA0LPM_R {
        OPA0LPM_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - OPA1 power down"]
    #[inline(always)]
    pub fn opa1pd(&self) -> OPA1PD_R {
        OPA1PD_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - T3 switch enable for OPA1"]
    #[inline(always)]
    pub fn t3opa1(&self) -> T3OPA1_R {
        T3OPA1_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - S1 switch enable for OPA1"]
    #[inline(always)]
    pub fn s1opa1(&self) -> S1OPA1_R {
        S1OPA1_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - S2 switch enable for OPA1"]
    #[inline(always)]
    pub fn s2opa1(&self) -> S2OPA1_R {
        S2OPA1_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - S3 switch enable for OPA1"]
    #[inline(always)]
    pub fn s3opa1(&self) -> S3OPA1_R {
        S3OPA1_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - OPA1 offset calibration for P diff"]
    #[inline(always)]
    pub fn opa1cal_l(&self) -> OPA1CAL_L_R {
        OPA1CAL_L_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - OPA1 offset calibration for N diff"]
    #[inline(always)]
    pub fn opa1cal_h(&self) -> OPA1CAL_H_R {
        OPA1CAL_H_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - OPA1 low power mode"]
    #[inline(always)]
    pub fn opa1lpm(&self) -> OPA1LPM_R {
        OPA1LPM_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - OPA2 power down"]
    #[inline(always)]
    pub fn opa2pd(&self) -> OPA2PD_R {
        OPA2PD_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - T3 switch enable for OPA2"]
    #[inline(always)]
    pub fn t3opa2(&self) -> T3OPA2_R {
        T3OPA2_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - S1 switch enable for OPA2"]
    #[inline(always)]
    pub fn s1opa2(&self) -> S1OPA2_R {
        S1OPA2_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - S2 switch enable for OPA2"]
    #[inline(always)]
    pub fn s2opa2(&self) -> S2OPA2_R {
        S2OPA2_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - S3 switch enable for OPA2"]
    #[inline(always)]
    pub fn s3opa2(&self) -> S3OPA2_R {
        S3OPA2_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 21 - OPA2 offset calibration for P diff"]
    #[inline(always)]
    pub fn opa2cal_l(&self) -> OPA2CAL_L_R {
        OPA2CAL_L_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 22 - OPA2 offset calibration for N diff"]
    #[inline(always)]
    pub fn opa2cal_h(&self) -> OPA2CAL_H_R {
        OPA2CAL_H_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 23 - OPA2 low power mode"]
    #[inline(always)]
    pub fn opa2lpm(&self) -> OPA2LPM_R {
        OPA2LPM_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 27 - S4 switch enable for OPA1"]
    #[inline(always)]
    pub fn s4opa1(&self) -> S4OPA1_R {
        S4OPA1_R::new(((self.bits >> 27) & 0x01) != 0)
    }
    #[doc = "Bit 28 - Power supply range"]
    #[inline(always)]
    pub fn opa_range(&self) -> OPA_RANGE_R {
        OPA_RANGE_R::new(((self.bits >> 28) & 0x01) != 0)
    }
    #[doc = "Bit 29 - OPA0 calibration output"]
    #[inline(always)]
    pub fn opa0calout(&self) -> OPA0CALOUT_R {
        OPA0CALOUT_R::new(((self.bits >> 29) & 0x01) != 0)
    }
    #[doc = "Bit 30 - OPA1 calibration output"]
    #[inline(always)]
    pub fn opa1calout(&self) -> OPA1CALOUT_R {
        OPA1CALOUT_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 31 - OPA2 calibration output"]
    #[inline(always)]
    pub fn opa2calout(&self) -> OPA2CALOUT_R {
        OPA2CALOUT_R::new(((self.bits >> 31) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - OPA0 power down"]
    #[inline(always)]
    pub fn opa0pd(&mut self) -> OPA0PD_W {
        OPA0PD_W { w: self }
    }
    #[doc = "Bit 1 - T3 switch enable for OPA0"]
    #[inline(always)]
    pub fn t3opa0(&mut self) -> T3OPA0_W {
        T3OPA0_W { w: self }
    }
    #[doc = "Bit 2 - S1 switch enable for OPA0"]
    #[inline(always)]
    pub fn s1opa0(&mut self) -> S1OPA0_W {
        S1OPA0_W { w: self }
    }
    #[doc = "Bit 3 - S2 switch enable for OPA0"]
    #[inline(always)]
    pub fn s2opa0(&mut self) -> S2OPA0_W {
        S2OPA0_W { w: self }
    }
    #[doc = "Bit 4 - S3 switch enable for OPA0"]
    #[inline(always)]
    pub fn s3opa0(&mut self) -> S3OPA0_W {
        S3OPA0_W { w: self }
    }
    #[doc = "Bit 5 - OPA0 offset calibration for P diff"]
    #[inline(always)]
    pub fn opa0cal_l(&mut self) -> OPA0CAL_L_W {
        OPA0CAL_L_W { w: self }
    }
    #[doc = "Bit 6 - OPA0 offset calibration for N diff"]
    #[inline(always)]
    pub fn opa0cal_h(&mut self) -> OPA0CAL_H_W {
        OPA0CAL_H_W { w: self }
    }
    #[doc = "Bit 7 - OPA0 low power mode"]
    #[inline(always)]
    pub fn opa0lpm(&mut self) -> OPA0LPM_W {
        OPA0LPM_W { w: self }
    }
    #[doc = "Bit 8 - OPA1 power down"]
    #[inline(always)]
    pub fn opa1pd(&mut self) -> OPA1PD_W {
        OPA1PD_W { w: self }
    }
    #[doc = "Bit 9 - T3 switch enable for OPA1"]
    #[inline(always)]
    pub fn t3opa1(&mut self) -> T3OPA1_W {
        T3OPA1_W { w: self }
    }
    #[doc = "Bit 10 - S1 switch enable for OPA1"]
    #[inline(always)]
    pub fn s1opa1(&mut self) -> S1OPA1_W {
        S1OPA1_W { w: self }
    }
    #[doc = "Bit 11 - S2 switch enable for OPA1"]
    #[inline(always)]
    pub fn s2opa1(&mut self) -> S2OPA1_W {
        S2OPA1_W { w: self }
    }
    #[doc = "Bit 12 - S3 switch enable for OPA1"]
    #[inline(always)]
    pub fn s3opa1(&mut self) -> S3OPA1_W {
        S3OPA1_W { w: self }
    }
    #[doc = "Bit 13 - OPA1 offset calibration for P diff"]
    #[inline(always)]
    pub fn opa1cal_l(&mut self) -> OPA1CAL_L_W {
        OPA1CAL_L_W { w: self }
    }
    #[doc = "Bit 14 - OPA1 offset calibration for N diff"]
    #[inline(always)]
    pub fn opa1cal_h(&mut self) -> OPA1CAL_H_W {
        OPA1CAL_H_W { w: self }
    }
    #[doc = "Bit 15 - OPA1 low power mode"]
    #[inline(always)]
    pub fn opa1lpm(&mut self) -> OPA1LPM_W {
        OPA1LPM_W { w: self }
    }
    #[doc = "Bit 16 - OPA2 power down"]
    #[inline(always)]
    pub fn opa2pd(&mut self) -> OPA2PD_W {
        OPA2PD_W { w: self }
    }
    #[doc = "Bit 17 - T3 switch enable for OPA2"]
    #[inline(always)]
    pub fn t3opa2(&mut self) -> T3OPA2_W {
        T3OPA2_W { w: self }
    }
    #[doc = "Bit 18 - S1 switch enable for OPA2"]
    #[inline(always)]
    pub fn s1opa2(&mut self) -> S1OPA2_W {
        S1OPA2_W { w: self }
    }
    #[doc = "Bit 19 - S2 switch enable for OPA2"]
    #[inline(always)]
    pub fn s2opa2(&mut self) -> S2OPA2_W {
        S2OPA2_W { w: self }
    }
    #[doc = "Bit 20 - S3 switch enable for OPA2"]
    #[inline(always)]
    pub fn s3opa2(&mut self) -> S3OPA2_W {
        S3OPA2_W { w: self }
    }
    #[doc = "Bit 21 - OPA2 offset calibration for P diff"]
    #[inline(always)]
    pub fn opa2cal_l(&mut self) -> OPA2CAL_L_W {
        OPA2CAL_L_W { w: self }
    }
    #[doc = "Bit 22 - OPA2 offset calibration for N diff"]
    #[inline(always)]
    pub fn opa2cal_h(&mut self) -> OPA2CAL_H_W {
        OPA2CAL_H_W { w: self }
    }
    #[doc = "Bit 23 - OPA2 low power mode"]
    #[inline(always)]
    pub fn opa2lpm(&mut self) -> OPA2LPM_W {
        OPA2LPM_W { w: self }
    }
    #[doc = "Bit 27 - S4 switch enable for OPA1"]
    #[inline(always)]
    pub fn s4opa1(&mut self) -> S4OPA1_W {
        S4OPA1_W { w: self }
    }
    #[doc = "Bit 28 - Power supply range"]
    #[inline(always)]
    pub fn opa_range(&mut self) -> OPA_RANGE_W {
        OPA_RANGE_W { w: self }
    }
    #[doc = "Bit 29 - OPA0 calibration output"]
    #[inline(always)]
    pub fn opa0calout(&mut self) -> OPA0CALOUT_W {
        OPA0CALOUT_W { w: self }
    }
    #[doc = "Bit 30 - OPA1 calibration output"]
    #[inline(always)]
    pub fn opa1calout(&mut self) -> OPA1CALOUT_W {
        OPA1CALOUT_W { w: self }
    }
    #[doc = "Bit 31 - OPA2 calibration output"]
    #[inline(always)]
    pub fn opa2calout(&mut self) -> OPA2CALOUT_W {
        OPA2CALOUT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "OPA control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [opa_ctl](index.html) module"]
pub struct OPA_CTL_SPEC;
impl crate::RegisterSpec for OPA_CTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [opa_ctl::R](R) reader structure"]
impl crate::Readable for OPA_CTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [opa_ctl::W](W) writer structure"]
impl crate::Writable for OPA_CTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets OPA_CTL to value 0x0001_0101"]
impl crate::Resettable for OPA_CTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0001_0101
    }
}
