#[doc = "Register `OCTL` reader"]
pub struct R(crate::R<OCTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<OCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<OCTL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<OCTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `OCTL` writer"]
pub struct W(crate::W<OCTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<OCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<OCTL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<OCTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Port output data 15"]
pub type OCTL15_A = OCTL0_A;
#[doc = "Field `OCTL15` reader - Port output data 15"]
pub type OCTL15_R = OCTL0_R;
#[doc = "Field `OCTL15` writer - Port output data 15"]
pub struct OCTL15_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL15_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL15_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL15_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL15_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Port output data 14"]
pub type OCTL14_A = OCTL0_A;
#[doc = "Field `OCTL14` reader - Port output data 14"]
pub type OCTL14_R = OCTL0_R;
#[doc = "Field `OCTL14` writer - Port output data 14"]
pub struct OCTL14_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL14_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL14_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL14_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL14_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Port output data 13"]
pub type OCTL13_A = OCTL0_A;
#[doc = "Field `OCTL13` reader - Port output data 13"]
pub type OCTL13_R = OCTL0_R;
#[doc = "Field `OCTL13` writer - Port output data 13"]
pub struct OCTL13_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL13_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL13_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL13_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL13_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Port output data 12"]
pub type OCTL12_A = OCTL0_A;
#[doc = "Field `OCTL12` reader - Port output data 12"]
pub type OCTL12_R = OCTL0_R;
#[doc = "Field `OCTL12` writer - Port output data 12"]
pub struct OCTL12_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL12_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL12_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL12_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL12_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Port output data 11"]
pub type OCTL11_A = OCTL0_A;
#[doc = "Field `OCTL11` reader - Port output data 11"]
pub type OCTL11_R = OCTL0_R;
#[doc = "Field `OCTL11` writer - Port output data 11"]
pub struct OCTL11_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL11_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL11_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL11_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL11_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Port output data 10"]
pub type OCTL10_A = OCTL0_A;
#[doc = "Field `OCTL10` reader - Port output data 10"]
pub type OCTL10_R = OCTL0_R;
#[doc = "Field `OCTL10` writer - Port output data 10"]
pub struct OCTL10_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL10_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL10_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL10_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL10_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Port output data 9"]
pub type OCTL9_A = OCTL0_A;
#[doc = "Field `OCTL9` reader - Port output data 9"]
pub type OCTL9_R = OCTL0_R;
#[doc = "Field `OCTL9` writer - Port output data 9"]
pub struct OCTL9_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL9_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL9_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL9_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL9_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Port output data 8"]
pub type OCTL8_A = OCTL0_A;
#[doc = "Field `OCTL8` reader - Port output data 8"]
pub type OCTL8_R = OCTL0_R;
#[doc = "Field `OCTL8` writer - Port output data 8"]
pub struct OCTL8_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL8_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL8_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL8_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL8_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Port output data 7"]
pub type OCTL7_A = OCTL0_A;
#[doc = "Field `OCTL7` reader - Port output data 7"]
pub type OCTL7_R = OCTL0_R;
#[doc = "Field `OCTL7` writer - Port output data 7"]
pub struct OCTL7_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL7_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL7_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL7_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL7_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Port output data 6"]
pub type OCTL6_A = OCTL0_A;
#[doc = "Field `OCTL6` reader - Port output data 6"]
pub type OCTL6_R = OCTL0_R;
#[doc = "Field `OCTL6` writer - Port output data 6"]
pub struct OCTL6_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL6_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL6_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL6_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Port output data 5"]
pub type OCTL5_A = OCTL0_A;
#[doc = "Field `OCTL5` reader - Port output data 5"]
pub type OCTL5_R = OCTL0_R;
#[doc = "Field `OCTL5` writer - Port output data 5"]
pub struct OCTL5_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL5_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL5_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL5_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Port output data 4"]
pub type OCTL4_A = OCTL0_A;
#[doc = "Field `OCTL4` reader - Port output data 4"]
pub type OCTL4_R = OCTL0_R;
#[doc = "Field `OCTL4` writer - Port output data 4"]
pub struct OCTL4_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL4_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL4_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL4_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Port output data 3"]
pub type OCTL3_A = OCTL0_A;
#[doc = "Field `OCTL3` reader - Port output data 3"]
pub type OCTL3_R = OCTL0_R;
#[doc = "Field `OCTL3` writer - Port output data 3"]
pub struct OCTL3_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL3_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL3_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL3_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Port output data 2"]
pub type OCTL2_A = OCTL0_A;
#[doc = "Field `OCTL2` reader - Port output data 2"]
pub type OCTL2_R = OCTL0_R;
#[doc = "Field `OCTL2` writer - Port output data 2"]
pub struct OCTL2_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL2_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL2_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Port output data 1"]
pub type OCTL1_A = OCTL0_A;
#[doc = "Field `OCTL1` reader - Port output data 1"]
pub type OCTL1_R = OCTL0_R;
#[doc = "Field `OCTL1` writer - Port output data 1"]
pub struct OCTL1_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL1_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL1_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Port output data 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum OCTL0_A {
    #[doc = "0: Set output to logic low"]
    LOW = 0,
    #[doc = "1: Set output to logic high"]
    HIGH = 1,
}
impl From<OCTL0_A> for bool {
    #[inline(always)]
    fn from(variant: OCTL0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `OCTL0` reader - Port output data 0"]
pub struct OCTL0_R(crate::FieldReader<bool, OCTL0_A>);
impl OCTL0_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCTL0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> OCTL0_A {
        match self.bits {
            false => OCTL0_A::LOW,
            true => OCTL0_A::HIGH,
        }
    }
    #[doc = "Checks if the value of the field is `LOW`"]
    #[inline(always)]
    pub fn is_low(&self) -> bool {
        **self == OCTL0_A::LOW
    }
    #[doc = "Checks if the value of the field is `HIGH`"]
    #[inline(always)]
    pub fn is_high(&self) -> bool {
        **self == OCTL0_A::HIGH
    }
}
impl core::ops::Deref for OCTL0_R {
    type Target = crate::FieldReader<bool, OCTL0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCTL0` writer - Port output data 0"]
pub struct OCTL0_W<'a> {
    w: &'a mut W,
}
impl<'a> OCTL0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OCTL0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Set output to logic low"]
    #[inline(always)]
    pub fn low(self) -> &'a mut W {
        self.variant(OCTL0_A::LOW)
    }
    #[doc = "Set output to logic high"]
    #[inline(always)]
    pub fn high(self) -> &'a mut W {
        self.variant(OCTL0_A::HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - Port output data 15"]
    #[inline(always)]
    pub fn octl15(&self) -> OCTL15_R {
        OCTL15_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Port output data 14"]
    #[inline(always)]
    pub fn octl14(&self) -> OCTL14_R {
        OCTL14_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Port output data 13"]
    #[inline(always)]
    pub fn octl13(&self) -> OCTL13_R {
        OCTL13_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Port output data 12"]
    #[inline(always)]
    pub fn octl12(&self) -> OCTL12_R {
        OCTL12_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Port output data 11"]
    #[inline(always)]
    pub fn octl11(&self) -> OCTL11_R {
        OCTL11_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Port output data 10"]
    #[inline(always)]
    pub fn octl10(&self) -> OCTL10_R {
        OCTL10_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Port output data 9"]
    #[inline(always)]
    pub fn octl9(&self) -> OCTL9_R {
        OCTL9_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Port output data 8"]
    #[inline(always)]
    pub fn octl8(&self) -> OCTL8_R {
        OCTL8_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Port output data 7"]
    #[inline(always)]
    pub fn octl7(&self) -> OCTL7_R {
        OCTL7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Port output data 6"]
    #[inline(always)]
    pub fn octl6(&self) -> OCTL6_R {
        OCTL6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Port output data 5"]
    #[inline(always)]
    pub fn octl5(&self) -> OCTL5_R {
        OCTL5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Port output data 4"]
    #[inline(always)]
    pub fn octl4(&self) -> OCTL4_R {
        OCTL4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Port output data 3"]
    #[inline(always)]
    pub fn octl3(&self) -> OCTL3_R {
        OCTL3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Port output data 2"]
    #[inline(always)]
    pub fn octl2(&self) -> OCTL2_R {
        OCTL2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Port output data 1"]
    #[inline(always)]
    pub fn octl1(&self) -> OCTL1_R {
        OCTL1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Port output data 0"]
    #[inline(always)]
    pub fn octl0(&self) -> OCTL0_R {
        OCTL0_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 15 - Port output data 15"]
    #[inline(always)]
    pub fn octl15(&mut self) -> OCTL15_W {
        OCTL15_W { w: self }
    }
    #[doc = "Bit 14 - Port output data 14"]
    #[inline(always)]
    pub fn octl14(&mut self) -> OCTL14_W {
        OCTL14_W { w: self }
    }
    #[doc = "Bit 13 - Port output data 13"]
    #[inline(always)]
    pub fn octl13(&mut self) -> OCTL13_W {
        OCTL13_W { w: self }
    }
    #[doc = "Bit 12 - Port output data 12"]
    #[inline(always)]
    pub fn octl12(&mut self) -> OCTL12_W {
        OCTL12_W { w: self }
    }
    #[doc = "Bit 11 - Port output data 11"]
    #[inline(always)]
    pub fn octl11(&mut self) -> OCTL11_W {
        OCTL11_W { w: self }
    }
    #[doc = "Bit 10 - Port output data 10"]
    #[inline(always)]
    pub fn octl10(&mut self) -> OCTL10_W {
        OCTL10_W { w: self }
    }
    #[doc = "Bit 9 - Port output data 9"]
    #[inline(always)]
    pub fn octl9(&mut self) -> OCTL9_W {
        OCTL9_W { w: self }
    }
    #[doc = "Bit 8 - Port output data 8"]
    #[inline(always)]
    pub fn octl8(&mut self) -> OCTL8_W {
        OCTL8_W { w: self }
    }
    #[doc = "Bit 7 - Port output data 7"]
    #[inline(always)]
    pub fn octl7(&mut self) -> OCTL7_W {
        OCTL7_W { w: self }
    }
    #[doc = "Bit 6 - Port output data 6"]
    #[inline(always)]
    pub fn octl6(&mut self) -> OCTL6_W {
        OCTL6_W { w: self }
    }
    #[doc = "Bit 5 - Port output data 5"]
    #[inline(always)]
    pub fn octl5(&mut self) -> OCTL5_W {
        OCTL5_W { w: self }
    }
    #[doc = "Bit 4 - Port output data 4"]
    #[inline(always)]
    pub fn octl4(&mut self) -> OCTL4_W {
        OCTL4_W { w: self }
    }
    #[doc = "Bit 3 - Port output data 3"]
    #[inline(always)]
    pub fn octl3(&mut self) -> OCTL3_W {
        OCTL3_W { w: self }
    }
    #[doc = "Bit 2 - Port output data 2"]
    #[inline(always)]
    pub fn octl2(&mut self) -> OCTL2_W {
        OCTL2_W { w: self }
    }
    #[doc = "Bit 1 - Port output data 1"]
    #[inline(always)]
    pub fn octl1(&mut self) -> OCTL1_W {
        OCTL1_W { w: self }
    }
    #[doc = "Bit 0 - Port output data 0"]
    #[inline(always)]
    pub fn octl0(&mut self) -> OCTL0_W {
        OCTL0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "GPIO port output data register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [octl](index.html) module"]
pub struct OCTL_SPEC;
impl crate::RegisterSpec for OCTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [octl::R](R) reader structure"]
impl crate::Readable for OCTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [octl::W](W) writer structure"]
impl crate::Writable for OCTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets OCTL to value 0"]
impl crate::Resettable for OCTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
