#[doc = "Register `INTF` reader"]
pub struct R(crate::R<INTF_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<INTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<INTF_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<INTF_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Global interrupt flag of channel 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum GIF0_A {
    #[doc = "0: No transfer error, half event, complete event"]
    NOEVENT = 0,
    #[doc = "1: A transfer error, half event or complete event has occured"]
    EVENT = 1,
}
impl From<GIF0_A> for bool {
    #[inline(always)]
    fn from(variant: GIF0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `GIF0` reader - Global interrupt flag of channel 0"]
pub struct GIF0_R(crate::FieldReader<bool, GIF0_A>);
impl GIF0_R {
    pub(crate) fn new(bits: bool) -> Self {
        GIF0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> GIF0_A {
        match self.bits {
            false => GIF0_A::NOEVENT,
            true => GIF0_A::EVENT,
        }
    }
    #[doc = "Checks if the value of the field is `NOEVENT`"]
    #[inline(always)]
    pub fn is_no_event(&self) -> bool {
        **self == GIF0_A::NOEVENT
    }
    #[doc = "Checks if the value of the field is `EVENT`"]
    #[inline(always)]
    pub fn is_event(&self) -> bool {
        **self == GIF0_A::EVENT
    }
}
impl core::ops::Deref for GIF0_R {
    type Target = crate::FieldReader<bool, GIF0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Full transfer finish flag of channel 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum FTFIF0_A {
    #[doc = "0: No transfer complete event"]
    NOTCOMPLETE = 0,
    #[doc = "1: A transfer complete event has occured"]
    COMPLETE = 1,
}
impl From<FTFIF0_A> for bool {
    #[inline(always)]
    fn from(variant: FTFIF0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `FTFIF0` reader - Full transfer finish flag of channel 0"]
pub struct FTFIF0_R(crate::FieldReader<bool, FTFIF0_A>);
impl FTFIF0_R {
    pub(crate) fn new(bits: bool) -> Self {
        FTFIF0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> FTFIF0_A {
        match self.bits {
            false => FTFIF0_A::NOTCOMPLETE,
            true => FTFIF0_A::COMPLETE,
        }
    }
    #[doc = "Checks if the value of the field is `NOTCOMPLETE`"]
    #[inline(always)]
    pub fn is_not_complete(&self) -> bool {
        **self == FTFIF0_A::NOTCOMPLETE
    }
    #[doc = "Checks if the value of the field is `COMPLETE`"]
    #[inline(always)]
    pub fn is_complete(&self) -> bool {
        **self == FTFIF0_A::COMPLETE
    }
}
impl core::ops::Deref for FTFIF0_R {
    type Target = crate::FieldReader<bool, FTFIF0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Half transfer finish flag of channel 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum HTFIF0_A {
    #[doc = "0: No half transfer event"]
    NOTHALF = 0,
    #[doc = "1: A half transfer event has occured"]
    HALF = 1,
}
impl From<HTFIF0_A> for bool {
    #[inline(always)]
    fn from(variant: HTFIF0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `HTFIF0` reader - Half transfer finish flag of channel 0"]
pub struct HTFIF0_R(crate::FieldReader<bool, HTFIF0_A>);
impl HTFIF0_R {
    pub(crate) fn new(bits: bool) -> Self {
        HTFIF0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> HTFIF0_A {
        match self.bits {
            false => HTFIF0_A::NOTHALF,
            true => HTFIF0_A::HALF,
        }
    }
    #[doc = "Checks if the value of the field is `NOTHALF`"]
    #[inline(always)]
    pub fn is_not_half(&self) -> bool {
        **self == HTFIF0_A::NOTHALF
    }
    #[doc = "Checks if the value of the field is `HALF`"]
    #[inline(always)]
    pub fn is_half(&self) -> bool {
        **self == HTFIF0_A::HALF
    }
}
impl core::ops::Deref for HTFIF0_R {
    type Target = crate::FieldReader<bool, HTFIF0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Transfer access error flag of channel 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum TAEIF0_A {
    #[doc = "0: No transfer error"]
    NOERROR = 0,
    #[doc = "1: A transfer error has occured"]
    ERROR = 1,
}
impl From<TAEIF0_A> for bool {
    #[inline(always)]
    fn from(variant: TAEIF0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `TAEIF0` reader - Transfer access error flag of channel 0"]
pub struct TAEIF0_R(crate::FieldReader<bool, TAEIF0_A>);
impl TAEIF0_R {
    pub(crate) fn new(bits: bool) -> Self {
        TAEIF0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> TAEIF0_A {
        match self.bits {
            false => TAEIF0_A::NOERROR,
            true => TAEIF0_A::ERROR,
        }
    }
    #[doc = "Checks if the value of the field is `NOERROR`"]
    #[inline(always)]
    pub fn is_no_error(&self) -> bool {
        **self == TAEIF0_A::NOERROR
    }
    #[doc = "Checks if the value of the field is `ERROR`"]
    #[inline(always)]
    pub fn is_error(&self) -> bool {
        **self == TAEIF0_A::ERROR
    }
}
impl core::ops::Deref for TAEIF0_R {
    type Target = crate::FieldReader<bool, TAEIF0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Global interrupt flag of channel 1"]
pub type GIF1_A = GIF0_A;
#[doc = "Field `GIF1` reader - Global interrupt flag of channel 1"]
pub type GIF1_R = GIF0_R;
#[doc = "Full transfer finish flag of channel 1"]
pub type FTFIF1_A = FTFIF0_A;
#[doc = "Field `FTFIF1` reader - Full transfer finish flag of channel 1"]
pub type FTFIF1_R = FTFIF0_R;
#[doc = "Half transfer finish flag of channel 1"]
pub type HTFIF1_A = HTFIF0_A;
#[doc = "Field `HTFIF1` reader - Half transfer finish flag of channel 1"]
pub type HTFIF1_R = HTFIF0_R;
#[doc = "Transfer access error flag of channel 1"]
pub type TAEIF1_A = TAEIF0_A;
#[doc = "Field `TAEIF1` reader - Transfer access error flag of channel 1"]
pub type TAEIF1_R = TAEIF0_R;
#[doc = "Global interrupt flag of channel 2"]
pub type GIF2_A = GIF0_A;
#[doc = "Field `GIF2` reader - Global interrupt flag of channel 2"]
pub type GIF2_R = GIF0_R;
#[doc = "Full transfer finish flag of channel 2"]
pub type FTFIF2_A = FTFIF0_A;
#[doc = "Field `FTFIF2` reader - Full transfer finish flag of channel 2"]
pub type FTFIF2_R = FTFIF0_R;
#[doc = "Half transfer finish flag of channel 2"]
pub type HTFIF2_A = HTFIF0_A;
#[doc = "Field `HTFIF2` reader - Half transfer finish flag of channel 2"]
pub type HTFIF2_R = HTFIF0_R;
#[doc = "Transfer access error flag of channel 2"]
pub type TAEIF2_A = TAEIF0_A;
#[doc = "Field `TAEIF2` reader - Transfer access error flag of channel 2"]
pub type TAEIF2_R = TAEIF0_R;
#[doc = "Global interrupt flag of channel 3"]
pub type GIF3_A = GIF0_A;
#[doc = "Field `GIF3` reader - Global interrupt flag of channel 3"]
pub type GIF3_R = GIF0_R;
#[doc = "Full transfer finish flag of channel 3"]
pub type FTFIF3_A = FTFIF0_A;
#[doc = "Field `FTFIF3` reader - Full transfer finish flag of channel 3"]
pub type FTFIF3_R = FTFIF0_R;
#[doc = "Half transfer finish flag of channel 3"]
pub type HTFIF3_A = HTFIF0_A;
#[doc = "Field `HTFIF3` reader - Half transfer finish flag of channel 3"]
pub type HTFIF3_R = HTFIF0_R;
#[doc = "Transfer access error flag of channel 3"]
pub type TAEIF3_A = TAEIF0_A;
#[doc = "Field `TAEIF3` reader - Transfer access error flag of channel 3"]
pub type TAEIF3_R = TAEIF0_R;
#[doc = "Global interrupt flag of channel 4"]
pub type GIF4_A = GIF0_A;
#[doc = "Field `GIF4` reader - Global interrupt flag of channel 4"]
pub type GIF4_R = GIF0_R;
#[doc = "Full transfer finish flag of channel 4"]
pub type FTFIF4_A = FTFIF0_A;
#[doc = "Field `FTFIF4` reader - Full transfer finish flag of channel 4"]
pub type FTFIF4_R = FTFIF0_R;
#[doc = "Half transfer finish flag of channel 4"]
pub type HTFIF4_A = HTFIF0_A;
#[doc = "Field `HTFIF4` reader - Half transfer finish flag of channel 4"]
pub type HTFIF4_R = HTFIF0_R;
#[doc = "Transfer access error flag of channel 4"]
pub type TAEIF4_A = TAEIF0_A;
#[doc = "Field `TAEIF4` reader - Transfer access error flag of channel 4"]
pub type TAEIF4_R = TAEIF0_R;
#[doc = "Global interrupt flag of channel 5"]
pub type GIF5_A = GIF0_A;
#[doc = "Field `GIF5` reader - Global interrupt flag of channel 5"]
pub type GIF5_R = GIF0_R;
#[doc = "Full transfer finish flag of channel 5"]
pub type FTFIF5_A = FTFIF0_A;
#[doc = "Field `FTFIF5` reader - Full transfer finish flag of channel 5"]
pub type FTFIF5_R = FTFIF0_R;
#[doc = "Half transfer finish flag of channel 5"]
pub type HTFIF5_A = HTFIF0_A;
#[doc = "Field `HTFIF5` reader - Half transfer finish flag of channel 5"]
pub type HTFIF5_R = HTFIF0_R;
#[doc = "Transfer access error flag of channel 5"]
pub type TAEIF5_A = TAEIF0_A;
#[doc = "Field `TAEIF5` reader - Transfer access error flag of channel 5"]
pub type TAEIF5_R = TAEIF0_R;
#[doc = "Global interrupt flag of channel 6"]
pub type GIF6_A = GIF0_A;
#[doc = "Field `GIF6` reader - Global interrupt flag of channel 6"]
pub type GIF6_R = GIF0_R;
#[doc = "Full transfer finish flag of channel 6"]
pub type FTFIF6_A = FTFIF0_A;
#[doc = "Field `FTFIF6` reader - Full transfer finish flag of channel 6"]
pub type FTFIF6_R = FTFIF0_R;
#[doc = "Half transfer finish flag of channel 6"]
pub type HTFIF6_A = HTFIF0_A;
#[doc = "Field `HTFIF6` reader - Half transfer finish flag of channel 6"]
pub type HTFIF6_R = HTFIF0_R;
#[doc = "Transfer access error flag of channel 6"]
pub type TAEIF6_A = TAEIF0_A;
#[doc = "Field `TAEIF6` reader - Transfer access error flag of channel 6"]
pub type TAEIF6_R = TAEIF0_R;
impl R {
    #[doc = "Bit 0 - Global interrupt flag of channel 0"]
    #[inline(always)]
    pub fn gif0(&self) -> GIF0_R {
        GIF0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Full transfer finish flag of channel 0"]
    #[inline(always)]
    pub fn ftfif0(&self) -> FTFIF0_R {
        FTFIF0_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Half transfer finish flag of channel 0"]
    #[inline(always)]
    pub fn htfif0(&self) -> HTFIF0_R {
        HTFIF0_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Transfer access error flag of channel 0"]
    #[inline(always)]
    pub fn taeif0(&self) -> TAEIF0_R {
        TAEIF0_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Global interrupt flag of channel 1"]
    #[inline(always)]
    pub fn gif1(&self) -> GIF1_R {
        GIF1_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Full transfer finish flag of channel 1"]
    #[inline(always)]
    pub fn ftfif1(&self) -> FTFIF1_R {
        FTFIF1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Half transfer finish flag of channel 1"]
    #[inline(always)]
    pub fn htfif1(&self) -> HTFIF1_R {
        HTFIF1_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Transfer access error flag of channel 1"]
    #[inline(always)]
    pub fn taeif1(&self) -> TAEIF1_R {
        TAEIF1_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Global interrupt flag of channel 2"]
    #[inline(always)]
    pub fn gif2(&self) -> GIF2_R {
        GIF2_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Full transfer finish flag of channel 2"]
    #[inline(always)]
    pub fn ftfif2(&self) -> FTFIF2_R {
        FTFIF2_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Half transfer finish flag of channel 2"]
    #[inline(always)]
    pub fn htfif2(&self) -> HTFIF2_R {
        HTFIF2_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Transfer access error flag of channel 2"]
    #[inline(always)]
    pub fn taeif2(&self) -> TAEIF2_R {
        TAEIF2_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Global interrupt flag of channel 3"]
    #[inline(always)]
    pub fn gif3(&self) -> GIF3_R {
        GIF3_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Full transfer finish flag of channel 3"]
    #[inline(always)]
    pub fn ftfif3(&self) -> FTFIF3_R {
        FTFIF3_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Half transfer finish flag of channel 3"]
    #[inline(always)]
    pub fn htfif3(&self) -> HTFIF3_R {
        HTFIF3_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Transfer access error flag of channel 3"]
    #[inline(always)]
    pub fn taeif3(&self) -> TAEIF3_R {
        TAEIF3_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Global interrupt flag of channel 4"]
    #[inline(always)]
    pub fn gif4(&self) -> GIF4_R {
        GIF4_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Full transfer finish flag of channel 4"]
    #[inline(always)]
    pub fn ftfif4(&self) -> FTFIF4_R {
        FTFIF4_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Half transfer finish flag of channel 4"]
    #[inline(always)]
    pub fn htfif4(&self) -> HTFIF4_R {
        HTFIF4_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Transfer access error flag of channel 4"]
    #[inline(always)]
    pub fn taeif4(&self) -> TAEIF4_R {
        TAEIF4_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Global interrupt flag of channel 5"]
    #[inline(always)]
    pub fn gif5(&self) -> GIF5_R {
        GIF5_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 21 - Full transfer finish flag of channel 5"]
    #[inline(always)]
    pub fn ftfif5(&self) -> FTFIF5_R {
        FTFIF5_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 22 - Half transfer finish flag of channel 5"]
    #[inline(always)]
    pub fn htfif5(&self) -> HTFIF5_R {
        HTFIF5_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 23 - Transfer access error flag of channel 5"]
    #[inline(always)]
    pub fn taeif5(&self) -> TAEIF5_R {
        TAEIF5_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 24 - Global interrupt flag of channel 6"]
    #[inline(always)]
    pub fn gif6(&self) -> GIF6_R {
        GIF6_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 25 - Full transfer finish flag of channel 6"]
    #[inline(always)]
    pub fn ftfif6(&self) -> FTFIF6_R {
        FTFIF6_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 26 - Half transfer finish flag of channel 6"]
    #[inline(always)]
    pub fn htfif6(&self) -> HTFIF6_R {
        HTFIF6_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 27 - Transfer access error flag of channel 6"]
    #[inline(always)]
    pub fn taeif6(&self) -> TAEIF6_R {
        TAEIF6_R::new(((self.bits >> 27) & 0x01) != 0)
    }
}
#[doc = "DMA interrupt flag register (DMA_INTF)\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intf](index.html) module"]
pub struct INTF_SPEC;
impl crate::RegisterSpec for INTF_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [intf::R](R) reader structure"]
impl crate::Readable for INTF_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets INTF to value 0"]
impl crate::Resettable for INTF_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
