#[doc = "Register `CS` reader"]
pub struct R(crate::R<CS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CS` writer"]
pub struct W(crate::W<CS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "CMP0 enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CMP0EN_A {
    #[doc = "0: Comparator disabled"]
    DISABLED = 0,
    #[doc = "1: Comparator enabled"]
    ENABLED = 1,
}
impl From<CMP0EN_A> for bool {
    #[inline(always)]
    fn from(variant: CMP0EN_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CMP0EN` reader - CMP0 enable"]
pub struct CMP0EN_R(crate::FieldReader<bool, CMP0EN_A>);
impl CMP0EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMP0EN_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CMP0EN_A {
        match self.bits {
            false => CMP0EN_A::DISABLED,
            true => CMP0EN_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == CMP0EN_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == CMP0EN_A::ENABLED
    }
}
impl core::ops::Deref for CMP0EN_R {
    type Target = crate::FieldReader<bool, CMP0EN_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMP0EN` writer - CMP0 enable"]
pub struct CMP0EN_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP0EN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP0EN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Comparator disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(CMP0EN_A::DISABLED)
    }
    #[doc = "Comparator enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(CMP0EN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "CMP0 switch\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CMP0SW_A {
    #[doc = "0: Switch open"]
    OPEN = 0,
    #[doc = "1: Switch closed"]
    CLOSED = 1,
}
impl From<CMP0SW_A> for bool {
    #[inline(always)]
    fn from(variant: CMP0SW_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CMP0SW` reader - CMP0 switch"]
pub struct CMP0SW_R(crate::FieldReader<bool, CMP0SW_A>);
impl CMP0SW_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMP0SW_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CMP0SW_A {
        match self.bits {
            false => CMP0SW_A::OPEN,
            true => CMP0SW_A::CLOSED,
        }
    }
    #[doc = "Checks if the value of the field is `OPEN`"]
    #[inline(always)]
    pub fn is_open(&self) -> bool {
        **self == CMP0SW_A::OPEN
    }
    #[doc = "Checks if the value of the field is `CLOSED`"]
    #[inline(always)]
    pub fn is_closed(&self) -> bool {
        **self == CMP0SW_A::CLOSED
    }
}
impl core::ops::Deref for CMP0SW_R {
    type Target = crate::FieldReader<bool, CMP0SW_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMP0SW` writer - CMP0 switch"]
pub struct CMP0SW_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP0SW_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP0SW_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Switch open"]
    #[inline(always)]
    pub fn open(self) -> &'a mut W {
        self.variant(CMP0SW_A::OPEN)
    }
    #[doc = "Switch closed"]
    #[inline(always)]
    pub fn closed(self) -> &'a mut W {
        self.variant(CMP0SW_A::CLOSED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "CMP0 mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CMP0M_A {
    #[doc = "0: High speed / full power"]
    HIGHSPEED = 0,
    #[doc = "1: Medium speed / medium power"]
    MEDIUMSPEED = 1,
    #[doc = "2: Low speed / low power"]
    LOWSPEED = 2,
    #[doc = "3: Very-low speed / ultra-low power"]
    VERYLOWSPEED = 3,
}
impl From<CMP0M_A> for u8 {
    #[inline(always)]
    fn from(variant: CMP0M_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CMP0M` reader - CMP0 mode"]
pub struct CMP0M_R(crate::FieldReader<u8, CMP0M_A>);
impl CMP0M_R {
    pub(crate) fn new(bits: u8) -> Self {
        CMP0M_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CMP0M_A {
        match self.bits {
            0 => CMP0M_A::HIGHSPEED,
            1 => CMP0M_A::MEDIUMSPEED,
            2 => CMP0M_A::LOWSPEED,
            3 => CMP0M_A::VERYLOWSPEED,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `HIGHSPEED`"]
    #[inline(always)]
    pub fn is_high_speed(&self) -> bool {
        **self == CMP0M_A::HIGHSPEED
    }
    #[doc = "Checks if the value of the field is `MEDIUMSPEED`"]
    #[inline(always)]
    pub fn is_medium_speed(&self) -> bool {
        **self == CMP0M_A::MEDIUMSPEED
    }
    #[doc = "Checks if the value of the field is `LOWSPEED`"]
    #[inline(always)]
    pub fn is_low_speed(&self) -> bool {
        **self == CMP0M_A::LOWSPEED
    }
    #[doc = "Checks if the value of the field is `VERYLOWSPEED`"]
    #[inline(always)]
    pub fn is_very_low_speed(&self) -> bool {
        **self == CMP0M_A::VERYLOWSPEED
    }
}
impl core::ops::Deref for CMP0M_R {
    type Target = crate::FieldReader<u8, CMP0M_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMP0M` writer - CMP0 mode"]
pub struct CMP0M_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP0M_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP0M_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "High speed / full power"]
    #[inline(always)]
    pub fn high_speed(self) -> &'a mut W {
        self.variant(CMP0M_A::HIGHSPEED)
    }
    #[doc = "Medium speed / medium power"]
    #[inline(always)]
    pub fn medium_speed(self) -> &'a mut W {
        self.variant(CMP0M_A::MEDIUMSPEED)
    }
    #[doc = "Low speed / low power"]
    #[inline(always)]
    pub fn low_speed(self) -> &'a mut W {
        self.variant(CMP0M_A::LOWSPEED)
    }
    #[doc = "Very-low speed / ultra-low power"]
    #[inline(always)]
    pub fn very_low_speed(self) -> &'a mut W {
        self.variant(CMP0M_A::VERYLOWSPEED)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u32 & 0x03) << 2);
        self.w
    }
}
#[doc = "CMP0_M input selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CMP0MSEL_A {
    #[doc = "0: 1/4 of VRefint"]
    ONEQUARTERVREF = 0,
    #[doc = "1: 1/2 of VRefint"]
    ONEHALFVREF = 1,
    #[doc = "2: 3/4 of VRefint"]
    THREEQUARTERVREF = 2,
    #[doc = "3: VRefint"]
    VREF = 3,
    #[doc = "4: PA4 (DAC0"]
    PA4 = 4,
    #[doc = "5: PA5"]
    PA5 = 5,
    #[doc = "6: PA0"]
    PA0 = 6,
}
impl From<CMP0MSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: CMP0MSEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CMP0MSEL` reader - CMP0_M input selection"]
pub struct CMP0MSEL_R(crate::FieldReader<u8, CMP0MSEL_A>);
impl CMP0MSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        CMP0MSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<CMP0MSEL_A> {
        match self.bits {
            0 => Some(CMP0MSEL_A::ONEQUARTERVREF),
            1 => Some(CMP0MSEL_A::ONEHALFVREF),
            2 => Some(CMP0MSEL_A::THREEQUARTERVREF),
            3 => Some(CMP0MSEL_A::VREF),
            4 => Some(CMP0MSEL_A::PA4),
            5 => Some(CMP0MSEL_A::PA5),
            6 => Some(CMP0MSEL_A::PA0),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `ONEQUARTERVREF`"]
    #[inline(always)]
    pub fn is_one_quarter_vref(&self) -> bool {
        **self == CMP0MSEL_A::ONEQUARTERVREF
    }
    #[doc = "Checks if the value of the field is `ONEHALFVREF`"]
    #[inline(always)]
    pub fn is_one_half_vref(&self) -> bool {
        **self == CMP0MSEL_A::ONEHALFVREF
    }
    #[doc = "Checks if the value of the field is `THREEQUARTERVREF`"]
    #[inline(always)]
    pub fn is_three_quarter_vref(&self) -> bool {
        **self == CMP0MSEL_A::THREEQUARTERVREF
    }
    #[doc = "Checks if the value of the field is `VREF`"]
    #[inline(always)]
    pub fn is_vref(&self) -> bool {
        **self == CMP0MSEL_A::VREF
    }
    #[doc = "Checks if the value of the field is `PA4`"]
    #[inline(always)]
    pub fn is_pa4(&self) -> bool {
        **self == CMP0MSEL_A::PA4
    }
    #[doc = "Checks if the value of the field is `PA5`"]
    #[inline(always)]
    pub fn is_pa5(&self) -> bool {
        **self == CMP0MSEL_A::PA5
    }
    #[doc = "Checks if the value of the field is `PA0`"]
    #[inline(always)]
    pub fn is_pa0(&self) -> bool {
        **self == CMP0MSEL_A::PA0
    }
}
impl core::ops::Deref for CMP0MSEL_R {
    type Target = crate::FieldReader<u8, CMP0MSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMP0MSEL` writer - CMP0_M input selection"]
pub struct CMP0MSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP0MSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP0MSEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "1/4 of VRefint"]
    #[inline(always)]
    pub fn one_quarter_vref(self) -> &'a mut W {
        self.variant(CMP0MSEL_A::ONEQUARTERVREF)
    }
    #[doc = "1/2 of VRefint"]
    #[inline(always)]
    pub fn one_half_vref(self) -> &'a mut W {
        self.variant(CMP0MSEL_A::ONEHALFVREF)
    }
    #[doc = "3/4 of VRefint"]
    #[inline(always)]
    pub fn three_quarter_vref(self) -> &'a mut W {
        self.variant(CMP0MSEL_A::THREEQUARTERVREF)
    }
    #[doc = "VRefint"]
    #[inline(always)]
    pub fn vref(self) -> &'a mut W {
        self.variant(CMP0MSEL_A::VREF)
    }
    #[doc = "PA4 (DAC0"]
    #[inline(always)]
    pub fn pa4(self) -> &'a mut W {
        self.variant(CMP0MSEL_A::PA4)
    }
    #[doc = "PA5"]
    #[inline(always)]
    pub fn pa5(self) -> &'a mut W {
        self.variant(CMP0MSEL_A::PA5)
    }
    #[doc = "PA0"]
    #[inline(always)]
    pub fn pa0(self) -> &'a mut W {
        self.variant(CMP0MSEL_A::PA0)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 4)) | ((value as u32 & 0x07) << 4);
        self.w
    }
}
#[doc = "Comparator 0 output selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CMP0OSEL_A {
    #[doc = "0: No selection"]
    NOSELECTION = 0,
    #[doc = "1: Timer 0 break input"]
    TIMER0BREAKINPUT = 1,
    #[doc = "2: Timer 0 Input capture 0"]
    TIMER0INPUTCAPTURE0 = 2,
    #[doc = "3: Timer 0 OCPRE_CLR input"]
    TIMER0OCPRECLEARINPUT = 3,
    #[doc = "4: Timer 1 input capture 3"]
    TIMER1INPUTCAPTURE3 = 4,
    #[doc = "5: Timer 1 OCPRE_CLR input"]
    TIMER1OCPRECLEARINPUT = 5,
    #[doc = "6: Timer 2 input capture 0"]
    TIMER2INPUTCAPTURE0 = 6,
    #[doc = "7: Timer 2 OCPRE_CLR input"]
    TIMER2OCPRECLEARINPUT = 7,
}
impl From<CMP0OSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: CMP0OSEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CMP0OSEL` reader - Comparator 0 output selection"]
pub struct CMP0OSEL_R(crate::FieldReader<u8, CMP0OSEL_A>);
impl CMP0OSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        CMP0OSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CMP0OSEL_A {
        match self.bits {
            0 => CMP0OSEL_A::NOSELECTION,
            1 => CMP0OSEL_A::TIMER0BREAKINPUT,
            2 => CMP0OSEL_A::TIMER0INPUTCAPTURE0,
            3 => CMP0OSEL_A::TIMER0OCPRECLEARINPUT,
            4 => CMP0OSEL_A::TIMER1INPUTCAPTURE3,
            5 => CMP0OSEL_A::TIMER1OCPRECLEARINPUT,
            6 => CMP0OSEL_A::TIMER2INPUTCAPTURE0,
            7 => CMP0OSEL_A::TIMER2OCPRECLEARINPUT,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NOSELECTION`"]
    #[inline(always)]
    pub fn is_no_selection(&self) -> bool {
        **self == CMP0OSEL_A::NOSELECTION
    }
    #[doc = "Checks if the value of the field is `TIMER0BREAKINPUT`"]
    #[inline(always)]
    pub fn is_timer0break_input(&self) -> bool {
        **self == CMP0OSEL_A::TIMER0BREAKINPUT
    }
    #[doc = "Checks if the value of the field is `TIMER0INPUTCAPTURE0`"]
    #[inline(always)]
    pub fn is_timer0input_capture0(&self) -> bool {
        **self == CMP0OSEL_A::TIMER0INPUTCAPTURE0
    }
    #[doc = "Checks if the value of the field is `TIMER0OCPRECLEARINPUT`"]
    #[inline(always)]
    pub fn is_timer0ocpreclear_input(&self) -> bool {
        **self == CMP0OSEL_A::TIMER0OCPRECLEARINPUT
    }
    #[doc = "Checks if the value of the field is `TIMER1INPUTCAPTURE3`"]
    #[inline(always)]
    pub fn is_timer1input_capture3(&self) -> bool {
        **self == CMP0OSEL_A::TIMER1INPUTCAPTURE3
    }
    #[doc = "Checks if the value of the field is `TIMER1OCPRECLEARINPUT`"]
    #[inline(always)]
    pub fn is_timer1ocpreclear_input(&self) -> bool {
        **self == CMP0OSEL_A::TIMER1OCPRECLEARINPUT
    }
    #[doc = "Checks if the value of the field is `TIMER2INPUTCAPTURE0`"]
    #[inline(always)]
    pub fn is_timer2input_capture0(&self) -> bool {
        **self == CMP0OSEL_A::TIMER2INPUTCAPTURE0
    }
    #[doc = "Checks if the value of the field is `TIMER2OCPRECLEARINPUT`"]
    #[inline(always)]
    pub fn is_timer2ocpreclear_input(&self) -> bool {
        **self == CMP0OSEL_A::TIMER2OCPRECLEARINPUT
    }
}
impl core::ops::Deref for CMP0OSEL_R {
    type Target = crate::FieldReader<u8, CMP0OSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMP0OSEL` writer - Comparator 0 output selection"]
pub struct CMP0OSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP0OSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP0OSEL_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No selection"]
    #[inline(always)]
    pub fn no_selection(self) -> &'a mut W {
        self.variant(CMP0OSEL_A::NOSELECTION)
    }
    #[doc = "Timer 0 break input"]
    #[inline(always)]
    pub fn timer0break_input(self) -> &'a mut W {
        self.variant(CMP0OSEL_A::TIMER0BREAKINPUT)
    }
    #[doc = "Timer 0 Input capture 0"]
    #[inline(always)]
    pub fn timer0input_capture0(self) -> &'a mut W {
        self.variant(CMP0OSEL_A::TIMER0INPUTCAPTURE0)
    }
    #[doc = "Timer 0 OCPRE_CLR input"]
    #[inline(always)]
    pub fn timer0ocpreclear_input(self) -> &'a mut W {
        self.variant(CMP0OSEL_A::TIMER0OCPRECLEARINPUT)
    }
    #[doc = "Timer 1 input capture 3"]
    #[inline(always)]
    pub fn timer1input_capture3(self) -> &'a mut W {
        self.variant(CMP0OSEL_A::TIMER1INPUTCAPTURE3)
    }
    #[doc = "Timer 1 OCPRE_CLR input"]
    #[inline(always)]
    pub fn timer1ocpreclear_input(self) -> &'a mut W {
        self.variant(CMP0OSEL_A::TIMER1OCPRECLEARINPUT)
    }
    #[doc = "Timer 2 input capture 0"]
    #[inline(always)]
    pub fn timer2input_capture0(self) -> &'a mut W {
        self.variant(CMP0OSEL_A::TIMER2INPUTCAPTURE0)
    }
    #[doc = "Timer 2 OCPRE_CLR input"]
    #[inline(always)]
    pub fn timer2ocpreclear_input(self) -> &'a mut W {
        self.variant(CMP0OSEL_A::TIMER2OCPRECLEARINPUT)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 8)) | ((value as u32 & 0x07) << 8);
        self.w
    }
}
#[doc = "Polarity of CMP0 output\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CMP0PL_A {
    #[doc = "0: Output is not inverted"]
    NOTINVERTED = 0,
    #[doc = "1: Output is inverted"]
    INVERTED = 1,
}
impl From<CMP0PL_A> for bool {
    #[inline(always)]
    fn from(variant: CMP0PL_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CMP0PL` reader - Polarity of CMP0 output"]
pub struct CMP0PL_R(crate::FieldReader<bool, CMP0PL_A>);
impl CMP0PL_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMP0PL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CMP0PL_A {
        match self.bits {
            false => CMP0PL_A::NOTINVERTED,
            true => CMP0PL_A::INVERTED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTINVERTED`"]
    #[inline(always)]
    pub fn is_not_inverted(&self) -> bool {
        **self == CMP0PL_A::NOTINVERTED
    }
    #[doc = "Checks if the value of the field is `INVERTED`"]
    #[inline(always)]
    pub fn is_inverted(&self) -> bool {
        **self == CMP0PL_A::INVERTED
    }
}
impl core::ops::Deref for CMP0PL_R {
    type Target = crate::FieldReader<bool, CMP0PL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMP0PL` writer - Polarity of CMP0 output"]
pub struct CMP0PL_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP0PL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP0PL_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Output is not inverted"]
    #[inline(always)]
    pub fn not_inverted(self) -> &'a mut W {
        self.variant(CMP0PL_A::NOTINVERTED)
    }
    #[doc = "Output is inverted"]
    #[inline(always)]
    pub fn inverted(self) -> &'a mut W {
        self.variant(CMP0PL_A::INVERTED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "CMP0 hysteresis\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CMP0HST_A {
    #[doc = "0: No hysteresis"]
    NOHYSTERESIS = 0,
    #[doc = "1: Low hysteresis"]
    LOWHYSTERESIS = 1,
    #[doc = "2: Medium hysteresis"]
    MEDIUMHYSTERESIS = 2,
    #[doc = "3: High hysteresis"]
    HIGHHYSTERESIS = 3,
}
impl From<CMP0HST_A> for u8 {
    #[inline(always)]
    fn from(variant: CMP0HST_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CMP0HST` reader - CMP0 hysteresis"]
pub struct CMP0HST_R(crate::FieldReader<u8, CMP0HST_A>);
impl CMP0HST_R {
    pub(crate) fn new(bits: u8) -> Self {
        CMP0HST_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CMP0HST_A {
        match self.bits {
            0 => CMP0HST_A::NOHYSTERESIS,
            1 => CMP0HST_A::LOWHYSTERESIS,
            2 => CMP0HST_A::MEDIUMHYSTERESIS,
            3 => CMP0HST_A::HIGHHYSTERESIS,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NOHYSTERESIS`"]
    #[inline(always)]
    pub fn is_no_hysteresis(&self) -> bool {
        **self == CMP0HST_A::NOHYSTERESIS
    }
    #[doc = "Checks if the value of the field is `LOWHYSTERESIS`"]
    #[inline(always)]
    pub fn is_low_hysteresis(&self) -> bool {
        **self == CMP0HST_A::LOWHYSTERESIS
    }
    #[doc = "Checks if the value of the field is `MEDIUMHYSTERESIS`"]
    #[inline(always)]
    pub fn is_medium_hysteresis(&self) -> bool {
        **self == CMP0HST_A::MEDIUMHYSTERESIS
    }
    #[doc = "Checks if the value of the field is `HIGHHYSTERESIS`"]
    #[inline(always)]
    pub fn is_high_hysteresis(&self) -> bool {
        **self == CMP0HST_A::HIGHHYSTERESIS
    }
}
impl core::ops::Deref for CMP0HST_R {
    type Target = crate::FieldReader<u8, CMP0HST_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMP0HST` writer - CMP0 hysteresis"]
pub struct CMP0HST_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP0HST_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP0HST_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No hysteresis"]
    #[inline(always)]
    pub fn no_hysteresis(self) -> &'a mut W {
        self.variant(CMP0HST_A::NOHYSTERESIS)
    }
    #[doc = "Low hysteresis"]
    #[inline(always)]
    pub fn low_hysteresis(self) -> &'a mut W {
        self.variant(CMP0HST_A::LOWHYSTERESIS)
    }
    #[doc = "Medium hysteresis"]
    #[inline(always)]
    pub fn medium_hysteresis(self) -> &'a mut W {
        self.variant(CMP0HST_A::MEDIUMHYSTERESIS)
    }
    #[doc = "High hysteresis"]
    #[inline(always)]
    pub fn high_hysteresis(self) -> &'a mut W {
        self.variant(CMP0HST_A::HIGHHYSTERESIS)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 12)) | ((value as u32 & 0x03) << 12);
        self.w
    }
}
#[doc = "CMP0 output\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CMP0O_A {
    #[doc = "0: Non-inverting input below inverting input"]
    LOW = 0,
    #[doc = "1: Non-inverting input above inverting input"]
    HIGH = 1,
}
impl From<CMP0O_A> for bool {
    #[inline(always)]
    fn from(variant: CMP0O_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CMP0O` reader - CMP0 output"]
pub struct CMP0O_R(crate::FieldReader<bool, CMP0O_A>);
impl CMP0O_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMP0O_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CMP0O_A {
        match self.bits {
            false => CMP0O_A::LOW,
            true => CMP0O_A::HIGH,
        }
    }
    #[doc = "Checks if the value of the field is `LOW`"]
    #[inline(always)]
    pub fn is_low(&self) -> bool {
        **self == CMP0O_A::LOW
    }
    #[doc = "Checks if the value of the field is `HIGH`"]
    #[inline(always)]
    pub fn is_high(&self) -> bool {
        **self == CMP0O_A::HIGH
    }
}
impl core::ops::Deref for CMP0O_R {
    type Target = crate::FieldReader<bool, CMP0O_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "CMP0 lock\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CMP0LK_A {
    #[doc = "0: Control bits are read-write"]
    READWRITE = 0,
    #[doc = "1: Control bits are read-only"]
    READONLY = 1,
}
impl From<CMP0LK_A> for bool {
    #[inline(always)]
    fn from(variant: CMP0LK_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CMP0LK` reader - CMP0 lock"]
pub struct CMP0LK_R(crate::FieldReader<bool, CMP0LK_A>);
impl CMP0LK_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMP0LK_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CMP0LK_A {
        match self.bits {
            false => CMP0LK_A::READWRITE,
            true => CMP0LK_A::READONLY,
        }
    }
    #[doc = "Checks if the value of the field is `READWRITE`"]
    #[inline(always)]
    pub fn is_read_write(&self) -> bool {
        **self == CMP0LK_A::READWRITE
    }
    #[doc = "Checks if the value of the field is `READONLY`"]
    #[inline(always)]
    pub fn is_read_only(&self) -> bool {
        **self == CMP0LK_A::READONLY
    }
}
impl core::ops::Deref for CMP0LK_R {
    type Target = crate::FieldReader<bool, CMP0LK_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMP0LK` writer - CMP0 lock"]
pub struct CMP0LK_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP0LK_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP0LK_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Control bits are read-write"]
    #[inline(always)]
    pub fn read_write(self) -> &'a mut W {
        self.variant(CMP0LK_A::READWRITE)
    }
    #[doc = "Control bits are read-only"]
    #[inline(always)]
    pub fn read_only(self) -> &'a mut W {
        self.variant(CMP0LK_A::READONLY)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "CMP1 enable"]
pub type CMP1EN_A = CMP0EN_A;
#[doc = "Field `CMP1EN` reader - CMP1 enable"]
pub type CMP1EN_R = CMP0EN_R;
#[doc = "Field `CMP1EN` writer - CMP1 enable"]
pub struct CMP1EN_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP1EN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP1EN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Comparator disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(CMP1EN_A::DISABLED)
    }
    #[doc = "Comparator enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(CMP1EN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "CMP1 mode"]
pub type CMP1M_A = CMP0M_A;
#[doc = "Field `CMP1M` reader - CMP1 mode"]
pub type CMP1M_R = CMP0M_R;
#[doc = "Field `CMP1M` writer - CMP1 mode"]
pub struct CMP1M_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP1M_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP1M_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "High speed / full power"]
    #[inline(always)]
    pub fn high_speed(self) -> &'a mut W {
        self.variant(CMP1M_A::HIGHSPEED)
    }
    #[doc = "Medium speed / medium power"]
    #[inline(always)]
    pub fn medium_speed(self) -> &'a mut W {
        self.variant(CMP1M_A::MEDIUMSPEED)
    }
    #[doc = "Low speed / low power"]
    #[inline(always)]
    pub fn low_speed(self) -> &'a mut W {
        self.variant(CMP1M_A::LOWSPEED)
    }
    #[doc = "Very-low speed / ultra-low power"]
    #[inline(always)]
    pub fn very_low_speed(self) -> &'a mut W {
        self.variant(CMP1M_A::VERYLOWSPEED)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 18)) | ((value as u32 & 0x03) << 18);
        self.w
    }
}
#[doc = "CMP1_M input selection"]
pub type CMP1MSEL_A = CMP0MSEL_A;
#[doc = "Field `CMP1MSEL` reader - CMP1_M input selection"]
pub type CMP1MSEL_R = CMP0MSEL_R;
#[doc = "Field `CMP1MSEL` writer - CMP1_M input selection"]
pub struct CMP1MSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP1MSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP1MSEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "1/4 of VRefint"]
    #[inline(always)]
    pub fn one_quarter_vref(self) -> &'a mut W {
        self.variant(CMP1MSEL_A::ONEQUARTERVREF)
    }
    #[doc = "1/2 of VRefint"]
    #[inline(always)]
    pub fn one_half_vref(self) -> &'a mut W {
        self.variant(CMP1MSEL_A::ONEHALFVREF)
    }
    #[doc = "3/4 of VRefint"]
    #[inline(always)]
    pub fn three_quarter_vref(self) -> &'a mut W {
        self.variant(CMP1MSEL_A::THREEQUARTERVREF)
    }
    #[doc = "VRefint"]
    #[inline(always)]
    pub fn vref(self) -> &'a mut W {
        self.variant(CMP1MSEL_A::VREF)
    }
    #[doc = "PA4 (DAC0"]
    #[inline(always)]
    pub fn pa4(self) -> &'a mut W {
        self.variant(CMP1MSEL_A::PA4)
    }
    #[doc = "PA5"]
    #[inline(always)]
    pub fn pa5(self) -> &'a mut W {
        self.variant(CMP1MSEL_A::PA5)
    }
    #[doc = "PA0"]
    #[inline(always)]
    pub fn pa0(self) -> &'a mut W {
        self.variant(CMP1MSEL_A::PA0)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 20)) | ((value as u32 & 0x07) << 20);
        self.w
    }
}
#[doc = "Window mode enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum WNDEN_A {
    #[doc = "0: Window mode disabled"]
    DISABLED = 0,
    #[doc = "1: Window mode enabled"]
    ENABLED = 1,
}
impl From<WNDEN_A> for bool {
    #[inline(always)]
    fn from(variant: WNDEN_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `WNDEN` reader - Window mode enable"]
pub struct WNDEN_R(crate::FieldReader<bool, WNDEN_A>);
impl WNDEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        WNDEN_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> WNDEN_A {
        match self.bits {
            false => WNDEN_A::DISABLED,
            true => WNDEN_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == WNDEN_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == WNDEN_A::ENABLED
    }
}
impl core::ops::Deref for WNDEN_R {
    type Target = crate::FieldReader<bool, WNDEN_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WNDEN` writer - Window mode enable"]
pub struct WNDEN_W<'a> {
    w: &'a mut W,
}
impl<'a> WNDEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WNDEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Window mode disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(WNDEN_A::DISABLED)
    }
    #[doc = "Window mode enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(WNDEN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "CMP1 output selection"]
pub type CMP1OSEL_A = CMP0OSEL_A;
#[doc = "Field `CMP1OSEL` reader - CMP1 output selection"]
pub type CMP1OSEL_R = CMP0OSEL_R;
#[doc = "Field `CMP1OSEL` writer - CMP1 output selection"]
pub struct CMP1OSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP1OSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP1OSEL_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No selection"]
    #[inline(always)]
    pub fn no_selection(self) -> &'a mut W {
        self.variant(CMP1OSEL_A::NOSELECTION)
    }
    #[doc = "Timer 0 break input"]
    #[inline(always)]
    pub fn timer0break_input(self) -> &'a mut W {
        self.variant(CMP1OSEL_A::TIMER0BREAKINPUT)
    }
    #[doc = "Timer 0 Input capture 0"]
    #[inline(always)]
    pub fn timer0input_capture0(self) -> &'a mut W {
        self.variant(CMP1OSEL_A::TIMER0INPUTCAPTURE0)
    }
    #[doc = "Timer 0 OCPRE_CLR input"]
    #[inline(always)]
    pub fn timer0ocpreclear_input(self) -> &'a mut W {
        self.variant(CMP1OSEL_A::TIMER0OCPRECLEARINPUT)
    }
    #[doc = "Timer 1 input capture 3"]
    #[inline(always)]
    pub fn timer1input_capture3(self) -> &'a mut W {
        self.variant(CMP1OSEL_A::TIMER1INPUTCAPTURE3)
    }
    #[doc = "Timer 1 OCPRE_CLR input"]
    #[inline(always)]
    pub fn timer1ocpreclear_input(self) -> &'a mut W {
        self.variant(CMP1OSEL_A::TIMER1OCPRECLEARINPUT)
    }
    #[doc = "Timer 2 input capture 0"]
    #[inline(always)]
    pub fn timer2input_capture0(self) -> &'a mut W {
        self.variant(CMP1OSEL_A::TIMER2INPUTCAPTURE0)
    }
    #[doc = "Timer 2 OCPRE_CLR input"]
    #[inline(always)]
    pub fn timer2ocpreclear_input(self) -> &'a mut W {
        self.variant(CMP1OSEL_A::TIMER2OCPRECLEARINPUT)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 24)) | ((value as u32 & 0x07) << 24);
        self.w
    }
}
#[doc = "Polarity of CMP1 output"]
pub type CMP1PL_A = CMP0PL_A;
#[doc = "Field `CMP1PL` reader - Polarity of CMP1 output"]
pub type CMP1PL_R = CMP0PL_R;
#[doc = "Field `CMP1PL` writer - Polarity of CMP1 output"]
pub struct CMP1PL_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP1PL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP1PL_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Output is not inverted"]
    #[inline(always)]
    pub fn not_inverted(self) -> &'a mut W {
        self.variant(CMP1PL_A::NOTINVERTED)
    }
    #[doc = "Output is inverted"]
    #[inline(always)]
    pub fn inverted(self) -> &'a mut W {
        self.variant(CMP1PL_A::INVERTED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
#[doc = "CMP1 hysteresis"]
pub type CMP1HST_A = CMP0HST_A;
#[doc = "Field `CMP1HST` reader - CMP1 hysteresis"]
pub type CMP1HST_R = CMP0HST_R;
#[doc = "Field `CMP1HST` writer - CMP1 hysteresis"]
pub struct CMP1HST_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP1HST_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP1HST_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No hysteresis"]
    #[inline(always)]
    pub fn no_hysteresis(self) -> &'a mut W {
        self.variant(CMP1HST_A::NOHYSTERESIS)
    }
    #[doc = "Low hysteresis"]
    #[inline(always)]
    pub fn low_hysteresis(self) -> &'a mut W {
        self.variant(CMP1HST_A::LOWHYSTERESIS)
    }
    #[doc = "Medium hysteresis"]
    #[inline(always)]
    pub fn medium_hysteresis(self) -> &'a mut W {
        self.variant(CMP1HST_A::MEDIUMHYSTERESIS)
    }
    #[doc = "High hysteresis"]
    #[inline(always)]
    pub fn high_hysteresis(self) -> &'a mut W {
        self.variant(CMP1HST_A::HIGHHYSTERESIS)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 28)) | ((value as u32 & 0x03) << 28);
        self.w
    }
}
#[doc = "CMP1 output"]
pub type CMP1O_A = CMP0O_A;
#[doc = "Field `CMP1O` reader - CMP1 output"]
pub type CMP1O_R = CMP0O_R;
#[doc = "CMP1 lock"]
pub type CMP1LK_A = CMP0LK_A;
#[doc = "Field `CMP1LK` reader - CMP1 lock"]
pub type CMP1LK_R = CMP0LK_R;
#[doc = "Field `CMP1LK` writer - CMP1 lock"]
pub struct CMP1LK_W<'a> {
    w: &'a mut W,
}
impl<'a> CMP1LK_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMP1LK_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Control bits are read-write"]
    #[inline(always)]
    pub fn read_write(self) -> &'a mut W {
        self.variant(CMP1LK_A::READWRITE)
    }
    #[doc = "Control bits are read-only"]
    #[inline(always)]
    pub fn read_only(self) -> &'a mut W {
        self.variant(CMP1LK_A::READONLY)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - CMP0 enable"]
    #[inline(always)]
    pub fn cmp0en(&self) -> CMP0EN_R {
        CMP0EN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - CMP0 switch"]
    #[inline(always)]
    pub fn cmp0sw(&self) -> CMP0SW_R {
        CMP0SW_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 2:3 - CMP0 mode"]
    #[inline(always)]
    pub fn cmp0m(&self) -> CMP0M_R {
        CMP0M_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:6 - CMP0_M input selection"]
    #[inline(always)]
    pub fn cmp0msel(&self) -> CMP0MSEL_R {
        CMP0MSEL_R::new(((self.bits >> 4) & 0x07) as u8)
    }
    #[doc = "Bits 8:10 - Comparator 0 output selection"]
    #[inline(always)]
    pub fn cmp0osel(&self) -> CMP0OSEL_R {
        CMP0OSEL_R::new(((self.bits >> 8) & 0x07) as u8)
    }
    #[doc = "Bit 11 - Polarity of CMP0 output"]
    #[inline(always)]
    pub fn cmp0pl(&self) -> CMP0PL_R {
        CMP0PL_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bits 12:13 - CMP0 hysteresis"]
    #[inline(always)]
    pub fn cmp0hst(&self) -> CMP0HST_R {
        CMP0HST_R::new(((self.bits >> 12) & 0x03) as u8)
    }
    #[doc = "Bit 14 - CMP0 output"]
    #[inline(always)]
    pub fn cmp0o(&self) -> CMP0O_R {
        CMP0O_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - CMP0 lock"]
    #[inline(always)]
    pub fn cmp0lk(&self) -> CMP0LK_R {
        CMP0LK_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - CMP1 enable"]
    #[inline(always)]
    pub fn cmp1en(&self) -> CMP1EN_R {
        CMP1EN_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bits 18:19 - CMP1 mode"]
    #[inline(always)]
    pub fn cmp1m(&self) -> CMP1M_R {
        CMP1M_R::new(((self.bits >> 18) & 0x03) as u8)
    }
    #[doc = "Bits 20:22 - CMP1_M input selection"]
    #[inline(always)]
    pub fn cmp1msel(&self) -> CMP1MSEL_R {
        CMP1MSEL_R::new(((self.bits >> 20) & 0x07) as u8)
    }
    #[doc = "Bit 23 - Window mode enable"]
    #[inline(always)]
    pub fn wnden(&self) -> WNDEN_R {
        WNDEN_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bits 24:26 - CMP1 output selection"]
    #[inline(always)]
    pub fn cmp1osel(&self) -> CMP1OSEL_R {
        CMP1OSEL_R::new(((self.bits >> 24) & 0x07) as u8)
    }
    #[doc = "Bit 27 - Polarity of CMP1 output"]
    #[inline(always)]
    pub fn cmp1pl(&self) -> CMP1PL_R {
        CMP1PL_R::new(((self.bits >> 27) & 0x01) != 0)
    }
    #[doc = "Bits 28:29 - CMP1 hysteresis"]
    #[inline(always)]
    pub fn cmp1hst(&self) -> CMP1HST_R {
        CMP1HST_R::new(((self.bits >> 28) & 0x03) as u8)
    }
    #[doc = "Bit 30 - CMP1 output"]
    #[inline(always)]
    pub fn cmp1o(&self) -> CMP1O_R {
        CMP1O_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 31 - CMP1 lock"]
    #[inline(always)]
    pub fn cmp1lk(&self) -> CMP1LK_R {
        CMP1LK_R::new(((self.bits >> 31) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - CMP0 enable"]
    #[inline(always)]
    pub fn cmp0en(&mut self) -> CMP0EN_W {
        CMP0EN_W { w: self }
    }
    #[doc = "Bit 1 - CMP0 switch"]
    #[inline(always)]
    pub fn cmp0sw(&mut self) -> CMP0SW_W {
        CMP0SW_W { w: self }
    }
    #[doc = "Bits 2:3 - CMP0 mode"]
    #[inline(always)]
    pub fn cmp0m(&mut self) -> CMP0M_W {
        CMP0M_W { w: self }
    }
    #[doc = "Bits 4:6 - CMP0_M input selection"]
    #[inline(always)]
    pub fn cmp0msel(&mut self) -> CMP0MSEL_W {
        CMP0MSEL_W { w: self }
    }
    #[doc = "Bits 8:10 - Comparator 0 output selection"]
    #[inline(always)]
    pub fn cmp0osel(&mut self) -> CMP0OSEL_W {
        CMP0OSEL_W { w: self }
    }
    #[doc = "Bit 11 - Polarity of CMP0 output"]
    #[inline(always)]
    pub fn cmp0pl(&mut self) -> CMP0PL_W {
        CMP0PL_W { w: self }
    }
    #[doc = "Bits 12:13 - CMP0 hysteresis"]
    #[inline(always)]
    pub fn cmp0hst(&mut self) -> CMP0HST_W {
        CMP0HST_W { w: self }
    }
    #[doc = "Bit 15 - CMP0 lock"]
    #[inline(always)]
    pub fn cmp0lk(&mut self) -> CMP0LK_W {
        CMP0LK_W { w: self }
    }
    #[doc = "Bit 16 - CMP1 enable"]
    #[inline(always)]
    pub fn cmp1en(&mut self) -> CMP1EN_W {
        CMP1EN_W { w: self }
    }
    #[doc = "Bits 18:19 - CMP1 mode"]
    #[inline(always)]
    pub fn cmp1m(&mut self) -> CMP1M_W {
        CMP1M_W { w: self }
    }
    #[doc = "Bits 20:22 - CMP1_M input selection"]
    #[inline(always)]
    pub fn cmp1msel(&mut self) -> CMP1MSEL_W {
        CMP1MSEL_W { w: self }
    }
    #[doc = "Bit 23 - Window mode enable"]
    #[inline(always)]
    pub fn wnden(&mut self) -> WNDEN_W {
        WNDEN_W { w: self }
    }
    #[doc = "Bits 24:26 - CMP1 output selection"]
    #[inline(always)]
    pub fn cmp1osel(&mut self) -> CMP1OSEL_W {
        CMP1OSEL_W { w: self }
    }
    #[doc = "Bit 27 - Polarity of CMP1 output"]
    #[inline(always)]
    pub fn cmp1pl(&mut self) -> CMP1PL_W {
        CMP1PL_W { w: self }
    }
    #[doc = "Bits 28:29 - CMP1 hysteresis"]
    #[inline(always)]
    pub fn cmp1hst(&mut self) -> CMP1HST_W {
        CMP1HST_W { w: self }
    }
    #[doc = "Bit 31 - CMP1 lock"]
    #[inline(always)]
    pub fn cmp1lk(&mut self) -> CMP1LK_W {
        CMP1LK_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "control and status register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cs](index.html) module"]
pub struct CS_SPEC;
impl crate::RegisterSpec for CS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [cs::R](R) reader structure"]
impl crate::Readable for CS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cs::W](W) writer structure"]
impl crate::Writable for CS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CS to value 0"]
impl crate::Resettable for CS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
